/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.runner.graal;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.runner.ShowdownService;
import com.cobblemon.mod.common.battles.runner.graal.GraalLogger;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownUnbundler;
import com.cobblemon.mod.relocations.graalvm.polyglot.Context;
import com.cobblemon.mod.relocations.graalvm.polyglot.HostAccess;
import com.cobblemon.mod.relocations.graalvm.polyglot.PolyglotAccess;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.cobblemon.mod.relocations.graalvm.polyglot.io.FileSystem;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J%\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J+\u0010\u001a\u001a\u00020\u00042\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b \u0010\u0003J\u000f\u0010!\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\u0003J%\u0010\"\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\"\u0010\u0013J\u001f\u0010$\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b$\u0010\u001dJ\u0017\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b%\u0010\u001fR\"\u0010'\u001a\u00020&8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\"\u0010.\u001a\u00020-8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0017\u00105\u001a\u0002048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u0017\u0010:\u001a\u0002098\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\u00a8\u0006>"}, d2={"Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownService;", "Lcom/cobblemon/mod/common/battles/runner/ShowdownService;", "<init>", "()V", "", "openConnection", "createContext", "closeConnection", "boot", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "", "messages", "startBattle", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;[Ljava/lang/String;)V", "Ljava/util/UUID;", "battleId", "send", "(Ljava/util/UUID;[Ljava/lang/String;)V", "type", "Lcom/google/gson/JsonArray;", "getRegistryData", "(Ljava/lang/String;)Lcom/google/gson/JsonArray;", "", "data", "sendRegistryData", "(Ljava/util/Map;Ljava/lang/String;)V", "sendRegistryEntry", "(Ljava/lang/String;Ljava/lang/String;)V", "resetRegistryData", "(Ljava/lang/String;)V", "resetAllRegistries", "indicateSpeciesInitialized", "sendToShowdown", "message", "sendFromShowdown", "log", "Lcom/cobblemon/mod/relocations/graalvm/polyglot/Context;", "context", "Lcom/cobblemon/mod/relocations/graalvm/polyglot/Context;", "getContext", "()Lorg/graalvm/polyglot/Context;", "setContext", "(Lorg/graalvm/polyglot/Context;)V", "Lcom/cobblemon/mod/relocations/graalvm/polyglot/Value;", "sendBattleMessageFunction", "Lcom/cobblemon/mod/relocations/graalvm/polyglot/Value;", "getSendBattleMessageFunction", "()Lorg/graalvm/polyglot/Value;", "setSendBattleMessageFunction", "(Lorg/graalvm/polyglot/Value;)V", "Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "unbundler", "Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "getUnbundler", "()Lcom/cobblemon/mod/common/battles/runner/graal/GraalShowdownUnbundler;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "common"})
public final class GraalShowdownService
implements ShowdownService {
    public transient Context context;
    public transient Value sendBattleMessageFunction;
    @NotNull
    private final transient GraalShowdownUnbundler unbundler = new GraalShowdownUnbundler();
    @NotNull
    private final transient Gson gson = new Gson();

    @NotNull
    public final Context getContext() {
        Context context = this.context;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        return null;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @NotNull
    public final Value getSendBattleMessageFunction() {
        Value value = this.sendBattleMessageFunction;
        if (value != null) {
            return value;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sendBattleMessageFunction");
        return null;
    }

    public final void setSendBattleMessageFunction(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"<set-?>");
        this.sendBattleMessageFunction = value;
    }

    @NotNull
    public final GraalShowdownUnbundler getUnbundler() {
        return this.unbundler;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @Override
    public void openConnection() {
        this.unbundler.attemptUnbundle();
        this.createContext();
        this.boot();
    }

    private final void createContext() {
        Path wd = Paths.get("./showdown", new String[0]);
        HostAccess access = HostAccess.newBuilder(HostAccess.EXPLICIT).allowIterableAccess(true).allowArrayAccess(true).allowListAccess(true).allowMapAccess(true).build();
        String[] stringArray = new String[]{"js"};
        Context context = Context.newBuilder(stringArray).allowIO(true).fileSystem(new FileSystem(wd){
            private final FileSystem default;
            final /* synthetic */ Path $wd;
            {
                this.$wd = $wd;
                this.default = FileSystem.newDefaultFileSystem();
            }

            public final FileSystem getDefault() {
                return this.default;
            }

            public Path parsePath(URI uri) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                return this.default.parsePath(uri);
            }

            public Path parsePath(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return this.default.parsePath(path);
            }

            public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
                this.default.createDirectory(dir, Arrays.copyOf(attrs, attrs.length));
            }

            public void delete(Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                this.default.delete(path);
            }

            public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(options, (String)"options");
                Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
                return this.default.newByteChannel(path, options, Arrays.copyOf(attrs, attrs.length));
            }

            public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter(filter, (String)"filter");
                return this.default.newDirectoryStream(dir, filter);
            }

            public Path toAbsolutePath(Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return this.default.toAbsolutePath(path);
            }

            public Path toRealPath(Path path, LinkOption ... linkOptions) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)linkOptions, (String)"linkOptions");
                return this.default.toRealPath(path, Arrays.copyOf(linkOptions, linkOptions.length));
            }

            public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                return this.default.readAttributes(path, attributes, Arrays.copyOf(options, options.length));
            }

            public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter(modes, (String)"modes");
                Intrinsics.checkNotNullParameter((Object)linkOptions, (String)"linkOptions");
                LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                Path path2 = path.toRealPath(linkOptionArray);
                linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                if (!path2.startsWith(this.$wd.toRealPath(linkOptionArray))) {
                    Cobblemon.LOGGER.error("Hacked JS files in datapacks or some weird file system setup that Hiroku failed to anticipate.");
                    throw new IOException("Someone has put hacked JS files into datapacks because file access is being attempted outside of controlled folders.");
                }
            }
        }).allowExperimentalOptions(true).allowPolyglotAccess(PolyglotAccess.ALL).allowHostAccess(access).allowCreateThread(true).logHandler(GraalLogger.INSTANCE).option("engine.WarnInterpreterOnly", "false").option("js.commonjs-require", "true").option("js.commonjs-require-cwd", "showdown").option("js.commonjs-core-modules-replacements", "buffer:buffer/,crypto:crypto-browserify,path:path-browserify").allowHostClassLoading(true).allowNativeAccess(true).allowCreateProcess(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"build(...)");
        this.setContext(context);
        this.getContext().eval("js", "globalThis.process = {\n    cwd: function() {\n        return '';\n    }\n}");
    }

    @Override
    public void closeConnection() {
        this.getContext().close();
    }

    private final void boot() {
        this.getContext().eval("js", FilesKt.readText$default((File)new File("showdown/index.js"), null, (int)1, null));
        Value value = this.getContext().getBindings("js").getMember("sendBattleMessage");
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"getMember(...)");
        this.setSendBattleMessageFunction(value);
    }

    @Override
    public void startBattle(@NotNull PokemonBattle battle, @NotNull String[] messages) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        Value startBattleFunction = this.getContext().getBindings("js").getMember("startBattle");
        Object[] objectArray = new Object[]{this, battle.getBattleId().toString(), messages};
        startBattleFunction.execute(objectArray);
    }

    @Override
    public void send(@NotNull UUID battleId, @NotNull String[] messages) {
        Intrinsics.checkNotNullParameter((Object)battleId, (String)"battleId");
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        this.sendToShowdown(battleId, messages);
    }

    @Override
    @NotNull
    public JsonArray getRegistryData(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Value func = this.getContext().getBindings("js").getMember("getData");
        Object[] objectArray = new Object[]{type};
        String result = func.execute(objectArray).asString();
        Object object = this.gson.fromJson(result, JsonArray.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (JsonArray)object;
    }

    @Override
    public void sendRegistryData(@NotNull Map<String, String> data, @NotNull String type) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String payload = CollectionsKt.joinToString$default((Iterable)data.entrySet(), null, (CharSequence)"{", (CharSequence)"}", (int)0, null, GraalShowdownService::sendRegistryData$lambda$0, (int)25, null);
        Value func = this.getContext().getBindings("js").getMember("receiveData");
        Object[] objectArray = new Object[]{payload, type};
        func.execute(objectArray);
    }

    @Override
    public void sendRegistryEntry(@NotNull String data, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CharSequence charSequence = data;
        Object[] objectArray = new Regex("[\r\n]+");
        String string = " ";
        String payload = objectArray.replace(charSequence, string);
        Value func = this.getContext().getBindings("js").getMember("receiveData");
        objectArray = new Object[]{payload, type};
        func.execute(objectArray);
    }

    @Override
    public void resetRegistryData(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object[] objectArray = new Object[]{type};
        this.getContext().getBindings("js").getMember("resetData").execute(objectArray);
    }

    @Override
    public void resetAllRegistries() {
        this.getContext().getBindings("js").getMember("resetAll").execute(new Object[0]);
    }

    @Override
    public void indicateSpeciesInitialized() {
        Value func = this.getContext().getBindings("js").getMember("afterSpeciesInit");
        func.execute(new Object[0]);
    }

    private final void sendToShowdown(UUID battleId, String[] messages) {
        Object[] objectArray = new Object[]{battleId.toString(), messages};
        this.getSendBattleMessageFunction().execute(objectArray);
    }

    @HostAccess.Export
    public final void sendFromShowdown(@NotNull String battleId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)battleId, (String)"battleId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        UUID uUID = UUID.fromString(battleId);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        ShowdownInterpreter.INSTANCE.interpretMessage(uUID, message);
    }

    @HostAccess.Export
    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Cobblemon.LOGGER.info(message);
    }

    private static final CharSequence sendRegistryData$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String k = (String)entry.getKey();
        String v = (String)entry.getValue();
        CharSequence charSequence = v;
        Regex regex = new Regex("[\r\n]+");
        String string = " ";
        String newV = regex.replace(charSequence, string);
        return "\"" + k + "\": " + newV;
    }
}

