/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/battles/AlreadyInBattleError;", "Lcom/cobblemon/mod/common/battles/BattleStartError;", "Ljava/util/UUID;", "actorUUID", "Lnet/minecraft/network/chat/Component;", "name", "<init>", "(Ljava/util/UUID;Lnet/minecraft/network/chat/Component;)V", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/network/chat/MutableComponent;", "getMessageFor", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/network/chat/MutableComponent;", "Ljava/util/UUID;", "getActorUUID", "()Ljava/util/UUID;", "Lnet/minecraft/network/chat/Component;", "getName", "()Lnet/minecraft/network/chat/Component;", "common"})
public final class AlreadyInBattleError
implements BattleStartError {
    @NotNull
    private final UUID actorUUID;
    @NotNull
    private final Component name;

    public AlreadyInBattleError(@NotNull UUID actorUUID, @NotNull Component name) {
        Intrinsics.checkNotNullParameter((Object)actorUUID, (String)"actorUUID");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actorUUID = actorUUID;
        this.name = name;
    }

    @NotNull
    public final UUID getActorUUID() {
        return this.actorUUID;
    }

    @NotNull
    public final Component getName() {
        return this.name;
    }

    @Override
    @NotNull
    public MutableComponent getMessageFor(@NotNull Entity entity) {
        MutableComponent mutableComponent;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (Intrinsics.areEqual((Object)this.actorUUID, (Object)entity.getUUID())) {
            MutableComponent mutableComponent2 = LocalizationUtilsKt.battleLang("error.in_battle.personal", new Object[0]);
            Intrinsics.checkNotNull((Object)mutableComponent2);
            mutableComponent = mutableComponent2;
        } else {
            Object[] objectArray = new Object[]{this.name};
            MutableComponent mutableComponent3 = LocalizationUtilsKt.battleLang("error.in_battle", objectArray);
            Intrinsics.checkNotNull((Object)mutableComponent3);
            mutableComponent = mutableComponent3;
        }
        return mutableComponent;
    }
}

