/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.Targetable;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\r\u0010 \u001a\u00020\u001a\u00a2\u0006\u0004\b \u0010\u001eJ\u000f\u0010\"\u001a\u0004\u0018\u00010!\u00a2\u0006\u0004\b\"\u0010#R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&R$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0017\u0010-\u001a\u00020,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R0\u00103\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020!\u0018\u0001018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R$\u00109\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010'\u001a\u0004\b:\u0010)\"\u0004\b;\u0010+\u00a8\u0006<"}, d2={"Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;", "Lcom/cobblemon/mod/common/battles/Targetable;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "actor", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "<init>", "(Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "Lcom/cobblemon/mod/common/battles/BattleSide;", "getSide", "()Lcom/cobblemon/mod/common/battles/BattleSide;", "", "getAllActivePokemon", "()Ljava/lang/Iterable;", "", "getActorShowdownId", "()Ljava/lang/String;", "", "getActorPokemon", "()Ljava/util/List;", "", "getSidePokemon", "Lcom/cobblemon/mod/common/battles/BattleFormat;", "getFormat", "()Lcom/cobblemon/mod/common/battles/BattleFormat;", "other", "", "isAllied", "(Lcom/cobblemon/mod/common/battles/Targetable;)Z", "hasPokemon", "()Z", "isGone", "isAlive", "Lnet/minecraft/world/phys/Vec3;", "getSendOutPosition", "()Lnet/minecraft/world/phys/Vec3;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "getActor", "()Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "getBattlePokemon", "()Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "setBattlePokemon", "(Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "getBattle", "()Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "Lkotlin/Pair;", "Lnet/minecraft/server/level/ServerLevel;", "position", "Lkotlin/Pair;", "getPosition", "()Lkotlin/Pair;", "setPosition", "(Lkotlin/Pair;)V", "illusion", "getIllusion", "setIllusion", "common"})
@SourceDebugExtension(value={"SMAP\nActiveBattlePokemon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActiveBattlePokemon.kt\ncom/cobblemon/mod/common/battles/ActiveBattlePokemon\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n11879#2,9:147\n13805#2:156\n13806#2:158\n11888#2:159\n11879#2,9:163\n13805#2:172\n13806#2:174\n11888#2:175\n1#3:157\n1#3:173\n1#3:179\n1803#4,3:160\n1803#4,3:176\n*S KotlinDebug\n*F\n+ 1 ActiveBattlePokemon.kt\ncom/cobblemon/mod/common/battles/ActiveBattlePokemon\n*L\n38#1:147,9\n38#1:156\n38#1:158\n38#1:159\n45#1:163,9\n45#1:172\n45#1:174\n45#1:175\n38#1:157\n45#1:173\n42#1:160,3\n50#1:176,3\n*E\n"})
public final class ActiveBattlePokemon
implements Targetable {
    @NotNull
    private final BattleActor actor;
    @Nullable
    private BattlePokemon battlePokemon;
    @NotNull
    private final PokemonBattle battle;
    @Nullable
    private Pair<? extends ServerLevel, ? extends Vec3> position;
    @Nullable
    private BattlePokemon illusion;

    public ActiveBattlePokemon(@NotNull BattleActor actor, @Nullable BattlePokemon battlePokemon) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        this.actor = actor;
        this.battlePokemon = battlePokemon;
        this.battle = this.actor.getBattle();
    }

    public /* synthetic */ ActiveBattlePokemon(BattleActor battleActor, BattlePokemon battlePokemon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            battlePokemon = null;
        }
        this(battleActor, battlePokemon);
    }

    @NotNull
    public final BattleActor getActor() {
        return this.actor;
    }

    @Nullable
    public final BattlePokemon getBattlePokemon() {
        return this.battlePokemon;
    }

    public final void setBattlePokemon(@Nullable BattlePokemon battlePokemon) {
        this.battlePokemon = battlePokemon;
    }

    @NotNull
    public final PokemonBattle getBattle() {
        return this.battle;
    }

    @NotNull
    public final BattleSide getSide() {
        return this.actor.getSide();
    }

    @Nullable
    public final Pair<ServerLevel, Vec3> getPosition() {
        return this.position;
    }

    public final void setPosition(@Nullable Pair<? extends ServerLevel, ? extends Vec3> pair) {
        this.position = pair;
    }

    @Nullable
    public final BattlePokemon getIllusion() {
        return this.illusion;
    }

    public final void setIllusion(@Nullable BattlePokemon battlePokemon) {
        this.illusion = battlePokemon;
    }

    @NotNull
    public Iterable<ActiveBattlePokemon> getAllActivePokemon() {
        return this.battle.getActivePokemon();
    }

    @Override
    @NotNull
    public String getActorShowdownId() {
        return this.actor.getShowdownId();
    }

    @NotNull
    public List<ActiveBattlePokemon> getActorPokemon() {
        return this.actor.getActivePokemon();
    }

    @NotNull
    public List<ActiveBattlePokemon> getSidePokemon() {
        return this.getSide().getActivePokemon();
    }

    @Override
    @NotNull
    public BattleFormat getFormat() {
        return this.battle.getFormat();
    }

    @Override
    public boolean isAllied(@NotNull Targetable other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.getSide(), (Object)((ActiveBattlePokemon)other).getSide());
    }

    @Override
    public boolean hasPokemon() {
        return this.battlePokemon != null;
    }

    public final boolean isGone() {
        BattlePokemon battlePokemon = this.battlePokemon;
        return battlePokemon != null ? battlePokemon.getGone() : true;
    }

    public final boolean isAlive() {
        BattlePokemon battlePokemon = this.battlePokemon;
        return (battlePokemon != null ? battlePokemon.getHealth() : 0) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Vec3 getSendOutPosition() {
        Object object;
        Vec3 vec3;
        void $this$mapNotNullTo$iv$iv;
        Vec3 vec32;
        void $this$mapNotNullTo$iv$iv2;
        String pnx = this.getPNX();
        BattleActor[] $this$mapNotNull$iv = this.actor.getSide().getActors();
        boolean $i$f$mapNotNull2 = false;
        BattleActor[] battleActorArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Vec3 it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof EntityBackedBattleActor ? ((EntityBackedBattleActor)it).getInitialPos() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actorEntityPosList = (List)destination$iv$iv;
        if (actorEntityPosList.size() == 1) {
            vec32 = (Vec3)actorEntityPosList.get(0);
        } else if (actorEntityPosList.size() > 1) {
            void $this$fold$iv;
            Iterable $i$f$mapNotNull2 = actorEntityPosList;
            Vec3 initial$iv = new Vec3(0.0, 0.0, 0.0);
            boolean $i$f$fold = false;
            Vec3 accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void vec33;
                Vec3 vec34 = (Vec3)element$iv;
                Vec3 acc = accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)acc.add(vec33.scale(1.0 / (double)actorEntityPosList.size())), (String)"add(...)");
            }
            vec32 = accumulator$iv;
        } else {
            vec32 = null;
        }
        Vec3 actorEntityPos = vec32;
        BattleActor[] $this$mapNotNull$iv2 = this.actor.getSide().getOppositeSide().getActors();
        boolean $i$f$mapNotNull32 = false;
        BattleActor[] accumulator$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        Iterator $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        int element$iv$iv = ((void)$this$forEach$iv$iv$iv2).length;
        for (int bl = 0; bl < element$iv$iv; ++bl) {
            Vec3 it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv2[bl];
            boolean bl4 = false;
            void it = element$iv$iv2;
            boolean bl5 = false;
            if ((it instanceof EntityBackedBattleActor ? ((EntityBackedBattleActor)it).getInitialPos() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List opposingActorEntityList = (List)destination$iv$iv2;
        if (opposingActorEntityList.size() == 1) {
            vec3 = (Vec3)opposingActorEntityList.get(0);
        } else if (opposingActorEntityList.size() > 1) {
            void $this$fold$iv;
            Iterable $i$f$mapNotNull32 = opposingActorEntityList;
            Vec3 initial$iv = new Vec3(0.0, 0.0, 0.0);
            boolean $i$f$fold = false;
            Vec3 accumulator$iv2 = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void vec35;
                Vec3 bl = (Vec3)element$iv;
                Vec3 acc = accumulator$iv2;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)acc.add(vec35.scale(1.0 / (double)opposingActorEntityList.size())), (String)"add(...)");
            }
            vec3 = accumulator$iv2;
        } else {
            vec3 = null;
        }
        Vec3 opposingEntityPos = vec3;
        Vec3 vec36 = actorEntityPos;
        if (vec36 != null) {
            Vec3 it = vec36;
            boolean bl = false;
            Vec3 vec37 = opposingEntityPos;
            object = vec37 != null ? vec37.subtract(it) : null;
        } else {
            object = null;
        }
        Vec3 actorOffset = object;
        Vec3 result = actorEntityPos;
        if (actorOffset != null) {
            double widthSum = 0.0;
            widthSum = 4.0;
            float pokemonWidth = 0.0f;
            Object object2 = this.battlePokemon;
            pokemonWidth = object2 != null && (object2 = ((BattlePokemon)object2).getOriginalPokemon()) != null && (object2 = ((Pokemon)object2).getForm()) != null && (object2 = ((FormData)object2).getHitbox()) != null ? object2.width() : 0.0f;
            Object object3 = this.battlePokemon;
            float pokemonBaseScale = object3 != null && (object3 = ((BattlePokemon)object3).getOriginalPokemon()) != null && (object3 = ((Pokemon)object3).getForm()) != null ? ((FormData)object3).getBaseScale() : 0.0f;
            pokemonWidth *= pokemonBaseScale;
            if (this.battle.getFormat().getBattleType().getPokemonPerSide() == 1) {
                BattlePokemon battlePokemon = this.battlePokemon;
                if (battlePokemon != null) {
                    float f;
                    BattlePokemon battlePokemon2 = battlePokemon;
                    boolean bl = false;
                    Targetable targetable = this.getOppositeOpponent();
                    Intrinsics.checkNotNull((Object)targetable, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.battles.ActiveBattlePokemon");
                    ActiveBattlePokemon opposingActivePokemon = (ActiveBattlePokemon)targetable;
                    BattlePokemon battlePokemon3 = opposingActivePokemon.battlePokemon;
                    if (battlePokemon3 != null) {
                        BattlePokemon it = battlePokemon3;
                        boolean bl8 = false;
                        f = it.getOriginalPokemon().getForm().getHitbox().width() * it.getOriginalPokemon().getForm().getBaseScale();
                    } else {
                        f = pokemonWidth;
                    }
                    float opposingPokemonWidth = f;
                    widthSum = (double)(pokemonWidth + opposingPokemonWidth) / 2.0;
                }
            }
            double minDistance = 4.0 + widthSum;
            double actorDistance = actorOffset.length();
            if (actorDistance < minDistance) {
                Vec3 vec38 = actorOffset.scale(minDistance / actorDistance);
                if (vec38 == null) {
                    vec38 = actorOffset;
                }
                Vec3 temp = vec38;
                Vec3 vec39 = actorEntityPos;
                result = vec39 != null ? vec39.subtract(temp.subtract(actorOffset)) : null;
                actorOffset = temp;
            }
            Vec3 orthogonalVector = null;
            orthogonalVector = new Vec3(actorOffset.x, 0.0, actorOffset.z).normalize();
            orthogonalVector = orthogonalVector.cross(new Vec3(0.0, 1.0, 0.0));
            if (this.battle.getFormat().getBattleType().getPokemonPerSide() == 1) {
                Vec3 vec310 = result;
                result = vec310 != null ? vec310.add(actorOffset.scale(this.battle.isPvW() ? 0.4 : 0.3)) : null;
                BattlePokemon battlePokemon = this.battlePokemon;
                if (battlePokemon != null) {
                    BattlePokemon battlePokemon4 = battlePokemon;
                    boolean bl = false;
                    EntityDimensions hitbox = battlePokemon4.getOriginalPokemon().getForm().getHitbox();
                    float scale = battlePokemon4.getOriginalPokemon().getForm().getBaseScale();
                    orthogonalVector = orthogonalVector.scale(-0.3 - (double)(hitbox.width() * scale));
                }
            } else if (this.battle.getFormat().getBattleType().getPokemonPerSide() == 2) {
                if (!Intrinsics.areEqual((Object)CollectionsKt.first(this.battle.getActors()), (Object)CollectionsKt.last(this.battle.getActors()))) {
                    Vec3 offsetB = pnx.charAt(2) == 'a' ? orthogonalVector.scale(-1.0) : orthogonalVector;
                    Vec3 vec311 = result;
                    result = vec311 != null ? vec311.add(actorOffset.scale(0.33)) : null;
                    orthogonalVector = offsetB.scale(2.5);
                }
            } else if (this.battle.getFormat().getBattleType().getPokemonPerSide() == 3 && !Intrinsics.areEqual((Object)CollectionsKt.first(this.battle.getActors()), (Object)CollectionsKt.last(this.battle.getActors()))) {
                result = switch (pnx.charAt(2)) {
                    case 'a' -> {
                        orthogonalVector = orthogonalVector.scale(-3.5);
                        Vec3 v16 = result;
                        if (v16 != null) {
                            yield v16.add(actorOffset.scale(0.15));
                        }
                        yield null;
                    }
                    case 'b' -> {
                        orthogonalVector = Vec3.ZERO;
                        Vec3 v18 = result;
                        if (v18 != null) {
                            yield v18.add(actorOffset.scale(0.3));
                        }
                        yield null;
                    }
                    case 'c' -> {
                        orthogonalVector = orthogonalVector.scale(3.5);
                        Vec3 v19 = result;
                        if (v19 != null) {
                            yield v19.add(actorOffset.scale(0.15));
                        }
                        yield null;
                    }
                    default -> result;
                };
            }
            Vec3 fallbackPos = result;
            Vec3 vec312 = result;
            Object object4 = result = vec312 != null ? vec312.add(orthogonalVector) : null;
            if (this.actor instanceof EntityBackedBattleActor && result != null) {
                Object t = ((EntityBackedBattleActor)((Object)this.actor)).getEntity();
                if (t == null) {
                    return result;
                }
                Object entity = t;
                Level level = entity.level();
                Vec3 vec313 = actorEntityPos;
                Intrinsics.checkNotNull((Object)vec313);
                BlockHitResult collisionResult = level.clip(new ClipContext(vec313.add(new Vec3(0.0, (double)entity.getEyeHeight(), 0.0)), new Vec3(result.x, entity.getY() + (double)entity.getEyeHeight(), result.z), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                if (collisionResult.getType() == HitResult.Type.BLOCK) {
                    result = collisionResult.getLocation().distanceToSqr(actorEntityPos) < (double)pokemonWidth ? fallbackPos : new Vec3(collisionResult.getLocation().x, result.y, collisionResult.getLocation().z);
                }
            }
        }
        return result;
    }
}

