/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.pc;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonSortMode;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.SettableObservable;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.storage.InvalidSpeciesException;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.net.messages.client.storage.pc.SetPCBoxPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\t\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010+\u001a\u00020\u00002\u0006\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010-\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b-\u0010.J\u001b\u00100\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101J'\u00103\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u0002020/H\u0016\u00a2\u0006\u0004\b3\u00101R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00104\u001a\u0004\b5\u00106R\u001d\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\"\u0010<\u001a\u00020\u00198\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR.\u0010D\u001a\u0004\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010B8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR*\u0010K\u001a\u00020J2\u0006\u0010C\u001a\u00020J8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\"\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020Q8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010R\u001a\u0004\bS\u0010TR\u0011\u0010W\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0011\u0010Y\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bX\u0010V\u00a8\u0006Z"}, d2={"Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "pc", "<init>", "(Lcom/cobblemon/mod/common/api/storage/pc/PCStore;)V", "", "iterator", "()Ljava/util/Iterator;", "", "index", "get", "(I)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "set", "(ILcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "getFirstAvailablePosition", "()Lcom/cobblemon/mod/common/api/storage/pc/PCPosition;", "initialize", "()V", "Lcom/cobblemon/mod/common/api/pokemon/PokemonSortMode;", "sortMode", "", "descending", "sort", "(Lcom/cobblemon/mod/common/api/pokemon/PokemonSortMode;Z)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sendTo", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "saveToNBT", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/nbt/CompoundTag;", "Lcom/google/gson/JsonObject;", "json", "saveToJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/core/RegistryAccess;)Lcom/google/gson/JsonObject;", "loadFromJSON", "(Lcom/google/gson/JsonObject;Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "loadFromNBT", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/pc/PCBox;", "", "getNonEmptySlots", "()Ljava/util/Map;", "Lkotlin/Function1;", "getNonEmptySlotsForPackets", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "getPc", "()Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "boxChangeEmitter", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getBoxChangeEmitter", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "emit", "Z", "getEmit", "()Z", "setEmit", "(Z)V", "", "value", "name", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "Lnet/minecraft/resources/ResourceLocation;", "wallpaper", "Lnet/minecraft/resources/ResourceLocation;", "getWallpaper", "()Lnet/minecraft/resources/ResourceLocation;", "setWallpaper", "(Lnet/minecraft/resources/ResourceLocation;)V", "", "[Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()[Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getBoxNumber", "()I", "boxNumber", "getUnoccupiedSlots", "unoccupiedSlots", "common"})
@SourceDebugExtension(value={"SMAP\nPCBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PCBox.kt\ncom/cobblemon/mod/common/api/storage/pc/PCBox\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,185:1\n13870#2,3:186\n13870#2,3:189\n774#3:192\n865#3,2:193\n1285#3,2:195\n1299#3,4:197\n1252#3,4:203\n463#4:201\n413#4:202\n*S KotlinDebug\n*F\n+ 1 PCBox.kt\ncom/cobblemon/mod/common/api/storage/pc/PCBox\n*L\n89#1:186,3\n100#1:189,3\n183#1:192\n183#1:193,2\n183#1:195,2\n183#1:197,4\n184#1:203,4\n184#1:201\n184#1:202\n*E\n"})
public class PCBox
implements Iterable<Pokemon>,
KMappedMarker {
    @NotNull
    private final PCStore pc;
    @NotNull
    private final SimpleObservable<Unit> boxChangeEmitter;
    private boolean emit;
    @Nullable
    private String name;
    @NotNull
    private ResourceLocation wallpaper;
    @NotNull
    private final Pokemon[] pokemon;

    public PCBox(@NotNull PCStore pc) {
        Intrinsics.checkNotNullParameter((Object)pc, (String)"pc");
        this.pc = pc;
        this.boxChangeEmitter = new SimpleObservable();
        this.emit = true;
        this.wallpaper = MiscUtilsKt.cobblemonResource("textures/gui/pc/pc_screen_overlay.png");
        int n = 0;
        Pokemon[] pokemonArray = new Pokemon[30];
        PCBox pCBox = this;
        while (n < 30) {
            int n2 = n++;
            pokemonArray[n2] = null;
        }
        pCBox.pokemon = pokemonArray;
    }

    @NotNull
    public final PCStore getPc() {
        return this.pc;
    }

    @Override
    @NotNull
    public Iterator<Pokemon> iterator() {
        return ArraysKt.filterNotNull((Object[])this.pokemon).iterator();
    }

    @NotNull
    public final SimpleObservable<Unit> getBoxChangeEmitter() {
        return this.boxChangeEmitter;
    }

    protected final boolean getEmit() {
        return this.emit;
    }

    protected final void setEmit(boolean bl) {
        this.emit = bl;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String value) {
        this.name = value;
        if (this.emit) {
            Unit[] unitArray = new Unit[]{Unit.INSTANCE};
            this.boxChangeEmitter.emit((Unit[])unitArray);
        }
    }

    @NotNull
    public final ResourceLocation getWallpaper() {
        return this.wallpaper;
    }

    public final void setWallpaper(@NotNull ResourceLocation value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.wallpaper = value;
        if (this.emit) {
            Unit[] unitArray = new Unit[]{Unit.INSTANCE};
            this.boxChangeEmitter.emit((Unit[])unitArray);
        }
    }

    @NotNull
    protected final Pokemon[] getPokemon() {
        return this.pokemon;
    }

    @Nullable
    public Pokemon get(int index) {
        return (0 <= index ? index < 30 : false) ? this.pokemon[index] : null;
    }

    public void set(int index, @Nullable Pokemon pokemon) {
        boolean bl = 0 <= index ? index < 30 : false;
        if (bl) {
            this.pokemon[index] = pokemon;
            Object object = pokemon;
            if (object != null && (object = ((Pokemon)object).getStoreCoordinates()) != null) {
                ((SettableObservable)object).set(new StoreCoordinates<StorePosition>(this.pc, new PCPosition(this.getBoxNumber(), index)));
            }
            if (this.emit) {
                Unit[] unitArray = new Unit[]{Unit.INSTANCE};
                this.boxChangeEmitter.emit((Unit[])unitArray);
            }
        }
    }

    public final int getBoxNumber() {
        return this.pc.getBoxes().indexOf(this);
    }

    public final int getUnoccupiedSlots() {
        return 30 - ((Collection)ArraysKt.filterNotNull((Object[])this.pokemon)).size();
    }

    @Nullable
    public final PCPosition getFirstAvailablePosition() {
        for (int index = 0; index < 30; ++index) {
            if (this.pokemon[index] != null) continue;
            return new PCPosition(this.getBoxNumber(), index);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        int box = this.getBoxNumber();
        Pokemon[] $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Pokemon item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n = index$iv++;
            Pokemon pokemon2 = item$iv;
            int slot = n;
            boolean bl = false;
            if (pokemon == null) continue;
            PCPosition position = new PCPosition(box, slot);
            pokemon.getStoreCoordinates().set(new StoreCoordinates<StorePosition>(this.pc, position));
        }
        Observable.subscribe$default(this.boxChangeEmitter, null, arg_0 -> PCBox.initialize$lambda$1(this, arg_0), 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void sort(@NotNull PokemonSortMode sortMode, boolean descending) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortMode), (String)"sortMode");
        ArraysKt.sortWith((Object[])this.pokemon, sortMode.comparator(descending));
        Pokemon[] $this$forEachIndexed$iv = this.pokemon;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Pokemon item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n = index$iv++;
            Pokemon pokemon2 = item$iv;
            int slot = n;
            boolean bl = false;
            SettableObservable<StoreCoordinates<?>> settableObservable = pokemon;
            if (settableObservable == null || (settableObservable = ((Pokemon)((Object)settableObservable)).getStoreCoordinates()) == null) continue;
            settableObservable.set(new StoreCoordinates<StorePosition>(this.pc, new PCPosition(this.getBoxNumber(), slot)));
        }
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this.boxChangeEmitter.emit((Unit[])unitArray);
    }

    public final void sendTo(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new SetPCBoxPacket(this).sendToPlayer(player);
    }

    @NotNull
    public CompoundTag saveToNBT(@NotNull CompoundTag nbt, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        String string = this.name;
        if (string != null) {
            String it = string;
            boolean bl = false;
            nbt.putString("BoxName", it);
        }
        nbt.putString("BoxWallpaper", this.wallpaper.toString());
        for (int slot = 0; slot < 30; ++slot) {
            Pokemon pokemon;
            if (this.pokemon[slot] == null) continue;
            nbt.put("Slot" + slot, (Tag)Pokemon.saveToNBT$default(pokemon, registryAccess, null, 2, null));
        }
        return nbt;
    }

    @NotNull
    public JsonObject saveToJSON(@NotNull JsonObject json, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        String string = this.name;
        if (string != null) {
            String it = string;
            boolean bl = false;
            json.addProperty("BoxName", it);
        }
        json.addProperty("BoxWallpaper", this.wallpaper.toString());
        for (int slot = 0; slot < 30; ++slot) {
            Pokemon pokemon;
            if (this.pokemon[slot] == null) continue;
            json.add("Slot" + slot, (JsonElement)Pokemon.saveToJSON$default(pokemon, registryAccess, null, 2, null));
        }
        return json;
    }

    @NotNull
    public PCBox loadFromJSON(@NotNull JsonObject json, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        if (json.has("BoxName")) {
            this.setName(json.getAsJsonPrimitive("BoxName").getAsString());
        }
        if (json.has("BoxWallpaper")) {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)json.getAsJsonPrimitive("BoxWallpaper").getAsString());
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"parse(...)");
            this.setWallpaper(resourceLocation);
        }
        for (int slot = 0; slot < 30; ++slot) {
            if (!json.has("Slot" + slot)) continue;
            JsonObject pokemonJson = json.getAsJsonObject("Slot" + slot);
            try {
                Intrinsics.checkNotNull((Object)pokemonJson);
                this.pokemon[slot] = Pokemon.Companion.loadFromJSON(registryAccess, pokemonJson);
                continue;
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonJson);
                this.pc.handleInvalidSpeciesJSON(pokemonJson);
                continue;
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Failed to read a pok\u00e9mon: " + pokemonJson, (Throwable)e);
            }
        }
        return this;
    }

    @NotNull
    public PCBox loadFromNBT(@NotNull CompoundTag nbt, @NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        if (nbt.contains("BoxName")) {
            this.setName(nbt.getString("BoxName"));
        }
        if (nbt.contains("BoxWallpaper")) {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)nbt.getString("BoxWallpaper"));
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"parse(...)");
            this.setWallpaper(resourceLocation);
        }
        for (int slot = 0; slot < 30; ++slot) {
            if (!nbt.contains("Slot" + slot)) continue;
            CompoundTag pokemonNBT = nbt.getCompound("Slot" + slot);
            try {
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.pokemon[slot] = Pokemon.Companion.loadFromNBT(registryAccess, pokemonNBT);
                continue;
            }
            catch (InvalidSpeciesException invalidSpeciesException) {
                Intrinsics.checkNotNull((Object)pokemonNBT);
                this.pc.handleInvalidSpeciesNBT(pokemonNBT);
                continue;
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Failed to read a pok\u00e9mon: " + pokemonNBT, (Throwable)e);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Integer, Pokemon> getNonEmptySlots() {
        void $this$associateWithTo$iv$iv;
        int n;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)30);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            n = 0;
            if (!(this.get(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Pokemon pokemon;
            void it;
            n = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)this.get((int)it));
            map.put(t, pokemon);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Integer, Function1<RegistryAccess, Pokemon>> getNonEmptySlotsForPackets() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<Integer, Pokemon> $this$mapValues$iv = this.getNonEmptySlots();
        boolean $i$f$mapValues = false;
        Map<Integer, Pokemon> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Pokemon pokemon = (Pokemon)entry2.getValue();
            Function1 function1 = arg_0 -> PCBox.getNonEmptySlotsForPackets$lambda$0$0(pokemon, arg_0);
            map3.put(k, function1);
        }
        return destination$iv$iv$iv;
    }

    private static final Unit initialize$lambda$1(PCBox this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Unit[] unitArray = new Unit[]{Unit.INSTANCE};
        this$0.pc.getPcChangeObservable().emit((Unit[])unitArray);
        return Unit.INSTANCE;
    }

    private static final Pokemon getNonEmptySlotsForPackets$lambda$0$0(Pokemon $pokemon, RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"<unused var>");
        return $pokemon;
    }
}

