/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.party;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonGainedEvent;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.pokemon.evolution.PassiveEvolution;
import com.cobblemon.mod.common.api.pokemon.feature.TickingSpeciesFeature;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.party.PartyPosition;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.pokemon.OriginalTrainerType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.activestate.PokemonState;
import com.cobblemon.mod.common.pokemon.activestate.ShoulderedState;
import com.cobblemon.mod.common.pokemon.evolution.variants.LevelUpEvolution;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.CompoundTagExtensionsKt;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J \u0010\"\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0010H\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "Ljava/util/UUID;", "playerUUID", "storageUUID", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;)V", "(Ljava/util/UUID;)V", "", "initialize", "()V", "Lnet/minecraft/core/RegistryAccess;", "registryAccess", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "getOverflowPC", "(Lnet/minecraft/core/RegistryAccess;)Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "add", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "onSecondPassed", "(Lnet/minecraft/server/level/ServerPlayer;)V", "isLeft", "validateShoulder", "(Lnet/minecraft/server/level/ServerPlayer;Z)Z", "Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;", "position1", "position2", "swap", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;)V", "position", "set", "(Lcom/cobblemon/mod/common/api/storage/party/PartyPosition;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Ljava/util/UUID;", "getPlayerUUID", "()Ljava/util/UUID;", "", "secondsSinceFriendshipUpdate", "I", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerPartyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerPartyStore.kt\ncom/cobblemon/mod/common/api/storage/party/PlayerPartyStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,239:1\n1#2:240\n14#3,5:241\n19#3:249\n13805#4:246\n13806#4:248\n14#5:247\n808#6,11:250\n1869#6,2:261\n1869#6,2:263\n1869#6,2:265\n808#6,11:267\n1869#6,2:278\n1869#6,2:280\n1869#6,2:282\n*S KotlinDebug\n*F\n+ 1 PlayerPartyStore.kt\ncom/cobblemon/mod/common/api/storage/party/PlayerPartyStore\n*L\n88#1:241,5\n88#1:249\n88#1:246\n88#1:248\n88#1:247\n147#1:250,11\n147#1:261,2\n149#1:263,2\n153#1:265,2\n165#1:267,11\n165#1:278,2\n175#1:280,2\n193#1:282,2\n*E\n"})
public class PlayerPartyStore
extends PartyStore {
    @NotNull
    private final UUID playerUUID;
    private int secondsSinceFriendshipUpdate;

    public PlayerPartyStore(@NotNull UUID playerUUID, @NotNull UUID storageUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        Intrinsics.checkNotNullParameter((Object)storageUUID, (String)"storageUUID");
        super(storageUUID);
        this.playerUUID = playerUUID;
    }

    public /* synthetic */ PlayerPartyStore(UUID uUID, UUID uUID2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uUID2 = uUID;
        }
        this(uUID, uUID2);
    }

    @NotNull
    public final UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public PlayerPartyStore(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        this(playerUUID, playerUUID);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getObserverUUIDs().add(this.playerUUID);
    }

    @Nullable
    public PCStore getOverflowPC(@NotNull RegistryAccess registryAccess) {
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        return Cobblemon.INSTANCE.getStorage().getPC(this.playerUUID, registryAccess);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(@NotNull Pokemon pokemon) {
        boolean added;
        Object pc;
        Object player;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (pokemon.getOriginalTrainerType() == OriginalTrainerType.NONE) {
            pokemon.setOriginalTrainer(this.playerUUID);
        }
        pokemon.refreshOriginalTrainer();
        if (super.add(pokemon)) {
            ServerPlayer serverPlayer = pokemon.getOwnerPlayer();
            if (serverPlayer != null) {
                ServerPlayer it = serverPlayer;
                boolean bl = false;
                CobblemonCriteria.PARTY_CHECK.trigger(it, this);
            }
            v1 = true;
        } else {
            Object[] objectArray = player = PlayerExtensionsKt.getPlayer(this.playerUUID);
            if (player == null || (objectArray = objectArray.server) == null || (objectArray = objectArray.registryAccess()) == null) {
                MinecraftServer minecraftServer = DistributionUtilsKt.server();
                Intrinsics.checkNotNull((Object)minecraftServer);
                objectArray = minecraftServer.registryAccess();
            }
            Object[] objectArray2 = objectArray;
            Intrinsics.checkNotNull((Object)objectArray2);
            pc = this.getOverflowPC((RegistryAccess)objectArray2);
            if (pc == null || !((PokemonStore)pc).add(pokemon)) {
                if (pc == null) {
                    if (player != null) {
                        player.sendSystemMessage((Component)LocalizationUtilsKt.lang("overflow_no_pc", new Object[0]));
                    }
                } else if (player != null) {
                    objectArray2 = new Object[]{((PCStore)pc).getName()};
                    player.sendSystemMessage((Component)LocalizationUtilsKt.lang("overflow_no_space", objectArray2));
                }
                v1 = false;
            } else {
                if (player != null) {
                    objectArray2 = new Object[]{pokemon.getSpecies().getTranslatedName(), ((PCStore)pc).getName()};
                    player.sendSystemMessage((Component)LocalizationUtilsKt.lang("overflow_to_pc", objectArray2));
                }
                v1 = added = true;
            }
        }
        if (added) {
            void $this$iv;
            player = CobblemonEvents.POKEMON_GAINED;
            pc = new PokemonGainedEvent[]{new PokemonGainedEvent(this.playerUUID, pokemon)};
            Object events$iv = pc;
            boolean $i$f$post = false;
            $this$iv.emit(Arrays.copyOf(events$iv, ((Object)events$iv).length));
            Object $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach = false;
            int n = ((Object)$this$forEach$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Object element$iv$iv;
                Object object = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                Object it = object;
            }
        }
        return added;
    }

    /*
     * WARNING - void declaration
     */
    public final void onSecondPassed(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (BattleRegistry.getBattleByParticipatingPlayer(player) == null) {
            Random.Default random = Random.Default;
            for (Pokemon pokemon : this) {
                void $this$filterIsInstanceTo$iv$iv;
                Evolution it;
                Object element$iv;
                void $this$forEach$iv;
                Iterator $this$filterIsInstanceTo$iv$iv2;
                Object status;
                if (pokemon.isFainted()) {
                    if (Cobblemon.INSTANCE.getConfig().getFaintAwakenHealthPercent() > 0.0f) {
                        pokemon.setFaintedTimer(pokemon.getFaintedTimer() - 1);
                        if (pokemon.getFaintedTimer() <= -1) {
                            float php = (float)Math.ceil((float)pokemon.getMaxHealth() * Cobblemon.INSTANCE.getConfig().getFaintAwakenHealthPercent());
                            pokemon.setCurrentHealth((int)php);
                            Object[] objectArray = new Object[]{Pokemon.getDisplayName$default(pokemon, false, 1, null)};
                            player.sendSystemMessage((Component)Component.translatable((String)"cobblemon.party.faintRecover", (Object[])objectArray));
                        }
                    }
                } else if (pokemon.getCurrentHealth() < pokemon.getMaxHealth() && Cobblemon.INSTANCE.getConfig().getHealPercent() > 0.0) {
                    int php = pokemon.getHealTimer();
                    pokemon.setHealTimer(php + -1);
                    if (pokemon.getHealTimer() <= -1) {
                        pokemon.setHealTimer(Cobblemon.INSTANCE.getConfig().getHealTimer());
                        double healAmount = RangesKt.coerceAtLeast((double)1.0, (double)((double)pokemon.getMaxHealth() * Cobblemon.INSTANCE.getConfig().getHealPercent()));
                        pokemon.setCurrentHealth(pokemon.getCurrentHealth() + (int)Math.rint(healAmount));
                    }
                }
                if ((status = pokemon.getStatus()) != null && !player.isSleeping()) {
                    if (((PersistentStatusContainer)status).isExpired()) {
                        ((PersistentStatusContainer)status).getStatus().onStatusExpire(player, pokemon, (Random)random);
                        pokemon.setStatus(null);
                    } else {
                        ((PersistentStatusContainer)status).getStatus().onSecondPassed(player, pokemon, (Random)random);
                        ((PersistentStatusContainer)status).tickTimer();
                    }
                }
                Iterable $this$filterIsInstance$iv = pokemon.getLockedEvolutions();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator = $this$filterIsInstanceTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    if (!(element$iv$iv instanceof PassiveEvolution)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                $this$filterIsInstanceTo$iv$iv2 = $this$forEach$iv.iterator();
                while ($this$filterIsInstanceTo$iv$iv2.hasNext()) {
                    element$iv = $this$filterIsInstanceTo$iv$iv2.next();
                    PassiveEvolution it2 = (PassiveEvolution)element$iv;
                    boolean bl = false;
                    it2.attemptEvolution(pokemon);
                }
                List removeList = new ArrayList();
                Iterable $this$forEach$iv2 = pokemon.getEvolutionProxy().server();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (Evolution)element$iv2;
                    boolean bl = false;
                    if (it.test(pokemon) || !(it instanceof LevelUpEvolution) || ((LevelUpEvolution)it).getPermanent()) continue;
                    removeList.add(it);
                }
                $this$forEach$iv2 = removeList;
                $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    it = (Evolution)element$iv3;
                    boolean bl = false;
                    pokemon.getEvolutionProxy().server().remove(it);
                }
                if (pokemon.getCurrentFullness() > 0) {
                    pokemon.tickMetabolism();
                }
                if (MapsKt.any(pokemon.getInteractionCooldowns())) {
                    pokemon.tickInteractionCooldown();
                }
                Iterable $this$filterIsInstance$iv2 = pokemon.getFeatures();
                boolean $i$f$filterIsInstance2 = false;
                element$iv = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof TickingSpeciesFeature)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
                $i$f$forEach2 = false;
                for (Object element$iv4 : $this$forEach$iv2) {
                    TickingSpeciesFeature it3 = (TickingSpeciesFeature)element$iv4;
                    boolean bl = false;
                    ServerLevel serverLevel = player.serverLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
                    it3.onSecondPassed(serverLevel, pokemon, null);
                }
                Object object = pokemon.getEntity();
                if (object != null && (object = object.getPassengers()) != null ? !((Collection)object).isEmpty() : false) continue;
                pokemon.setRideStamina(pokemon.getRideStamina() + 0.1f);
            }
            ++this.secondsSinceFriendshipUpdate;
            if (this.secondsSinceFriendshipUpdate == 120) {
                this.secondsSinceFriendshipUpdate = 0;
                Iterable $this$forEach$iv = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pokemon pokemon = (Pokemon)element$iv;
                    boolean bl = false;
                    if (pokemon.getFriendship() >= 160 || pokemon.getEntity() == null && !(pokemon.getState() instanceof ShoulderedState)) continue;
                    Pokemon.incrementFriendship$default(pokemon, 1, false, 2, null);
                }
            }
        }
        CompoundTag compoundTag = player.getShoulderEntityLeft();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getShoulderEntityLeft(...)");
        if (CompoundTagExtensionsKt.isPokemonEntity(compoundTag) && !this.validateShoulder(player, true)) {
            player.respawnEntityOnShoulder(player.getShoulderEntityLeft());
        }
        CompoundTag compoundTag2 = player.getShoulderEntityRight();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"getShoulderEntityRight(...)");
        if (CompoundTagExtensionsKt.isPokemonEntity(compoundTag2) && !this.validateShoulder(player, false)) {
            player.respawnEntityOnShoulder(player.getShoulderEntityRight());
        }
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pokemon it = (Pokemon)element$iv;
            boolean bl = false;
            PokemonState state = it.getState();
            if (!(state instanceof ShoulderedState) || ((ShoulderedState)state).isStillShouldered(player)) continue;
            it.recall();
        }
    }

    private final boolean validateShoulder(ServerPlayer player, boolean isLeft) {
        Pokemon pokemon;
        block6: {
            block5: {
                Object v0;
                Object object;
                block4: {
                    CompoundTag shoulderEntity = isLeft ? player.getShoulderEntityLeft() : player.getShoulderEntityRight();
                    object = this;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        Pokemon it = (Pokemon)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)shoulderEntity.getCompound("Pokemon").getUUID("UUID"))) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                pokemon = v0;
                if (pokemon == null) break block5;
                object = pokemon.getState();
                ShoulderedState shoulderedState = object instanceof ShoulderedState ? (ShoulderedState)object : null;
                if ((shoulderedState != null ? shoulderedState.isLeftShoulder() == isLeft : false) && pokemon.getForm().getShoulderMountable()) break block6;
            }
            return false;
        }
        PlayerExtensionsKt.updateShoulderNbt(player, pokemon);
        return true;
    }

    @Override
    public void swap(@NotNull PartyPosition position1, @NotNull PartyPosition position2) {
        Intrinsics.checkNotNullParameter((Object)position1, (String)"position1");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position2");
        super.swap(position1, position2);
        Pokemon pokemon1 = this.get(position1);
        Pokemon pokemon2 = this.get(position2);
        if (pokemon1 != null && pokemon2 != null) {
            ServerPlayer player = pokemon1.getOwnerPlayer();
            if (player != null) {
                CobblemonCriteria.PARTY_CHECK.trigger(player, this);
            }
        } else if (pokemon1 != null || pokemon2 != null) {
            ServerPlayer player;
            Pokemon pokemon = pokemon1;
            Object object = player = pokemon != null ? pokemon.getOwnerPlayer() : null;
            if (player != null) {
                CobblemonCriteria.PARTY_CHECK.trigger(player, this);
            } else {
                Pokemon pokemon3 = pokemon2;
                Intrinsics.checkNotNull((Object)pokemon3);
                ServerPlayer serverPlayer = player = pokemon3.getOwnerPlayer();
                Intrinsics.checkNotNull((Object)serverPlayer);
                CobblemonCriteria.PARTY_CHECK.trigger(serverPlayer, this);
            }
        }
    }

    @Override
    public void set(@NotNull PartyPosition position, @NotNull Pokemon pokemon) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            super.set(position, pokemon);
            ServerPlayer serverPlayer = pokemon.getOwnerPlayer();
            if (serverPlayer == null) break block0;
            ServerPlayer it = serverPlayer;
            boolean bl = false;
            CobblemonCriteria.PARTY_CHECK.trigger(it, this);
        }
    }
}

