/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnBucketChosenEvent;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.SpawningZone;
import com.cobblemon.mod.common.api.spawning.SpawningZoneGenerator;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.AreaSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.AreaSpawnablePositionResolver;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.calculators.SpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.selection.SpawningSelector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\bf\u0018\u0000 T2\u00020\u0001:\u0001TJ+\u0010\u0007\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\r2\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ)\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u0015\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J%\u0010#\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\rH\u0016\u00a2\u0006\u0004\b#\u0010$J'\u0010,\u001a\u00020+2\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0019\u0010/\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b/\u00100R\u0014\u00104\u001a\u0002018&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010!R\u001c\u0010;\u001a\u0002068&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R \u0010A\u001a\u0006\u0012\u0002\b\u00030<8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001c\u0010G\u001a\u00020B8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001c\u0010M\u001a\u00020H8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001c\u0010S\u001a\u00020N8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010R\u00a8\u0006U\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "", "R", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "result", "", "afterSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Ljava/lang/Object;)V", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "bucket", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "getMatchingSpawns", "(Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;)Ljava/util/List;", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "cause", "calculateSpawnActionForPosition", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;)Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;", "zoneInput", "", "maxSpawns", "calculateSpawnActionsForArea", "(Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;Ljava/lang/Integer;)Ljava/util/List;", "runForPosition", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;)Ljava/lang/Object;", "runForArea", "", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "copyInfluences", "()Ljava/util/List;", "influences", "chooseBucket", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;Ljava/util/List;)Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/level/chunk/ChunkAccess;", "chunk", "Lnet/minecraft/core/BlockPos$MutableBlockPos;", "startPos", "", "isValidStartPoint", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos$MutableBlockPos;)Z", "area", "constrainArea", "(Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;)Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;", "", "getName", "()Ljava/lang/String;", "name", "getInfluences", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "getSpawnPool", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "setSpawnPool", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;)V", "spawnPool", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "getSelector", "()Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "setSelector", "(Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;)V", "selector", "Lcom/cobblemon/mod/common/api/spawning/SpawningZoneGenerator;", "getGenerator", "()Lcom/cobblemon/mod/common/api/spawning/SpawningZoneGenerator;", "setGenerator", "(Lcom/cobblemon/mod/common/api/spawning/SpawningZoneGenerator;)V", "generator", "Lcom/cobblemon/mod/common/api/spawning/position/AreaSpawnablePositionResolver;", "getResolver", "()Lcom/cobblemon/mod/common/api/spawning/position/AreaSpawnablePositionResolver;", "setResolver", "(Lcom/cobblemon/mod/common/api/spawning/position/AreaSpawnablePositionResolver;)V", "resolver", "", "getMaxPokemonPerChunk", "()F", "setMaxPokemonPerChunk", "(F)V", "maxPokemonPerChunk", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spawner.kt\ncom/cobblemon/mod/common/api/spawning/spawner/Spawner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,271:1\n774#2:272\n865#2,2:273\n1869#2,2:275\n774#2:278\n865#2,2:279\n1285#2,2:281\n1299#2,4:283\n1869#2,2:287\n1#3:277\n14#4,5:289\n19#4:297\n13805#5:294\n13806#5:296\n14#6:295\n*S KotlinDebug\n*F\n+ 1 Spawner.kt\ncom/cobblemon/mod/common/api/spawning/spawner/Spawner\n*L\n77#1:272\n77#1:273,2\n78#1:275,2\n182#1:278\n182#1:279,2\n186#1:281,2\n186#1:283,4\n187#1:287,2\n195#1:289,5\n195#1:297\n195#1:294\n195#1:296\n195#1:295\n*E\n"})
public interface Spawner {
    @NotNull
    public static final Companion Companion = com.cobblemon.mod.common.api.spawning.spawner.Spawner$Companion.$$INSTANCE;
    public static final int ENTITY_LIMIT_CHUNK_RANGE = 3;

    @NotNull
    public String getName();

    @NotNull
    public List<SpawningInfluence> getInfluences();

    @NotNull
    public SpawnPool getSpawnPool();

    public void setSpawnPool(@NotNull SpawnPool var1);

    @NotNull
    public SpawningSelector<?> getSelector();

    public void setSelector(@NotNull SpawningSelector<?> var1);

    @NotNull
    public SpawningZoneGenerator getGenerator();

    public void setGenerator(@NotNull SpawningZoneGenerator var1);

    @NotNull
    public AreaSpawnablePositionResolver getResolver();

    public void setResolver(@NotNull AreaSpawnablePositionResolver var1);

    public float getMaxPokemonPerChunk();

    public void setMaxPokemonPerChunk(float var1);

    default public <R> void afterSpawn(@NotNull SpawnAction<R> action, R result) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<SpawnDetail> getMatchingSpawns(@NotNull SpawnBucket bucket, @NotNull SpawnablePosition spawnablePosition) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        List spawns = new ArrayList();
        Iterable iterable = this.getSpawnPool().retrieve(bucket, spawnablePosition);
        List list = spawns;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpawnDetail it = (SpawnDetail)element$iv$iv;
            boolean bl = false;
            if (!it.isSatisfiedBy(spawnablePosition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        Iterable $this$forEach$iv = spawnablePosition.getInfluences();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpawningInfluence influence = (SpawningInfluence)element$iv;
            boolean bl = false;
            List<SpawnDetail> influencedSpawns = influence.injectSpawns(bucket, spawnablePosition);
            if (influencedSpawns == null) continue;
            spawns.addAll((Collection)influencedSpawns);
        }
        return spawns;
    }

    @Nullable
    default public SpawnAction<?> calculateSpawnActionForPosition(@NotNull SpawnCause cause, @NotNull SpawnablePosition spawnablePosition) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        this.getInfluences().removeIf(arg_0 -> Spawner.calculateSpawnActionForPosition$lambda$1(Spawner::calculateSpawnActionForPosition$lambda$0, arg_0));
        spawnablePosition.getInfluences().addAll((Collection<SpawningInfluence>)this.getInfluences());
        SpawnBucket bucket = this.chooseBucket(cause, spawnablePosition.getInfluences());
        return (SpawnAction)CollectionsKt.firstOrNull(this.getSelector().select(this, bucket, CollectionsKt.listOf((Object)spawnablePosition), 1));
    }

    @NotNull
    default public List<SpawnAction<?>> calculateSpawnActionsForArea(@NotNull SpawningZoneInput zoneInput, @Nullable Integer maxSpawns) {
        float maxPokemonPerChunk;
        int chunksCovered;
        Intrinsics.checkNotNullParameter((Object)zoneInput, (String)"zoneInput");
        Integer n = maxSpawns;
        int maxSpawns2 = n != null ? n.intValue() : Cobblemon.INSTANCE.getConfig().getMaximumSpawnsPerPass();
        this.getInfluences().removeIf(arg_0 -> Spawner.calculateSpawnActionsForArea$lambda$1(Spawner::calculateSpawnActionsForArea$lambda$0, arg_0));
        SpawningZoneInput spawningZoneInput = this.constrainArea(zoneInput);
        if (spawningZoneInput == null) {
            return CollectionsKt.emptyList();
        }
        SpawningZoneInput constrainedArea = spawningZoneInput;
        AABB areaBox = AABB.ofSize((Vec3)new Vec3(Vec3ExtensionsKt.toVec3f(constrainedArea.getCenter())), (double)96.0, (double)1000.0, (double)96.0);
        ServerLevel serverLevel = constrainedArea.getWorld();
        Intrinsics.checkNotNull((Object)areaBox);
        if (!WorldExtensionsKt.isBoxLoaded(serverLevel, areaBox)) {
            return CollectionsKt.emptyList();
        }
        int numberNearby2 = constrainedArea.getWorld().getEntitiesOfClass(PokemonEntity.class, areaBox, arg_0 -> Spawner.calculateSpawnActionsForArea$lambda$2((Function1)calculateSpawnActionsForArea.numberNearby.1.INSTANCE, arg_0)).size();
        if ((float)numberNearby2 / (float)(chunksCovered = 9) >= (maxPokemonPerChunk = Math.max(Cobblemon.INSTANCE.getConfig().getPokemonPerChunk(), zoneInput.getCause().getSpawner().getMaxPokemonPerChunk()))) {
            return CollectionsKt.emptyList();
        }
        SpawningZone zone = this.getGenerator().generate(this, constrainedArea);
        List<AreaSpawnablePosition> spawnablePositions = this.getResolver().resolve(this, SpawnablePositionCalculator.Companion.getPrioritizedAreaCalculators(), zone);
        List influences = CollectionsKt.plus((Collection)this.getInfluences(), (Iterable)zone.getUnconditionalInfluences());
        SpawnBucket bucket = this.chooseBucket(zoneInput.getCause(), influences);
        return this.getSelector().select(this, bucket, spawnablePositions, maxSpawns2);
    }

    @Nullable
    default public Object runForPosition(@NotNull SpawnCause cause, @NotNull SpawnablePosition spawnablePosition) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        SpawnAction<?> spawnAction = this.calculateSpawnActionForPosition(cause, spawnablePosition);
        if (spawnAction == null) {
            return null;
        }
        SpawnAction<?> action = spawnAction;
        return action.complete();
    }

    @NotNull
    default public List<Object> runForArea(@NotNull SpawningZoneInput zoneInput, @Nullable Integer maxSpawns) {
        Intrinsics.checkNotNullParameter((Object)zoneInput, (String)"zoneInput");
        List<SpawnAction<?>> spawnActions = this.calculateSpawnActionsForArea(zoneInput, maxSpawns);
        List results = new ArrayList();
        for (SpawnAction<?> spawnAction : spawnActions) {
            Object p0;
            if (spawnAction.complete() == null) continue;
            boolean bl = false;
            results.add(p0);
        }
        return results;
    }

    public static /* synthetic */ List runForArea$default(Spawner spawner, SpawningZoneInput spawningZoneInput, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runForArea");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        return spawner.runForArea(spawningZoneInput, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<SpawningInfluence> copyInfluences() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getInfluences();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpawningInfluence it = (SpawningInfluence)element$iv$iv;
            boolean bl = false;
            if (!(!it.isExpired())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public SpawnBucket chooseBucket(@NotNull SpawnCause cause, @NotNull List<? extends SpawningInfluence> influences) {
        void $this$iv;
        Object element$iv2;
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(influences, (String)"influences");
        List<SpawnBucket> buckets = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets();
        Iterable $this$associateWith$iv = buckets;
        boolean $i$f$associateWith = false;
        EventObservable<SpawnBucketChosenEvent> result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = (Map)((Object)result$iv);
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            SpawnBucket spawnBucket = (SpawnBucket)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Float f = Float.valueOf(it.getWeight());
            map.put(t, f);
        }
        Map bucketWeights = MapsKt.toMutableMap((Map)destination$iv$iv);
        Iterable $this$forEach$iv = influences;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            SpawningInfluence it = (SpawningInfluence)element$iv2;
            boolean bl = false;
            it.affectBucketWeights(bucketWeights);
        }
        Object object = (Map.Entry)CollectionUtilsKt.weightedSelection$default(bucketWeights.entrySet(), null, Spawner::chooseBucket$lambda$2, 1, null);
        if (object == null || (object = (SpawnBucket)object.getKey()) == null) {
            object = (SpawnBucket)CollectionsKt.first(buckets);
        }
        Object bucket = object;
        SpawnBucketChosenEvent event = new SpawnBucketChosenEvent(this, cause, (SpawnBucket)bucket, bucketWeights);
        result$iv = CobblemonEvents.SPAWN_BUCKET_CHOSEN;
        element$iv2 = new SpawnBucketChosenEvent[]{event};
        Object events$iv = element$iv2;
        boolean $i$f$post = false;
        $this$iv.emit(Arrays.copyOf(events$iv, ((E)events$iv).length));
        Object $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach2 = false;
        int n = ((E)$this$forEach$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object element$iv$iv;
            Object e = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            Object it = e;
        }
        return event.getBucket();
    }

    default public boolean isValidStartPoint(@NotNull Level world, @NotNull ChunkAccess chunk, @NotNull BlockPos.MutableBlockPos startPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        int y = startPos.getY();
        if (!world.isLoaded((BlockPos)startPos) || !world.isLoaded((BlockPos)startPos.setY(y + 1))) {
            return false;
        }
        BlockState mid = chunk.getBlockState((BlockPos)startPos.setY(y));
        BlockState above = chunk.getBlockState((BlockPos)startPos.setY(y + 1));
        if (!above.isPathfindable(PathComputationType.AIR)) {
            return false;
        }
        return !mid.isAir();
    }

    @Nullable
    default public SpawningZoneInput constrainArea(@NotNull SpawningZoneInput area) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos(area.getBaseX(), area.getBaseY(), area.getBaseZ());
        int originalY = area.getBaseY();
        Pair pair = new Pair((Object)SectionPos.blockToSectionCoord((int)area.getBaseX()), (Object)SectionPos.blockToSectionCoord((int)area.getBaseZ()));
        int chunkX = ((Number)pair.component1()).intValue();
        int chunkZ = ((Number)pair.component2()).intValue();
        if (!area.getWorld().areEntitiesLoaded(ChunkPos.asLong((int)chunkX, (int)chunkZ))) {
            return null;
        }
        ChunkAccess chunkAccess = area.getWorld().getChunk(chunkX, chunkZ, ChunkStatus.FULL);
        if (chunkAccess == null) {
            return null;
        }
        ChunkAccess chunk = chunkAccess;
        boolean valid = this.isValidStartPoint((Level)area.getWorld(), chunk, basePos);
        if (!valid) {
            int offset = 1;
            do {
                Level level = (Level)area.getWorld();
                BlockPos.MutableBlockPos mutableBlockPos = basePos.setY(originalY + offset);
                Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"setY(...)");
                if (this.isValidStartPoint(level, chunk, mutableBlockPos)) {
                    valid = true;
                    basePos.setY(originalY + offset);
                    break;
                }
                Level level2 = (Level)area.getWorld();
                BlockPos.MutableBlockPos mutableBlockPos2 = basePos.setY(originalY - offset);
                Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos2, (String)"setY(...)");
                if (!this.isValidStartPoint(level2, chunk, mutableBlockPos2)) continue;
                valid = true;
                basePos.setY(originalY - offset);
                break;
            } while (++offset <= Cobblemon.INSTANCE.getConfig().getMaxVerticalCorrectionBlocks());
        }
        if (valid) {
            BlockPos min = WorldExtensionsKt.squeezeWithinBounds((Level)area.getWorld(), (BlockPos)basePos);
            Level level = (Level)area.getWorld();
            BlockPos.MutableBlockPos mutableBlockPos = basePos.move(area.getLength(), area.getHeight(), area.getWidth());
            Intrinsics.checkNotNullExpressionValue((Object)mutableBlockPos, (String)"move(...)");
            BlockPos max = WorldExtensionsKt.squeezeWithinBounds(level, (BlockPos)mutableBlockPos);
            if (area.getWorld().isLoaded(min) && area.getWorld().isLoaded(max) && min.getX() < max.getX() && min.getY() < max.getY() && min.getZ() < max.getZ()) {
                return new SpawningZoneInput(area.getCause(), area.getWorld(), min.getX(), min.getY(), min.getZ(), max.getX() - min.getX(), max.getY() - min.getY(), max.getZ() - min.getZ());
            }
        }
        return null;
    }

    private static boolean calculateSpawnActionForPosition$lambda$0(SpawningInfluence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isExpired();
    }

    private static boolean calculateSpawnActionForPosition$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static boolean calculateSpawnActionsForArea$lambda$0(SpawningInfluence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isExpired();
    }

    private static boolean calculateSpawnActionsForArea$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static boolean calculateSpawnActionsForArea$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static Number chooseBucket$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Number)it.getValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner$Companion;", "", "<init>", "()V", "", "ENTITY_LIMIT_CHUNK_RANGE", "I", "common"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int ENTITY_LIMIT_CHUNK_RANGE = 3;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static <R> void afterSpawn(@NotNull Spawner $this, @NotNull SpawnAction<R> action, R result) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            $this.afterSpawn(action, result);
        }

        @Deprecated
        @NotNull
        public static List<SpawnDetail> getMatchingSpawns(@NotNull Spawner $this, @NotNull SpawnBucket bucket, @NotNull SpawnablePosition spawnablePosition) {
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
            return $this.getMatchingSpawns(bucket, spawnablePosition);
        }

        @Deprecated
        @Nullable
        public static SpawnAction<?> calculateSpawnActionForPosition(@NotNull Spawner $this, @NotNull SpawnCause cause, @NotNull SpawnablePosition spawnablePosition) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
            return $this.calculateSpawnActionForPosition(cause, spawnablePosition);
        }

        @Deprecated
        @NotNull
        public static List<SpawnAction<?>> calculateSpawnActionsForArea(@NotNull Spawner $this, @NotNull SpawningZoneInput zoneInput, @Nullable Integer maxSpawns) {
            Intrinsics.checkNotNullParameter((Object)zoneInput, (String)"zoneInput");
            return $this.calculateSpawnActionsForArea(zoneInput, maxSpawns);
        }

        @Deprecated
        @Nullable
        public static Object runForPosition(@NotNull Spawner $this, @NotNull SpawnCause cause, @NotNull SpawnablePosition spawnablePosition) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
            return $this.runForPosition(cause, spawnablePosition);
        }

        @Deprecated
        @NotNull
        public static List<Object> runForArea(@NotNull Spawner $this, @NotNull SpawningZoneInput zoneInput, @Nullable Integer maxSpawns) {
            Intrinsics.checkNotNullParameter((Object)zoneInput, (String)"zoneInput");
            return $this.runForArea(zoneInput, maxSpawns);
        }

        public static /* synthetic */ List runForArea$default(Spawner spawner, SpawningZoneInput spawningZoneInput, Integer n, int n2, Object object) {
            return Spawner.runForArea$default(spawner, spawningZoneInput, n, n2, object);
        }

        @Deprecated
        @NotNull
        public static List<SpawningInfluence> copyInfluences(@NotNull Spawner $this) {
            return $this.copyInfluences();
        }

        @Deprecated
        @NotNull
        public static SpawnBucket chooseBucket(@NotNull Spawner $this, @NotNull SpawnCause cause, @NotNull List<? extends SpawningInfluence> influences) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            Intrinsics.checkNotNullParameter(influences, (String)"influences");
            return $this.chooseBucket(cause, influences);
        }

        @Deprecated
        public static boolean isValidStartPoint(@NotNull Spawner $this, @NotNull Level world, @NotNull ChunkAccess chunk, @NotNull BlockPos.MutableBlockPos startPos) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
            return $this.isValidStartPoint(world, chunk, startPos);
        }

        @Deprecated
        @Nullable
        public static SpawningZoneInput constrainArea(@NotNull Spawner $this, @NotNull SpawningZoneInput area) {
            Intrinsics.checkNotNullParameter((Object)area, (String)"area");
            return $this.constrainArea(area);
        }
    }
}

