/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.spawner;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.spawning.spawner.BasicSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001e\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\"\u0010&\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u001e\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"\u00a8\u0006)"}, d2={"Lcom/cobblemon/mod/common/api/spawning/spawner/PlayerSpawner;", "Lcom/cobblemon/mod/common/api/spawning/spawner/BasicSpawner;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "spawnPool", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;)V", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "cause", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;", "getZoneInput", "(Lcom/cobblemon/mod/common/api/spawning/SpawnCause;)Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;", "", "tick", "()V", "Ljava/util/UUID;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "", "active", "Z", "getActive", "()Z", "setActive", "(Z)V", "", "ticksUntilNextSpawn", "F", "getTicksUntilNextSpawn", "()F", "setTicksUntilNextSpawn", "(F)V", "ticksBetweenSpawns", "getTicksBetweenSpawns", "setTicksBetweenSpawns", "tickTimerMultiplier", "getTickTimerMultiplier", "setTickTimerMultiplier", "common"})
@SourceDebugExtension(value={"SMAP\nPlayerSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSpawner.kt\ncom/cobblemon/mod/common/api/spawning/spawner/PlayerSpawner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public class PlayerSpawner
extends BasicSpawner {
    @NotNull
    private final UUID uuid;
    private boolean active;
    private float ticksUntilNextSpawn;
    private float ticksBetweenSpawns;
    private float tickTimerMultiplier;

    public PlayerSpawner(@NotNull ServerPlayer player, @NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)spawnPool, (String)"spawnPool");
        String string = player.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        super(string, spawnPool, 0.0f, 4, null);
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.uuid = uUID;
        this.active = true;
        this.ticksUntilNextSpawn = 100.0f;
        this.ticksBetweenSpawns = Cobblemon.INSTANCE.getConfig().getTicksBetweenSpawnAttempts();
        this.tickTimerMultiplier = 1.0f;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public final SpawningZoneInput getZoneInput(@NotNull SpawnCause cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ServerPlayer serverPlayer = PlayerExtensionsKt.getPlayer(this.uuid);
        if (serverPlayer == null) {
            return null;
        }
        ServerPlayer player = serverPlayer;
        int zoneDiameter = Cobblemon.INSTANCE.getConfig().getSpawningZoneDiameter();
        int zoneHeight = Cobblemon.INSTANCE.getConfig().getSpawningZoneHeight();
        Random.Default rand = Random.Default;
        Vec3 center = player.position();
        float r = MiscUtilsKt.nextBetween((Random)rand, Cobblemon.INSTANCE.getConfig().getMinimumSpawningZoneDistanceFromPlayer(), Cobblemon.INSTANCE.getConfig().getMaximumSpawningZoneDistanceFromPlayer());
        double thetatemp = Math.atan(player.getDeltaMovement().z / player.getDeltaMovement().x) + (double)MiscUtilsKt.nextBetween((Random)rand, -1.5707964f, 1.5707964f);
        double theta = player.getDeltaMovement().horizontalDistance() < 0.1 ? rand.nextDouble() * (double)2 * (double)((float)Math.PI) : (player.getDeltaMovement().x < 0.0 ? (double)((float)Math.PI) - thetatemp : thetatemp);
        double x = center.x + (double)r * Math.cos(theta);
        double z = center.z + (double)r * Math.sin(theta);
        Level level = player.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        return new SpawningZoneInput(cause, (ServerLevel)level, Mth.ceil((double)(x - (double)((float)zoneDiameter / 2.0f))), Mth.ceil((double)(center.y - (double)((float)zoneHeight / 2.0f))), Mth.ceil((double)(z - (double)((float)zoneDiameter / 2.0f))), zoneDiameter, zoneHeight, zoneDiameter);
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean bl) {
        this.active = bl;
    }

    public final float getTicksUntilNextSpawn() {
        return this.ticksUntilNextSpawn;
    }

    public final void setTicksUntilNextSpawn(float f) {
        this.ticksUntilNextSpawn = f;
    }

    public final float getTicksBetweenSpawns() {
        return this.ticksBetweenSpawns;
    }

    public final void setTicksBetweenSpawns(float f) {
        this.ticksBetweenSpawns = f;
    }

    public final float getTickTimerMultiplier() {
        return this.tickTimerMultiplier;
    }

    public final void setTickTimerMultiplier(float f) {
        this.tickTimerMultiplier = f;
    }

    public final void tick() {
        if (!this.active) {
            return;
        }
        this.ticksUntilNextSpawn -= this.tickTimerMultiplier;
        if (this.ticksUntilNextSpawn <= 0.0f) {
            SpawningZoneInput zoneInput;
            SpawningZoneInput spawningZoneInput = zoneInput = this.getZoneInput(new SpawnCause(this, (Entity)PlayerExtensionsKt.getPlayer(this.uuid)));
            if (spawningZoneInput != null) {
                SpawningZoneInput p0 = spawningZoneInput;
                boolean bl = false;
                Spawner.runForArea$default(this, p0, null, 2, null);
            }
            this.ticksUntilNextSpawn = this.ticksBetweenSpawns;
        }
    }
}

