/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.selection;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.selection.SpawnSelectionData;
import com.cobblemon.mod.common.api.spawning.selection.SpawningSelector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import com.cobblemon.mod.common.util.MapExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J-\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J9\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/FlatSelector;", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SpawnablePositionSelectionData;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "spawner", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "bucket", "", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePositions", "getSelectionData", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Ljava/util/List;)Lcom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SpawnablePositionSelectionData;", "selectionData", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "selectSpawnAction", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Lcom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SpawnablePositionSelectionData;)Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "", "getTotalWeights", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Ljava/util/List;)Ljava/util/Map;", "SelectingSpawnInformation", "SpawnablePositionSelectionData", "common"})
@SourceDebugExtension(value={"SMAP\nFlatSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,186:1\n1869#2:187\n1869#2:188\n1870#2:196\n1870#2:197\n382#3,7:189\n*S KotlinDebug\n*F\n+ 1 FlatSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSelector\n*L\n98#1:187\n99#1:188\n99#1:196\n98#1:197\n107#1:189,7\n*E\n"})
public class FlatSelector
implements SpawningSelector<SpawnablePositionSelectionData> {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpawnablePositionSelectionData getSelectionData(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
        Map spawnToSpawnablePosition = new LinkedHashMap();
        float percentSum = 0.0f;
        Iterable $this$forEach$iv = spawnablePositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpawnablePosition spawnablePosition = (SpawnablePosition)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = spawner.getMatchingSpawns(bucket, spawnablePosition);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void key$iv;
                void $this$getOrPut$iv;
                SpawnDetail it = (SpawnDetail)element$iv2;
                boolean bl2 = false;
                if (it.getPercentage() > 0.0f && !spawnToSpawnablePosition.containsKey(it)) {
                    percentSum += it.getPercentage();
                }
                Map map = spawnToSpawnablePosition;
                SpawnDetail spawnDetail = it;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    SelectingSpawnInformation answer$iv = new SelectingSpawnInformation();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                SelectingSpawnInformation selectingSpawnInformation = (SelectingSpawnInformation)object;
                selectingSpawnInformation.add(spawnablePosition, spawnablePosition.getWeight(it));
            }
        }
        return new SpawnablePositionSelectionData(spawnToSpawnablePosition, percentSum);
    }

    @Override
    @Nullable
    public SpawnAction<?> selectSpawnAction(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull SpawnablePositionSelectionData selectionData) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)selectionData, (String)"selectionData");
        Map<SpawnDetail, SelectingSpawnInformation> spawnToSpawnablePosition = selectionData.getSpawnToSpawnablePosition();
        float percentSum = selectionData.getPercentSum();
        if (percentSum > 0.0f) {
            if (percentSum > 100.0f) {
                Cobblemon.LOGGER.warn(StringsKt.trimIndent((String)("\n                        A spawn list for " + spawner.getName() + " exceeded 100% on percentage sums...\n                        This means you don't understand how this option works.\n                    ")));
                return null;
            }
            float selectedPercentage = (float)100 - Random.Default.nextFloat() * (float)100;
            percentSum = 0.0f;
            for (Map.Entry<SpawnDetail, SelectingSpawnInformation> entry : spawnToSpawnablePosition.entrySet()) {
                SpawnDetail spawnDetail = entry.getKey();
                SelectingSpawnInformation info = entry.getValue();
                if (!(spawnDetail.getPercentage() > 0.0f) || !((percentSum += spawnDetail.getPercentage()) >= selectedPercentage)) continue;
                return spawnDetail.choose(info.chooseSpawnablePosition(), bucket, selectionData);
            }
        }
        Object object = CollectionUtilsKt.weightedSelection$default(CollectionsKt.toList((Iterable)spawnToSpawnablePosition.entrySet()), null, FlatSelector::selectSpawnAction$lambda$0, 1, null);
        Intrinsics.checkNotNull((Object)object);
        Map.Entry selectedSpawn = (Map.Entry)object;
        return ((SpawnDetail)selectedSpawn.getKey()).choose(((SelectingSpawnInformation)selectedSpawn.getValue()).chooseSpawnablePosition(), bucket, selectionData);
    }

    @Override
    @NotNull
    public Map<SpawnDetail, Float> getTotalWeights(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
        SpawnSelectionData selectionData = this.getSelectionData(spawner, bucket, (List)spawnablePositions);
        if (((SpawnablePositionSelectionData)selectionData).getSize() == 0) {
            return MapsKt.emptyMap();
        }
        Map totalWeights = new LinkedHashMap();
        for (Map.Entry<SpawnDetail, SelectingSpawnInformation> entry : ((SpawnablePositionSelectionData)selectionData).getSpawnToSpawnablePosition().entrySet()) {
            SpawnDetail spawnDetail = entry.getKey();
            SelectingSpawnInformation info = entry.getValue();
            totalWeights.put(spawnDetail, Float.valueOf(info.getHighestWeight()));
        }
        return totalWeights;
    }

    private static final Number selectSpawnAction$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Float.valueOf(((SelectingSpawnInformation)it.getValue()).getHighestWeight());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fR#\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SelectingSpawnInformation;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "spawnablePositionWeight", "", "add", "(Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;F)V", "chooseSpawnablePosition", "()Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "", "spawnablePositions", "Ljava/util/Map;", "getSpawnablePositions", "()Ljava/util/Map;", "highestWeight", "F", "getHighestWeight", "()F", "setHighestWeight", "(F)V", "common"})
    public static final class SelectingSpawnInformation {
        @NotNull
        private final Map<SpawnablePosition, Float> spawnablePositions = new LinkedHashMap();
        private float highestWeight;

        @NotNull
        public final Map<SpawnablePosition, Float> getSpawnablePositions() {
            return this.spawnablePositions;
        }

        public final float getHighestWeight() {
            return this.highestWeight;
        }

        public final void setHighestWeight(float f) {
            this.highestWeight = f;
        }

        public final void add(@NotNull SpawnablePosition spawnablePosition, float spawnablePositionWeight) {
            Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
            this.spawnablePositions.put(spawnablePosition, Float.valueOf(spawnablePositionWeight));
            if (spawnablePositionWeight > this.highestWeight) {
                this.highestWeight = spawnablePositionWeight;
            }
        }

        @NotNull
        public final SpawnablePosition chooseSpawnablePosition() {
            Object object = CollectionUtilsKt.weightedSelection$default(this.spawnablePositions.entrySet(), null, SelectingSpawnInformation::chooseSpawnablePosition$lambda$0, 1, null);
            Intrinsics.checkNotNull((Object)object);
            return (SpawnablePosition)((Map.Entry)object).getKey();
        }

        private static final Number chooseSpawnablePosition$lambda$0(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Number)it.getValue();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000e\u001a\u00020\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0012\u001a\u00020\r2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R&\u0010(\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b(\u0010\u0014\u001a\u0004\b)\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SpawnablePositionSelectionData;", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SelectingSpawnInformation;", "spawnToSpawnablePosition", "", "percentSum", "<init>", "(Ljava/util/Map;F)V", "Lkotlin/Function1;", "", "shouldRemove", "", "removeSpawnDetails", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/Function2;", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "removeSpawnablePositions", "(Lkotlin/jvm/functions/Function2;)V", "Ljava/util/Map;", "getSpawnToSpawnablePosition", "()Ljava/util/Map;", "F", "getPercentSum", "()F", "setPercentSum", "(F)V", "", "getSize", "()I", "size", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "spawnActions", "Ljava/util/List;", "getSpawnActions", "()Ljava/util/List;", "", "", "context", "getContext", "common"})
    @SourceDebugExtension(value={"SMAP\nFlatSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SpawnablePositionSelectionData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n774#2:187\n865#2,2:188\n1869#2,2:190\n774#2:193\n865#2,2:194\n1869#2,2:196\n1#3:192\n*S KotlinDebug\n*F\n+ 1 FlatSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSelector$SpawnablePositionSelectionData\n*L\n72#1:187\n72#1:188,2\n73#1:190,2\n78#1:193\n78#1:194,2\n84#1:196,2\n*E\n"})
    public static final class SpawnablePositionSelectionData
    implements SpawnSelectionData {
        @NotNull
        private final Map<SpawnDetail, SelectingSpawnInformation> spawnToSpawnablePosition;
        private float percentSum;
        @NotNull
        private final List<SpawnAction<?>> spawnActions;
        @NotNull
        private final Map<String, Object> context;

        public SpawnablePositionSelectionData(@NotNull Map<SpawnDetail, SelectingSpawnInformation> spawnToSpawnablePosition, float percentSum) {
            Intrinsics.checkNotNullParameter(spawnToSpawnablePosition, (String)"spawnToSpawnablePosition");
            this.spawnToSpawnablePosition = spawnToSpawnablePosition;
            this.percentSum = percentSum;
            this.spawnActions = new ArrayList();
            this.context = new LinkedHashMap();
        }

        @NotNull
        public final Map<SpawnDetail, SelectingSpawnInformation> getSpawnToSpawnablePosition() {
            return this.spawnToSpawnablePosition;
        }

        public final float getPercentSum() {
            return this.percentSum;
        }

        public final void setPercentSum(float f) {
            this.percentSum = f;
        }

        public final int getSize() {
            return this.spawnToSpawnablePosition.size();
        }

        @Override
        @NotNull
        public List<SpawnAction<?>> getSpawnActions() {
            return this.spawnActions;
        }

        @Override
        @NotNull
        public Map<String, Object> getContext() {
            return this.context;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void removeSpawnDetails(@NotNull Function1<? super SpawnDetail, Boolean> shouldRemove) {
            double d;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(shouldRemove, (String)"shouldRemove");
            Iterable $this$filter$iv = this.spawnToSpawnablePosition.entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!((Boolean)shouldRemove.invoke(it.getKey())).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv = toRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                this.spawnToSpawnablePosition.remove(it.getKey());
            }
            Iterable iterable2 = toRemove;
            float f = this.percentSum;
            SpawnablePositionSelectionData spawnablePositionSelectionData = this;
            double d2 = 0.0;
            for (Object t : iterable2) {
                void it;
                Map.Entry bl = (Map.Entry)t;
                d = d2;
                boolean bl2 = false;
                Double d3 = ((SpawnDetail)it.getKey()).getPercentage();
                double it2 = ((Number)d3).doubleValue();
                boolean bl3 = false;
                Double d4 = it2 > 0.0 ? d3 : null;
                double d5 = d4 != null ? d4 : 0.0;
                d2 = d + d5;
            }
            d = d2;
            spawnablePositionSelectionData.percentSum = f - (float)d;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void removeSpawnablePositions(@NotNull Function2<? super SpawnDetail, ? super SpawnablePosition, Boolean> shouldRemove) {
            double d;
            Object object;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(shouldRemove, (String)"shouldRemove");
            Iterable $this$filter$iv = this.spawnToSpawnablePosition.entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Float f;
                object = (Map.Entry)element$iv$iv;
                boolean bl = false;
                SpawnDetail spawnDetail = (SpawnDetail)object.getKey();
                SelectingSpawnInformation positionData = (SelectingSpawnInformation)object.getValue();
                MapExtensionsKt.removeIf(positionData.getSpawnablePositions(), arg_0 -> SpawnablePositionSelectionData.removeSpawnablePositions$lambda$0$0(shouldRemove, spawnDetail, arg_0));
                Map<SpawnablePosition, Float> map = positionData.getSpawnablePositions();
                SelectingSpawnInformation selectingSpawnInformation = positionData;
                Iterator iterator = ((Iterable)map.entrySet()).iterator();
                if (!iterator.hasNext()) {
                    f = null;
                } else {
                    Map.Entry it = (Map.Entry)iterator.next();
                    boolean bl2 = false;
                    float f2 = ((Number)it.getValue()).floatValue();
                    while (iterator.hasNext()) {
                        Map.Entry it2 = (Map.Entry)iterator.next();
                        $i$a$-maxOfOrNull-FlatSelector$SpawnablePositionSelectionData$removeSpawnablePositions$toRemove$1$2 = false;
                        float f3 = ((Number)it2.getValue()).floatValue();
                        f2 = Math.max(f2, f3);
                    }
                    f = Float.valueOf(f2);
                }
                selectingSpawnInformation.setHighestWeight(f != null ? f.floatValue() : 0.0f);
                if (!positionData.getSpawnablePositions().isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv = toRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                this.spawnToSpawnablePosition.remove(it.getKey());
            }
            Iterable iterable2 = toRemove;
            float f = this.percentSum;
            SpawnablePositionSelectionData spawnablePositionSelectionData = this;
            double d2 = 0.0;
            for (Object t : iterable2) {
                void it;
                Map.Entry bl = (Map.Entry)t;
                d = d2;
                boolean bl3 = false;
                object = (double)((SpawnDetail)it.getKey()).getPercentage();
                double it3 = ((Number)object).doubleValue();
                boolean bl4 = false;
                Object object2 = it3 > 0.0 ? object : null;
                double d3 = object2 != null ? (Double)object2 : 0.0;
                d2 = d + d3;
            }
            d = d2;
            spawnablePositionSelectionData.percentSum = f - (float)d;
        }

        private static final boolean removeSpawnablePositions$lambda$0$0(Function2 $shouldRemove, SpawnDetail $spawnDetail, Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Boolean)$shouldRemove.invoke((Object)$spawnDetail, it.getKey());
        }
    }
}

