/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.position.calculators;

import com.cobblemon.mod.common.api.spawning.SpawningZone;
import com.cobblemon.mod.common.api.spawning.position.FlooredSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.calculators.AreaSpawnablePositionCalculator;
import com.cobblemon.mod.common.api.spawning.position.calculators.AreaSpawningInput;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\t8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\t8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0010\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/api/spawning/position/calculators/FlooredSpawnablePositionCalculator;", "Lcom/cobblemon/mod/common/api/spawning/position/FlooredSpawnablePosition;", "T", "Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawnablePositionCalculator;", "Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawningInput;", "input", "", "fits", "(Lcom/cobblemon/mod/common/api/spawning/position/calculators/AreaSpawningInput;)Z", "Lkotlin/Function1;", "Lnet/minecraft/world/level/block/state/BlockState;", "getBaseCondition", "()Lkotlin/jvm/functions/Function1;", "baseCondition", "getSurroundingCondition", "surroundingCondition", "common"})
public interface FlooredSpawnablePositionCalculator<T extends FlooredSpawnablePosition>
extends AreaSpawnablePositionCalculator<T> {
    @NotNull
    public Function1<BlockState, Boolean> getBaseCondition();

    @NotNull
    public Function1<BlockState, Boolean> getSurroundingCondition();

    @Override
    default public boolean fits(@NotNull AreaSpawningInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BlockState floorState = SpawningZone.getBlockState$default(input.getZone(), input.getPosition(), null, 2, null);
        SpawningZone spawningZone = input.getZone();
        BlockPos blockPos = input.getPosition().above();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
        BlockState aboveState = SpawningZone.getBlockState$default(spawningZone, blockPos, null, 2, null);
        return (Boolean)this.getBaseCondition().invoke((Object)floorState) != false && (Boolean)this.getSurroundingCondition().invoke((Object)aboveState) != false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static <T extends FlooredSpawnablePosition> boolean fits(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return ((FlooredSpawnablePositionCalculator)$this).fits(input);
        }

        @Deprecated
        public static <T extends FlooredSpawnablePosition> int getDepth(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input, @NotNull Function1<? super BlockState, Boolean> condition, int maximum) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            return ((FlooredSpawnablePositionCalculator)$this).getDepth(input, (Function1<BlockState, Boolean>)condition, maximum);
        }

        @Deprecated
        public static <T extends FlooredSpawnablePosition> int getHeight(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input, @NotNull Function1<? super BlockState, Boolean> condition, int maximum, int offsetX, int offsetY, int offsetZ) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            return ((FlooredSpawnablePositionCalculator)$this).getHeight(input, (Function1<BlockState, Boolean>)condition, maximum, offsetX, offsetY, offsetZ);
        }

        @Deprecated
        public static <T extends FlooredSpawnablePosition> int getHorizontalSpace(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input, @NotNull Function1<? super BlockState, Boolean> condition, int maximum, int offsetX, int offsetY, int offsetZ) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            return ((FlooredSpawnablePositionCalculator)$this).getHorizontalSpace(input, (Function1<BlockState, Boolean>)condition, maximum, offsetX, offsetY, offsetZ);
        }

        @Deprecated
        public static <T extends FlooredSpawnablePosition> int getLight(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input, int elseLight) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return ((FlooredSpawnablePositionCalculator)$this).getLight(input, elseLight);
        }

        @Deprecated
        public static <T extends FlooredSpawnablePosition> int getSkyLight(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input, int elseLight) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return ((FlooredSpawnablePositionCalculator)$this).getSkyLight(input, elseLight);
        }

        @Deprecated
        public static <T extends FlooredSpawnablePosition> boolean getCanSeeSky(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return ((FlooredSpawnablePositionCalculator)$this).getCanSeeSky(input);
        }

        @Deprecated
        public static <T extends FlooredSpawnablePosition> int getSkySpaceAbove(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return ((FlooredSpawnablePositionCalculator)$this).getSkySpaceAbove(input);
        }

        @Deprecated
        @NotNull
        public static <T extends FlooredSpawnablePosition> List<BlockState> getNearbyBlocks(@NotNull FlooredSpawnablePositionCalculator<T> $this, @NotNull AreaSpawningInput input, int horizontalRadius, int verticalRadius) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return ((FlooredSpawnablePositionCalculator)$this).getNearbyBlocks(input, horizontalRadius, verticalRadius);
        }
    }
}

