/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.sound;

import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.CompositeBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.CompositeState;
import com.cobblemon.mod.common.api.riding.sound.RideLoopSound;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettings;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettingsList;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/api/riding/sound/RideSoundManager;", "", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "ride", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "", "tick", "()V", "getBehaviourSounds", "Lnet/minecraft/resources/ResourceLocation;", "getActiveRideKey", "()Lnet/minecraft/resources/ResourceLocation;", "stop", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "", "Lcom/cobblemon/mod/common/api/riding/sound/RideLoopSound;", "activeSounds", "Ljava/util/List;", "", "rideActive", "Z", "currKey", "Lnet/minecraft/resources/ResourceLocation;", "common"})
@SourceDebugExtension(value={"SMAP\nRideSoundManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RideSoundManager.kt\ncom/cobblemon/mod/common/api/riding/sound/RideSoundManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1869#2,2:78\n1869#2,2:80\n*S KotlinDebug\n*F\n+ 1 RideSoundManager.kt\ncom/cobblemon/mod/common/api/riding/sound/RideSoundManager\n*L\n58#1:78,2\n75#1:80,2\n*E\n"})
public final class RideSoundManager {
    @NotNull
    private final PokemonEntity ride;
    @NotNull
    private final List<RideLoopSound> activeSounds;
    private boolean rideActive;
    @NotNull
    private ResourceLocation currKey;

    public RideSoundManager(@NotNull PokemonEntity ride) {
        Intrinsics.checkNotNullParameter((Object)ride, (String)"ride");
        this.ride = ride;
        this.activeSounds = new ArrayList();
        this.currKey = MiscUtilsKt.cobblemonResource("no_key");
    }

    public final void tick() {
        boolean currActive = this.ride.hasControllingPassenger();
        if (!currActive && !this.rideActive) {
            return;
        }
        this.activeSounds.removeIf(arg_0 -> RideSoundManager.tick$lambda$1(RideSoundManager::tick$lambda$0, arg_0));
        if (!currActive && this.rideActive) {
            this.rideActive = false;
            this.currKey = MiscUtilsKt.cobblemonResource("no_key");
            this.stop();
        } else if (currActive && !this.rideActive) {
            this.rideActive = true;
            this.currKey = this.getActiveRideKey();
            this.getBehaviourSounds();
        } else if (currActive && this.rideActive && !Intrinsics.areEqual((Object)this.currKey, (Object)this.getActiveRideKey())) {
            this.currKey = this.getActiveRideKey();
            this.stop();
            this.getBehaviourSounds();
        }
    }

    public final void getBehaviourSounds() {
        block1: {
            RideSoundSettingsList rideSounds = this.ride.ifRidingAvailableSupply(null, (arg_0, arg_1, arg_2) -> RideSoundManager.getBehaviourSounds$lambda$0(this, arg_0, arg_1, arg_2));
            Object object = rideSounds;
            if (object == null || (object = ((RideSoundSettingsList)object).getSounds()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RideSoundSettings it = (RideSoundSettings)element$iv;
                boolean bl = false;
                RideLoopSound loopingRideSound = new RideLoopSound(this.ride, it);
                this.activeSounds.add(loopingRideSound);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)loopingRideSound);
            }
        }
    }

    @NotNull
    public final ResourceLocation getActiveRideKey() {
        Object key;
        Object object = this.ride.getRidingController();
        if (object == null || (object = ((RidingController)object).getContext()) == null || (object = ((ActiveRidingContext)object).getSettings()) == null || (object = object.getKey()) == null) {
            object = MiscUtilsKt.cobblemonResource("no_key");
        }
        if (Intrinsics.areEqual((Object)(key = object), (Object)CompositeBehaviour.Companion.getKEY())) {
            RidingBehaviourState ridingBehaviourState;
            Object object2 = this.ride.getRidingController();
            RidingBehaviourState ridingBehaviourState2 = ridingBehaviourState = object2 != null && (object2 = ((RidingController)object2).getContext()) != null ? ((ActiveRidingContext)object2).getState() : null;
            Object object3 = ridingBehaviourState instanceof CompositeState ? (CompositeState)ridingBehaviourState : null;
            if (object3 == null || (object3 = ((CompositeState)object3).getActiveBehaviour()) == null || (object3 = (ResourceLocation)((SidedRidingState)object3).get()) == null) {
                object3 = MiscUtilsKt.cobblemonResource("no_key");
            }
            return object3;
        }
        return key;
    }

    public final void stop() {
        Iterable $this$forEach$iv = this.activeSounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RideLoopSound it = (RideLoopSound)((Object)element$iv);
            boolean bl = false;
            it.stopSound();
        }
    }

    private static final boolean tick$lambda$0(RideLoopSound it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.isStopped();
    }

    private static final boolean tick$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final RideSoundSettingsList getBehaviourSounds$lambda$0(RideSoundManager this$0, RidingBehaviour behaviour, RidingBehaviourSettings settings, RidingBehaviourState state) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return behaviour.getRideSounds(settings, state, this$0.ride);
    }
}

