/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.sound;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.api.riding.sound.RideAttenuationModel;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettings;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\nJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\nJ\r\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010\u0014\"\u0004\b%\u0010&R\"\u0010'\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\u001e\u001a\u0004\b(\u0010\u000e\"\u0004\b)\u0010!R\"\u0010+\u001a\u00020*8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u00101\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010#\u001a\u0004\b2\u0010\u0014\"\u0004\b3\u0010&R\"\u00104\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u0010\u001e\u001a\u0004\b4\u0010\u000e\"\u0004\b5\u0010!\u00a8\u00066"}, d2={"Lcom/cobblemon/mod/common/api/riding/sound/RideLoopSound;", "Lnet/minecraft/client/resources/sounds/AbstractTickableSoundInstance;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "ride", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettings;", "soundSettings", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettings;)V", "", "tick", "()V", "runFade", "", "outOfRange", "()Z", "", "calcDopplerInfluence", "()D", "", "soundOcclusion", "()F", "setPos", "stopSound", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getRide", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettings;", "getSoundSettings", "()Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettings;", "shouldStop", "Z", "getShouldStop", "setShouldStop", "(Z)V", "fade", "F", "getFade", "setFade", "(F)V", "shouldMuffle", "getShouldMuffle", "setShouldMuffle", "Lcom/cobblemon/mod/common/api/riding/sound/RideAttenuationModel;", "rideAttenuation", "Lcom/cobblemon/mod/common/api/riding/sound/RideAttenuationModel;", "getRideAttenuation", "()Lcom/cobblemon/mod/common/api/riding/sound/RideAttenuationModel;", "setRideAttenuation", "(Lcom/cobblemon/mod/common/api/riding/sound/RideAttenuationModel;)V", "muffleAmount", "getMuffleAmount", "setMuffleAmount", "isPassenger", "setPassenger", "common"})
@SourceDebugExtension(value={"SMAP\nRideLoopSound.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RideLoopSound.kt\ncom/cobblemon/mod/common/api/riding/sound/RideLoopSound\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1761#2,3:192\n1#3:195\n*S KotlinDebug\n*F\n+ 1 RideLoopSound.kt\ncom/cobblemon/mod/common/api/riding/sound/RideLoopSound\n*L\n46#1:192,3\n*E\n"})
public final class RideLoopSound
extends AbstractTickableSoundInstance {
    @NotNull
    private final PokemonEntity ride;
    @NotNull
    private final RideSoundSettings soundSettings;
    private boolean shouldStop;
    private float fade;
    private boolean shouldMuffle;
    @NotNull
    private RideAttenuationModel rideAttenuation;
    private float muffleAmount;
    private boolean isPassenger;

    /*
     * WARNING - void declaration
     */
    public RideLoopSound(@NotNull PokemonEntity ride, @NotNull RideSoundSettings soundSettings) {
        boolean bl;
        boolean bl2;
        block4: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)ride, (String)"ride");
            Intrinsics.checkNotNullParameter((Object)soundSettings, (String)"soundSettings");
            super(SoundEvent.createVariableRangeEvent((ResourceLocation)soundSettings.getSoundLocation()), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
            this.ride = ride;
            this.soundSettings = soundSettings;
            this.shouldMuffle = this.soundSettings.getMuffleEnabled();
            this.rideAttenuation = this.soundSettings.getAttenuationModel();
            this.muffleAmount = 1.0f;
            List list = this.ride.getPassengers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
            Iterable iterable = list;
            RideLoopSound rideLoopSound = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entity passenger = (Entity)element$iv;
                    boolean bl3 = false;
                    LocalPlayer localPlayer = Minecraft.getInstance().player;
                    boolean bl4 = localPlayer != null ? localPlayer.getId() == passenger.getId() : false;
                    if (!bl4) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
        }
        rideLoopSound.isPassenger = bl = bl2;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.1f;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        if (this.isPassenger) {
            this.relative = true;
        }
    }

    @NotNull
    public final PokemonEntity getRide() {
        return this.ride;
    }

    @NotNull
    public final RideSoundSettings getSoundSettings() {
        return this.soundSettings;
    }

    public final boolean getShouldStop() {
        return this.shouldStop;
    }

    public final void setShouldStop(boolean bl) {
        this.shouldStop = bl;
    }

    public final float getFade() {
        return this.fade;
    }

    public final void setFade(float f) {
        this.fade = f;
    }

    public final boolean getShouldMuffle() {
        return this.shouldMuffle;
    }

    public final void setShouldMuffle(boolean bl) {
        this.shouldMuffle = bl;
    }

    @NotNull
    public final RideAttenuationModel getRideAttenuation() {
        return this.rideAttenuation;
    }

    public final void setRideAttenuation(@NotNull RideAttenuationModel rideAttenuationModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)rideAttenuationModel), (String)"<set-?>");
        this.rideAttenuation = rideAttenuationModel;
    }

    public final float getMuffleAmount() {
        return this.muffleAmount;
    }

    public final void setMuffleAmount(float f) {
        this.muffleAmount = f;
    }

    public final boolean isPassenger() {
        return this.isPassenger;
    }

    public final void setPassenger(boolean bl) {
        this.isPassenger = bl;
    }

    public void tick() {
        Expression it;
        this.runFade();
        if (this.outOfRange()) {
            this.volume = 0.0f;
            return;
        }
        Expression expression = this.soundSettings.getVolumeExpr();
        RideLoopSound rideLoopSound = this;
        boolean bl = false;
        double d = MoLangExtensionsKt.resolveDouble$default(this.ride.getRuntime(), it, null, 2, null);
        rideLoopSound.volume = (float)d;
        this.volume *= this.fade;
        it = this.soundSettings.getPitchExpr();
        rideLoopSound = this;
        boolean bl2 = false;
        d = MoLangExtensionsKt.resolveDouble$default(this.ride.getRuntime(), it, null, 2, null);
        rideLoopSound.pitch = (float)d;
        if (!this.isPassenger && this.soundSettings.getPlayForNonPassengers()) {
            this.setPos();
            this.pitch *= (float)this.calcDopplerInfluence();
            float soundOc = this.soundOcclusion();
            if (!(soundOc == 0.0f)) {
                float newMuffle = RangesKt.coerceIn((float)Mth.lerp((float)soundOc, (float)1.0f, (float)0.2f), (float)0.2f, (float)1.0f);
                this.muffleAmount = Mth.lerp((float)0.1f, (float)this.muffleAmount, (float)newMuffle);
                this.shouldMuffle = true;
                this.volume *= this.muffleAmount;
            } else {
                this.shouldMuffle = true;
                this.muffleAmount = Mth.lerp((float)0.1f, (float)this.muffleAmount, (float)1.0f);
                this.volume *= this.muffleAmount;
            }
        }
    }

    public final void runFade() {
        if (this.shouldStop && this.fade == 0.0f) {
            this.stop();
        } else if (this.shouldStop) {
            this.fade = Math.max(0.0f, this.fade - 0.05f);
        } else if (!this.shouldStop && !(this.fade == 1.0f)) {
            this.fade = Math.min(1.0f, this.fade + 0.05f);
        }
    }

    public final boolean outOfRange() {
        int attenDist = this.sound.getAttenuationDistance();
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null || (localPlayer = localPlayer.getEyePosition()) == null) {
            return false;
        }
        LocalPlayer listenerPosition = localPlayer;
        return listenerPosition.distanceTo(this.ride.position()) > (double)attenDist;
    }

    public final double calcDopplerInfluence() {
        Vec3 rideVel = this.ride.getRideVelocity();
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return 1.0;
        }
        LocalPlayer listener = localPlayer;
        Vec3 listenerVel = listener.getDeltaMovement();
        float waveSpeed = 6.86f;
        Vec3 lineOfSightToRide = this.ride.position().subtract(listener.position()).normalize();
        double velObserver = listenerVel.dot(lineOfSightToRide);
        double velSrc = rideVel.dot(lineOfSightToRide.scale(-1.0));
        double pitchFactor = ((double)waveSpeed + velObserver) / ((double)waveSpeed - velSrc);
        return pitchFactor;
    }

    public final float soundOcclusion() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return 0.0f;
        }
        LocalPlayer listener = localPlayer;
        Level level = listener.level();
        int maxAttenDist = this.sound.getAttenuationDistance();
        double totalMuffle = 0.0;
        Vec3 center = this.ride.getBoundingBox().getCenter();
        BlockHitResult hit = level.clip(new ClipContext(listener.getEyePosition(), center, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)listener));
        if (hit.getType() != HitResult.Type.MISS) {
            double hitDist = hit.getLocation().distanceTo(listener.getEyePosition());
            double hitMuffle = Mth.lerp((double)(1.0 - hitDist / (double)maxAttenDist), (double)0.3, (double)1.0);
            totalMuffle += hitMuffle;
        }
        return (float)totalMuffle;
    }

    public final void setPos() {
        this.x = this.ride.getX();
        this.y = this.ride.getY();
        this.z = this.ride.getZ();
    }

    public final void stopSound() {
        this.shouldStop = true;
    }
}

