/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.liquid;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.CobblemonRideSettings;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.BoatSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.BoatState;
import com.cobblemon.mod.common.api.riding.posing.PoseOption;
import com.cobblemon.mod.common.api.riding.posing.PoseProvider;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettingsList;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 h2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001hB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ7\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J7\u0010!\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b!\u0010\"J7\u0010#\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b#\u0010$J7\u0010%\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b%\u0010$J/\u0010&\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b(\u0010)J/\u0010*\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010,\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b,\u0010-J/\u0010.\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b.\u0010+J/\u0010/\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b/\u00100J/\u00101\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b1\u00100J7\u00104\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b4\u00105J_\u0010<\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u0002022\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u0002082\u0006\u0010;\u001a\u0002022\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b<\u0010=J/\u0010>\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b>\u0010?J/\u0010@\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b@\u0010\u001cJ7\u0010C\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010B\u001a\u00020AH\u0016\u00a2\u0006\u0004\bC\u0010DJ/\u0010F\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010E\u001a\u000202H\u0016\u00a2\u0006\u0004\bF\u0010GJ/\u0010H\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\bH\u0010\u001cJ'\u0010I\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bI\u0010\u000fJ'\u0010J\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bJ\u0010KJ'\u0010L\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bL\u0010\u000fJ'\u0010M\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bM\u0010\u000fJ'\u0010N\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bN\u0010\u000fJ'\u0010O\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bO\u0010\u000fJ'\u0010P\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bP\u0010\u000fJ'\u0010R\u001a\u00020Q2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bR\u0010SJ'\u0010T\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bT\u0010UJ\u0017\u0010V\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bV\u0010WJ9\u0010Y\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010X2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bY\u0010ZR\u001a\u0010\\\u001a\u00020[8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_R\u0011\u0010b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b`\u0010aR#\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030c8\u0006\u00a2\u0006\f\n\u0004\bd\u0010e\u001a\u0004\bf\u0010g\u00a8\u0006i"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;", "<init>", "()V", "settings", "state", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "getRidingStyle", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;)Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "", "isActive", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/entity/player/Player;", "driver", "Lnet/minecraft/world/phys/Vec3;", "input", "", "tick", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V", "Lcom/cobblemon/mod/common/entity/PoseType;", "pose", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/entity/PoseType;", "", "speed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)F", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/phys/Vec2;", "rotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec2;", "velocity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "applyVelocityFromInput", "(Lnet/minecraft/world/phys/Vec3;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;)Lnet/minecraft/world/phys/Vec3;", "applyJump", "applyGravity", "(Lnet/minecraft/world/phys/Vec3;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;)Lnet/minecraft/world/phys/Vec3;", "shouldFloatHigher", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;)Z", "applyStrafeRotation", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;)V", "hasStamina", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;)Z", "consumeStamina", "updatePassengerRotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)V", "clampPassengerRotation", "", "deltaTime", "angRollVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)Lnet/minecraft/world/phys/Vec3;", "mouseY", "mouseX", "Lnet/minecraft/util/SmoothDouble;", "mouseYSmoother", "mouseXSmoother", "sensitivity", "rotationOnMouseXY", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;DDLnet/minecraft/util/SmoothDouble;Lnet/minecraft/util/SmoothDouble;DD)Lnet/minecraft/world/phys/Vec3;", "canJump", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Z", "setRideBar", "", "jumpStrength", "jumpForce", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/phys/Vec3;", "regularGravity", "gravity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;D)D", "rideFovMultiplier", "useAngVelSmoothing", "inertia", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)D", "shouldRoll", "turnOffOnGround", "dismountOnShift", "shouldRotatePokemonHead", "shouldRotateRiderHead", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "getRideSounds", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "maxUpStep", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Ljava/lang/Float;", "createDefaultState", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;)Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "asMoLangValue", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "()Lnet/minecraft/resources/ResourceLocation;", "getGlobalBoat", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatSettings;", "globalBoat", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "poseProvider", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "getPoseProvider", "()Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nBoatBehaviour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoatBehaviour.kt\ncom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatBehaviour\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,500:1\n1761#2,3:501\n1761#2,3:504\n*S KotlinDebug\n*F\n+ 1 BoatBehaviour.kt\ncom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatBehaviour\n*L\n72#1:501,3\n393#1:504,3\n*E\n"})
public final class BoatBehaviour
implements RidingBehaviour<BoatSettings, BoatState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation key = KEY;
    @NotNull
    private final PoseProvider<BoatSettings, BoatState> poseProvider = new PoseProvider(PoseType.STAND).with(new PoseOption(PoseType.WALK, BoatBehaviour::poseProvider$lambda$0));
    @NotNull
    private static final ResourceLocation KEY = MiscUtilsKt.cobblemonResource("liquid/boat");

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.key;
    }

    @NotNull
    public final BoatSettings getGlobalBoat() {
        return CobblemonRideSettings.INSTANCE.getBoat();
    }

    @Override
    @NotNull
    public RidingStyle getRidingStyle(@NotNull BoatSettings settings, @NotNull BoatState state) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RidingStyle.LIQUID;
    }

    @NotNull
    public final PoseProvider<BoatSettings, BoatState> getPoseProvider() {
        return this.poseProvider;
    }

    @Override
    public boolean isActive(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
            if (((Number)state.getJumpBuffer().get()).intValue() != -1) {
                return true;
            }
            VoxelShape voxelShape = Shapes.create((AABB)vehicle.getBoundingBox());
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"create(...)");
            Iterable $this$any$iv = MiscUtilsKt.blockPositionsAsListRounded(voxelShape);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockState blockState;
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl2 = false;
                    if (!(vehicle.isInWater() || vehicle.isUnderWater() ? true : !(blockState = vehicle.level().getBlockState(it)).getFluidState().isEmpty())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void tick(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (((Number)state.getJumpBuffer().get()).intValue() > 5) {
            if (vehicle.isInWater() || vehicle.isUnderWater() || vehicle.onGround()) {
                SidedRidingState.set$default(state.getJumpBuffer(), -1, false, 2, null);
            }
        } else if (((Number)state.getJumpBuffer().get()).intValue() > -1) {
            SidedRidingState.set$default(state.getJumpBuffer(), ((Number)state.getJumpBuffer().get()).intValue() + 1, false, 2, null);
        }
        if (driver.isSprinting() && !state.isVehicleSprinting().get().booleanValue()) {
            SidedRidingState.set$default(state.isVehicleSprinting(), ((Number)state.getStamina().get()).floatValue() > 0.33f, false, 2, null);
        } else if (!driver.isSprinting()) {
            SidedRidingState.set$default(state.isVehicleSprinting(), false, false, 2, null);
        }
        if (!state.isVehicleSprinting().get().booleanValue()) {
            if (((Number)state.getStaminaBuffer().get()).intValue() >= 20) {
                double d = 1.0f;
                MoLangRuntime moLangRuntime = vehicle.getRuntime();
                Expression expression = settings.getStamReplenishTimeSeconds();
                if (expression == null) {
                    Expression expression2 = this.getGlobalBoat().getStamReplenishTimeSeconds();
                    expression = expression2;
                    Intrinsics.checkNotNull((Object)expression2);
                }
                float staminaIncrease = (float)(d / MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null)) / 20.0f;
                SidedRidingState.set$default(state.getStamina(), Float.valueOf(Math.min(1.0f, ((Number)state.getStamina().get()).floatValue() + staminaIncrease)), false, 2, null);
            }
        } else if (Math.abs(state.getRideVelocity().get().z) > 0.1 && state.isVehicleSprinting().get().booleanValue()) {
            this.consumeStamina(vehicle, driver, settings, state);
        }
        SidedRidingState.set$default(state.getStaminaBuffer(), ((Number)state.getStaminaBuffer().get()).intValue() + 1, false, 2, null);
        RidingBehaviour.super.tick((RidingBehaviourSettings)settings, (RidingBehaviourState)state, vehicle, driver, input);
    }

    @Override
    @NotNull
    public PoseType pose(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return this.poseProvider.select((BoatSettings)((RidingBehaviourSettings)settings), (BoatState)((RidingBehaviourState)state), vehicle);
    }

    @Override
    public float speed(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return (float)state.getRideVelocity().get().length();
    }

    @Override
    @NotNull
    public Vec2 rotation(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        SidedRidingState.set$default(state.getDeltaRotation(), ((Number)state.getDeltaRotation().get()).doubleValue() * 0.8, false, 2, null);
        return new Vec2(vehicle.getXRot(), vehicle.getYRot() + (float)((Number)state.getDeltaRotation().get()).doubleValue());
    }

    @Override
    @NotNull
    public Vec3 velocity(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.applyStrafeRotation(vehicle, driver, settings, state);
        Vec3 velocity = state.getRideVelocity().get();
        velocity = this.applyVelocityFromInput(velocity, vehicle, driver, settings, state);
        velocity = this.applyGravity(velocity, vehicle, settings, state);
        velocity = this.applyJump(velocity, vehicle, driver, settings, state);
        SidedRidingState.set$default(state.getRideVelocity(), velocity, false, 2, null);
        return state.getRideVelocity().get();
    }

    private final Vec3 applyVelocityFromInput(Vec3 velocity, PokemonEntity vehicle, Player driver, BoatSettings settings, BoatState state) {
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double speed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getAccelerationExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalBoat().getAccelerationExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double acceleration = speed / (MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * (double)20);
        if (((Number)state.getJumpBuffer().get()).intValue() != -1 || !vehicle.isInWater() && !vehicle.isUnderWater()) {
            return velocity;
        }
        MoLangRuntime moLangRuntime3 = vehicle.getRuntime();
        Expression expression5 = settings.getSprintSpeedModifier();
        if (expression5 == null) {
            Expression expression6 = this.getGlobalBoat().getSprintSpeedModifier();
            expression5 = expression6;
            Intrinsics.checkNotNull((Object)expression6);
        }
        double sprintModifier = MoLangExtensionsKt.resolveDouble$default(moLangRuntime3, expression5, null, 2, null);
        double activeSprintModifier = state.isVehicleSprinting().get() != false && this.hasStamina(state) ? sprintModifier : 1.0;
        double forwardInput = driver.zza;
        double delta = forwardInput == 0.0 ? -velocity.z * 0.04 : (forwardInput < 0.0 ? (velocity.z < 0.0 ? forwardInput * acceleration * 0.5 : Math.min(forwardInput * acceleration * 0.5, -velocity.z * 0.04)) : forwardInput * acceleration * activeSprintModifier);
        return new Vec3(velocity.x, velocity.y, Mth.clamp((double)(velocity.z + delta), (double)(-speed * 0.25), (double)(speed * activeSprintModifier)));
    }

    private final Vec3 applyJump(Vec3 velocity, PokemonEntity vehicle, Player driver, BoatSettings settings, BoatState state) {
        if (!driver.jumping) {
            return velocity;
        }
        if (((Number)state.getJumpBuffer().get()).intValue() != -1) {
            return velocity;
        }
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getJumpStrengthExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getJumpStrengthExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double jumpStrength = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        SidedRidingState.set$default(state.getJumpBuffer(), 0, false, 2, null);
        return new Vec3(velocity.x, velocity.y + jumpStrength, velocity.z);
    }

    private final Vec3 applyGravity(Vec3 velocity, PokemonEntity vehicle, BoatSettings settings, BoatState state) {
        if (((Number)state.getJumpBuffer().get()).intValue() == -1 && (vehicle.isInWater() || vehicle.isUnderWater())) {
            if (this.shouldFloatHigher(vehicle, settings)) {
                return new Vec3(velocity.x, 0.5, velocity.z);
            }
            return new Vec3(velocity.x, 0.0, velocity.z);
        }
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getTerminalVelocity();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getTerminalVelocity();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double terminalVelocity = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        double gravity = 0.09800000000000002;
        return new Vec3(velocity.x, Math.max(velocity.y - gravity, terminalVelocity), velocity.z);
    }

    private final boolean shouldFloatHigher(PokemonEntity vehicle, BoatSettings settings) {
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSurfaceLevelOffset();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getSurfaceLevelOffset();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        float surfaceOffset = MoLangExtensionsKt.resolveFloat$default(moLangRuntime, expression, null, 2, null);
        BlockPos blockPos = BlockPos.containing((double)vehicle.getX(), (double)(vehicle.getEyeY() + (double)surfaceOffset), (double)vehicle.getZ());
        FluidState fluidState = vehicle.level().getFluidState(blockPos);
        return !fluidState.isEmpty();
    }

    private final void applyStrafeRotation(PokemonEntity vehicle, Player driver, BoatSettings settings, BoatState state) {
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getRotationSpeedModifierExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getRotationSpeedModifierExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double skillModifier = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        float strafe = driver.xxa;
        if (Math.abs(strafe) > 0.0f) {
            int increase = strafe > 0.0f ? -1 : 1;
            SidedRidingState.set$default(state.getDeltaRotation(), ((Number)state.getDeltaRotation().get()).doubleValue() + (double)increase * skillModifier, false, 2, null);
        }
    }

    private final boolean hasStamina(BoatState state) {
        return !(((Number)state.getStamina().get()).floatValue() == 0.0f);
    }

    private final void consumeStamina(PokemonEntity vehicle, Player driver, BoatSettings settings, BoatState state) {
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getInfiniteStamina();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getInfiniteStamina();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        if (MoLangExtensionsKt.resolveBoolean$default(moLangRuntime, expression, null, 2, null)) {
            return;
        }
        double d = 1.0f;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getStaminaExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalBoat().getStaminaExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        float stamDrainRate = (float)(d / MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null)) / 20.0f;
        SidedRidingState.set$default(state.getStamina(), Float.valueOf(Math.max(0.0f, ((Number)state.getStamina().get()).floatValue() - stamDrainRate)), false, 2, null);
        if (((Number)state.getStamina().get()).floatValue() == 0.0f) {
            SidedRidingState.set$default(state.isVehicleSprinting(), false, false, 2, null);
            driver.setSprinting(false);
        }
        SidedRidingState.set$default(state.getStaminaBuffer(), 0, false, 2, null);
    }

    @Override
    public void updatePassengerRotation(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.setYRot(driver.getYRot() + (float)((Number)state.getDeltaRotation().get()).doubleValue() * 0.887f);
        driver.yHeadRot += (float)((Number)state.getDeltaRotation().get()).doubleValue() * 0.887f;
        this.clampPassengerRotation(settings, state, vehicle, driver);
    }

    @Override
    public void clampPassengerRotation(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.setYBodyRot(vehicle.getYRot());
        float f = Mth.wrapDegrees((float)(driver.getYRot() - vehicle.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        driver.yRotO += g - f;
        driver.setYRot(driver.getYRot() + g - f);
        driver.setYHeadRot(driver.getYRot());
        vehicle.setYHeadRot(driver.getYRot());
    }

    @Override
    @NotNull
    public Vec3 angRollVel(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 rotationOnMouseXY(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double mouseY, double mouseX, @NotNull SmoothDouble mouseYSmoother, @NotNull SmoothDouble mouseXSmoother, double sensitivity, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)mouseYSmoother, (String)"mouseYSmoother");
        Intrinsics.checkNotNullParameter((Object)mouseXSmoother, (String)"mouseXSmoother");
        if (!(driver instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        return new Vec3(0.0, mouseY, mouseX);
    }

    @Override
    public boolean canJump(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return false;
    }

    @Override
    public float setRideBar(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return ((Number)state.getStamina().get()).floatValue() / 1.0f;
    }

    @Override
    @NotNull
    public Vec3 jumpForce(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, int jumpStrength) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public double gravity(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, double regularGravity) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 0.0;
    }

    @Override
    public float rideFovMultiplier(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSprintFovModifier();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getSprintFovModifier();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        float sprintFov = MoLangExtensionsKt.resolveFloat$default(moLangRuntime, expression, null, 2, null);
        return state.isVehicleSprinting().get() != false ? sprintFov : 1.0f;
    }

    @Override
    public boolean useAngVelSmoothing(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public double inertia(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 0.5;
    }

    @Override
    public boolean shouldRoll(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean turnOffOnGround(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean dismountOnShift(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotatePokemonHead(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getRotatePokemonHead();
        if (expression == null) {
            Expression expression2 = this.getGlobalBoat().getRotatePokemonHead();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        return MoLangExtensionsKt.resolveBoolean$default(moLangRuntime, expression, null, 2, null);
    }

    @Override
    public boolean shouldRotateRiderHead(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return true;
    }

    @Override
    @NotNull
    public RideSoundSettingsList getRideSounds(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return settings.getRideSounds();
    }

    @Override
    @NotNull
    public Float maxUpStep(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return Float.valueOf(0.0f);
    }

    @Override
    @NotNull
    public BoatState createDefaultState(@NotNull BoatSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new BoatState();
    }

    @Override
    @NotNull
    public ObjectValue<RidingBehaviour<BoatSettings, BoatState>> asMoLangValue(@NotNull BoatSettings settings, @NotNull BoatState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        ObjectValue<RidingBehaviour<BoatSettings, BoatState>> value = RidingBehaviour.super.asMoLangValue((RidingBehaviourSettings)settings, (RidingBehaviourState)state, vehicle);
        value.functions.put("sprinting", arg_0 -> BoatBehaviour.asMoLangValue$lambda$0(state, arg_0));
        value.functions.put("in_air", arg_0 -> BoatBehaviour.asMoLangValue$lambda$1(vehicle, arg_0));
        return value;
    }

    private static final boolean poseProvider$lambda$0(BoatSettings boatSettings, BoatState state, PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)boatSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"<unused var>");
        return Math.abs(state.getRideVelocity().get().horizontalDistance()) > 0.2;
    }

    private static final Object asMoLangValue$lambda$0(BoatState $state, MoParams it) {
        return new DoubleValue($state.isVehicleSprinting().get());
    }

    private static final Object asMoLangValue$lambda$1(PokemonEntity $vehicle, MoParams it) {
        boolean bl;
        block3: {
            VoxelShape voxelShape = Shapes.create((AABB)$vehicle.getBoundingBox());
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"create(...)");
            Iterable $this$any$iv = MiscUtilsKt.blockPositionsAsListRounded(voxelShape);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockState blockState;
                    BlockPos it2 = (BlockPos)element$iv;
                    boolean bl2 = false;
                    if (!($vehicle.isInWater() || $vehicle.isUnderWater() ? true : !(blockState = $vehicle.level().getBlockState(it2)).getFluidState().isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isInWater = bl;
        return new DoubleValue(!isInWater);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/BoatBehaviour$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "KEY", "Lnet/minecraft/resources/ResourceLocation;", "getKEY", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

