/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.air;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourStateKt;
import com.cobblemon.mod.common.api.riding.behaviour.Side;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0014\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R(\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u0014\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R(\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u0014\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018R(\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010\u0014\u001a\u0004\b*\u0010\u0016\"\u0004\b+\u0010\u0018\u00a8\u0006,"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "<init>", "()V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "decode", "reset", "copy", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;", "previous", "", "shouldSync", "(Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;)Z", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "", "currSpeed", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "getCurrSpeed", "()Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "setCurrSpeed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;)V", "currMouseXForce", "getCurrMouseXForce", "setCurrMouseXForce", "currMouseYForce", "getCurrMouseYForce", "setCurrMouseYForce", "boosting", "getBoosting", "setBoosting", "boostIsToggleable", "getBoostIsToggleable", "setBoostIsToggleable", "canSpeedBurst", "getCanSpeedBurst", "setCanSpeedBurst", "", "noStamTickCnt", "getNoStamTickCnt", "setNoStamTickCnt", "common"})
public final class JetState
extends RidingBehaviourState {
    @NotNull
    private SidedRidingState<Double> currSpeed = RidingBehaviourStateKt.ridingState(0.0, Side.CLIENT);
    @NotNull
    private SidedRidingState<Double> currMouseXForce = RidingBehaviourStateKt.ridingState(0.0, Side.CLIENT);
    @NotNull
    private SidedRidingState<Double> currMouseYForce = RidingBehaviourStateKt.ridingState(0.0, Side.CLIENT);
    @NotNull
    private SidedRidingState<Boolean> boosting = RidingBehaviourStateKt.ridingState(false, Side.BOTH);
    @NotNull
    private SidedRidingState<Boolean> boostIsToggleable = RidingBehaviourStateKt.ridingState(false, Side.BOTH);
    @NotNull
    private SidedRidingState<Boolean> canSpeedBurst = RidingBehaviourStateKt.ridingState(false, Side.BOTH);
    @NotNull
    private SidedRidingState<Integer> noStamTickCnt = RidingBehaviourStateKt.ridingState(0, Side.CLIENT);

    @NotNull
    public final SidedRidingState<Double> getCurrSpeed() {
        return this.currSpeed;
    }

    public final void setCurrSpeed(@NotNull SidedRidingState<Double> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.currSpeed = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Double> getCurrMouseXForce() {
        return this.currMouseXForce;
    }

    public final void setCurrMouseXForce(@NotNull SidedRidingState<Double> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.currMouseXForce = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Double> getCurrMouseYForce() {
        return this.currMouseYForce;
    }

    public final void setCurrMouseYForce(@NotNull SidedRidingState<Double> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.currMouseYForce = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Boolean> getBoosting() {
        return this.boosting;
    }

    public final void setBoosting(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.boosting = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Boolean> getBoostIsToggleable() {
        return this.boostIsToggleable;
    }

    public final void setBoostIsToggleable(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.boostIsToggleable = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Boolean> getCanSpeedBurst() {
        return this.canSpeedBurst;
    }

    public final void setCanSpeedBurst(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.canSpeedBurst = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Integer> getNoStamTickCnt() {
        return this.noStamTickCnt;
    }

    public final void setNoStamTickCnt(@NotNull SidedRidingState<Integer> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.noStamTickCnt = sidedRidingState;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.encode(buffer);
        buffer.writeDouble(((Number)this.currSpeed.get()).doubleValue());
        buffer.writeFloat(((Number)this.getStamina().get()).floatValue());
        buffer.writeBoolean(this.boosting.get().booleanValue());
        buffer.writeBoolean(this.boostIsToggleable.get().booleanValue());
        buffer.writeBoolean(this.canSpeedBurst.get().booleanValue());
    }

    @Override
    public void decode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.decode(buffer);
        this.currSpeed.set(buffer.readDouble(), true);
        this.boosting.set(buffer.readBoolean(), true);
        this.boostIsToggleable.set(buffer.readBoolean(), true);
        this.canSpeedBurst.set(buffer.readBoolean(), true);
    }

    @Override
    public void reset() {
        super.reset();
        this.currSpeed.set(0.0, true);
        this.currMouseXForce.set(0.0, true);
        this.currMouseYForce.set(0.0, true);
        this.boosting.set(false, true);
        this.boostIsToggleable.set(false, true);
        this.canSpeedBurst.set(true, true);
        this.noStamTickCnt.set(0, true);
    }

    @Override
    @NotNull
    public JetState copy() {
        JetState jetState;
        JetState it = jetState = new JetState();
        boolean bl = false;
        it.currSpeed.set(this.currSpeed.get(), true);
        it.getStamina().set(this.getStamina().get(), true);
        it.getRideVelocity().set(this.getRideVelocity().get(), true);
        it.boosting.set(this.boosting.get(), true);
        it.boostIsToggleable.set(this.boosting.get(), true);
        it.canSpeedBurst.set(this.canSpeedBurst.get(), true);
        return jetState;
    }

    @Override
    public boolean shouldSync(@NotNull RidingBehaviourState previous) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        if (!(previous instanceof JetState)) {
            return false;
        }
        if (!Intrinsics.areEqual(((JetState)previous).currSpeed, this.currSpeed)) {
            return true;
        }
        return super.shouldSync(previous);
    }
}

