/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.air;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangMath;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.CobblemonRideSettings;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.JetSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.JetState;
import com.cobblemon.mod.common.api.riding.posing.PoseOption;
import com.cobblemon.mod.common.api.riding.posing.PoseProvider;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettingsList;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 `2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001`B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J7\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010#\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J7\u0010%\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b%\u0010&J/\u0010'\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b'\u0010(J7\u0010+\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,J_\u00103\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020)2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b3\u00104J/\u00105\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b5\u00106J/\u00107\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b7\u0010\u0017J7\u0010:\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b:\u0010;J/\u0010=\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020)H\u0016\u00a2\u0006\u0004\b=\u0010>J/\u0010?\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b?\u0010\u0017J'\u0010@\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b@\u0010\u000fJ'\u0010A\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bA\u0010BJ'\u0010C\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bC\u0010\u000fJ'\u0010D\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bD\u0010\u000fJ'\u0010E\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bE\u0010\u000fJ'\u0010F\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bF\u0010\u000fJ'\u0010G\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bG\u0010\u000fJ'\u0010I\u001a\u00020H2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bI\u0010JJ\u0017\u0010K\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bK\u0010LJ/\u0010N\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\bN\u0010OJ9\u0010Q\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010P2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bQ\u0010RR\u001a\u0010T\u001a\u00020S8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bV\u0010WR\u0011\u0010Z\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bX\u0010YR#\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030[8\u0006\u00a2\u0006\f\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_\u00a8\u0006a"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;", "<init>", "()V", "settings", "state", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "getRidingStyle", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;)Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "", "isActive", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lcom/cobblemon/mod/common/entity/PoseType;", "pose", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/entity/PoseType;", "Lnet/minecraft/world/entity/player/Player;", "driver", "", "speed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)F", "Lnet/minecraft/world/phys/Vec3;", "input", "", "tick", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V", "handleBoosting", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;)V", "tickStamina", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/phys/Vec2;", "rotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec2;", "velocity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "calculateRideSpaceVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)V", "", "deltaTime", "angRollVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)Lnet/minecraft/world/phys/Vec3;", "mouseY", "mouseX", "Lnet/minecraft/util/SmoothDouble;", "mouseYSmoother", "mouseXSmoother", "sensitivity", "rotationOnMouseXY", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;DDLnet/minecraft/util/SmoothDouble;Lnet/minecraft/util/SmoothDouble;DD)Lnet/minecraft/world/phys/Vec3;", "canJump", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Z", "setRideBar", "", "jumpStrength", "jumpForce", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/phys/Vec3;", "regularGravity", "gravity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;D)D", "rideFovMultiplier", "useAngVelSmoothing", "inertia", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)D", "shouldRoll", "turnOffOnGround", "dismountOnShift", "shouldRotatePokemonHead", "shouldRotateRiderHead", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "getRideSounds", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "createDefaultState", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;)Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;", "impactVec", "damageOnCollision", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/phys/Vec3;)Z", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "asMoLangValue", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "()Lnet/minecraft/resources/ResourceLocation;", "getGlobalJet", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetSettings;", "globalJet", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "poseProvider", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "getPoseProvider", "()Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nJetBehaviour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBehaviour.kt\ncom/cobblemon/mod/common/api/riding/behaviour/types/air/JetBehaviour\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,589:1\n1761#2,3:590\n*S KotlinDebug\n*F\n+ 1 JetBehaviour.kt\ncom/cobblemon/mod/common/api/riding/behaviour/types/air/JetBehaviour\n*L\n70#1:590,3\n*E\n"})
public final class JetBehaviour
implements RidingBehaviour<JetSettings, JetState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation key = KEY;
    @NotNull
    private final PoseProvider<JetSettings, JetState> poseProvider = new PoseProvider(PoseType.HOVER).with(new PoseOption(PoseType.FLY, JetBehaviour::poseProvider$lambda$0));
    @NotNull
    private static final ResourceLocation KEY = MiscUtilsKt.cobblemonResource("air/jet");

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public RidingStyle getRidingStyle(@NotNull JetSettings settings, @NotNull JetState state) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RidingStyle.AIR;
    }

    @NotNull
    public final JetSettings getGlobalJet() {
        return CobblemonRideSettings.INSTANCE.getJet();
    }

    @NotNull
    public final PoseProvider<JetSettings, JetState> getPoseProvider() {
        return this.poseProvider;
    }

    @Override
    public boolean isActive(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
            VoxelShape voxelShape = Shapes.create((AABB)vehicle.getBoundingBox());
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"create(...)");
            Iterable $this$any$iv = MiscUtilsKt.blockPositionsAsListRounded(voxelShape);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockState blockState;
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = vehicle.isInWater() || vehicle.isUnderWater() ? false : ((double)it.getY() == vehicle.position().y ? (blockState = vehicle.level().getBlockState(it.below())).isAir() || !blockState.getFluidState().isEmpty() : true);
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public PoseType pose(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return this.poseProvider.select((JetSettings)((RidingBehaviourSettings)settings), (JetState)((RidingBehaviourState)state), vehicle);
    }

    @Override
    public float speed(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return (float)state.getRideVelocity().get().length();
    }

    @Override
    public void tick(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (vehicle.level().isClientSide) {
            this.handleBoosting(state);
            this.tickStamina(settings, state, vehicle);
        }
    }

    public final void handleBoosting(@NotNull JetState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        boolean boostKeyPressed = Minecraft.getInstance().options.keySprint.isDown();
        if (!(((Number)state.getStamina().get()).floatValue() == 0.0f) && boostKeyPressed) {
            if (((Number)state.getStamina().get()).floatValue() >= 0.0f) {
                if (state.getBoostIsToggleable().get().booleanValue()) {
                    SidedRidingState.set$default(state.getBoosting(), state.getBoosting().get() == false, false, 2, null);
                }
                SidedRidingState.set$default(state.getBoostIsToggleable(), false, false, 2, null);
            }
        } else {
            SidedRidingState.set$default(state.getBoostIsToggleable(), true, false, 2, null);
            SidedRidingState.set$default(state.getBoosting(), false, false, 2, null);
            SidedRidingState.set$default(state.getCanSpeedBurst(), true, false, 2, null);
        }
    }

    public final void tickStamina(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        float stam;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        float newStam = stam = ((Number)state.getStamina().get()).floatValue();
        double d = 1.0f;
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getStaminaExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalJet().getStaminaExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        float stamDrainRate = (float)(d / MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null)) / 20.0f;
        newStam = state.getBoosting().get() != false ? Math.max(0.0f, stam - stamDrainRate * 1.5f) : Math.max(0.0f, stam - stamDrainRate);
        if (newStam == 0.0f) {
            SidedRidingState.set$default(state.getNoStamTickCnt(), ((Number)state.getNoStamTickCnt().get()).intValue() + 1, false, 2, null);
        } else {
            state.getNoStamTickCnt().get();
        }
        SidedRidingState.set$default(state.getStamina(), Float.valueOf(newStam), false, 2, null);
    }

    @Override
    @NotNull
    public Vec2 rotation(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return new Vec2(driver.getXRot() * 0.5f, driver.getYRot());
    }

    @Override
    @NotNull
    public Vec3 velocity(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        OrientationController controller;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        OrientationControllable orientationControllable = vehicle instanceof OrientationControllable ? (OrientationControllable)((Object)vehicle) : null;
        OrientationController orientationController = controller = orientationControllable != null ? orientationControllable.getOrientationController() : null;
        if (controller == null || controller.getOrientation() == null) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        this.calculateRideSpaceVel(settings, state, vehicle, driver);
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getMaxDownwardForceSeconds();
        if (expression == null) {
            Expression expression2 = this.getGlobalJet().getMaxDownwardForceSeconds();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        float penaltyDeccel = (float)MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) * 20.0f;
        double extraDownwardForce = ((Number)state.getStamina().get()).floatValue() == 0.0f ? -0.3 * (double)RangesKt.coerceIn((float)(((Number)state.getNoStamTickCnt().get()).floatValue() / penaltyDeccel), (float)0.0f, (float)1.0f) : 0.0;
        Vector3f localVelVec = new Vector3f((float)state.getRideVelocity().get().x, (float)state.getRideVelocity().get().y, (float)state.getRideVelocity().get().z * -1.0f);
        Vector3f vector3f = localVelVec.mul((Matrix3fc)controller.getOrientation());
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"mul(...)");
        Vec3 worldVelVec = Vec3ExtensionsKt.toVec3d(vector3f).yRot(AngleExtensionsKt.toRadians(Float.valueOf(((Entity)vehicle).getYRot())));
        Vec3 vec3 = worldVelVec = new Vec3(worldVelVec.x, worldVelVec.y * (double)(1.0f - RangesKt.coerceIn((float)(((Number)state.getNoStamTickCnt().get()).floatValue() / penaltyDeccel), (float)0.0f, (float)1.0f)), worldVelVec.z).add(0.0, extraDownwardForce, 0.0);
        Intrinsics.checkNotNull((Object)vec3);
        return vec3;
    }

    private final void calculateRideSpaceVel(JetSettings settings, JetState state, PokemonEntity vehicle, Player driver) {
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalJet().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) / 20.0;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getAccelerationExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalJet().getAccelerationExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double accel = topSpeed / (MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * 20.0);
        MoLangRuntime moLangRuntime3 = vehicle.getRuntime();
        Expression expression5 = settings.getDeccelRate();
        if (expression5 == null) {
            Expression expression6 = this.getGlobalJet().getDeccelRate();
            expression5 = expression6;
            Intrinsics.checkNotNull((Object)expression6);
        }
        double deccel = MoLangExtensionsKt.resolveDouble$default(moLangRuntime3, expression5, null, 2, null);
        MoLangRuntime moLangRuntime4 = vehicle.getRuntime();
        Expression expression7 = settings.getMinSpeedFactor();
        if (expression7 == null) {
            Expression expression8 = this.getGlobalJet().getMinSpeedFactor();
            expression7 = expression8;
            Intrinsics.checkNotNull((Object)expression8);
        }
        double minSpeed = topSpeed * MoLangExtensionsKt.resolveDouble$default(moLangRuntime4, expression7, null, 2, null);
        double speed = state.getRideVelocity().get().z;
        MoLangRuntime moLangRuntime5 = vehicle.getRuntime();
        Expression expression9 = settings.getJumpExpr();
        if (expression9 == null) {
            Expression expression10 = this.getGlobalJet().getJumpExpr();
            expression9 = expression10;
            Intrinsics.checkNotNull((Object)expression10);
        }
        double boostMult = MoLangExtensionsKt.resolveDouble$default(moLangRuntime5, expression9, null, 2, null);
        MoLangRuntime moLangRuntime6 = vehicle.getRuntime();
        Expression expression11 = settings.getMaxDownwardForceSeconds();
        if (expression11 == null) {
            Expression expression12 = this.getGlobalJet().getMaxDownwardForceSeconds();
            expression11 = expression12;
            Intrinsics.checkNotNull((Object)expression12);
        }
        float maxNoStamickCnt = (float)MoLangExtensionsKt.resolveDouble$default(moLangRuntime6, expression11, null, 2, null) * 20.0f;
        double boostTopSpeed = topSpeed * boostMult;
        double boostAccel = accel * boostMult;
        if (((Number)state.getStamina().get()).floatValue() == 0.0f) {
            double penaltyDeccel = deccel * (double)RangesKt.coerceIn((float)(((Number)state.getNoStamTickCnt().get()).floatValue() / maxNoStamickCnt), (float)0.0f, (float)1.0f);
            double minPenaltySpeed = minSpeed;
            SidedRidingState.set$default(state.getRideVelocity(), new Vec3(state.getRideVelocity().get().x, state.getRideVelocity().get().y, Math.max(state.getRideVelocity().get().z - penaltyDeccel, minPenaltySpeed)), false, 2, null);
        } else if (state.getBoosting().get().booleanValue() && speed < boostTopSpeed) {
            SidedRidingState.set$default(state.getRideVelocity(), new Vec3(state.getRideVelocity().get().x, state.getRideVelocity().get().y, Math.min(state.getRideVelocity().get().z + boostAccel, boostTopSpeed)), false, 2, null);
        } else if (speed < minSpeed || (double)driver.zza > 0.0 && speed < topSpeed) {
            double accelMod = Math.max(-RidingBehaviour.Companion.scaleToRange$common(speed, minSpeed, topSpeed) + 1.0, 0.0);
            SidedRidingState.set$default(state.getRideVelocity(), new Vec3(state.getRideVelocity().get().x, state.getRideVelocity().get().y, Math.min(state.getRideVelocity().get().z + accel * accelMod, topSpeed)), false, 2, null);
        } else if ((double)driver.zza < 0.0 && speed > minSpeed) {
            SidedRidingState.set$default(state.getRideVelocity(), new Vec3(state.getRideVelocity().get().x, state.getRideVelocity().get().y, Math.max(state.getRideVelocity().get().z - deccel, minSpeed)), false, 2, null);
        } else if (speed > topSpeed) {
            SidedRidingState<Vec3> sidedRidingState = state.getRideVelocity();
            Vec3 vec3 = state.getRideVelocity().get().scale(0.98);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
            SidedRidingState.set$default(sidedRidingState, vec3, false, 2, null);
        }
        SidedRidingState.set$default(state.getRideVelocity(), new Vec3(MoLangMath.lerp(state.getRideVelocity().get().x, 0.0, 0.03), MoLangMath.lerp(state.getRideVelocity().get().y, 0.0, 0.03), state.getRideVelocity().get().z), false, 2, null);
    }

    @Override
    @NotNull
    public Vec3 angRollVel(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        double cappedDeltaTime = Math.min(deltaTime, 0.2);
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getHandlingYawExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalJet().getHandlingYawExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double yawRotRate = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        double handlingYaw = yawRotRate * cappedDeltaTime;
        double yawForce = (double)driver.xxa * (handlingYaw *= (double)((Number)state.getStamina().get()).floatValue() > 0.0 ? 1.0 : 0.5) * (double)-1;
        return new Vec3(yawForce, 0.0, 0.0);
    }

    @Override
    @NotNull
    public Vec3 rotationOnMouseXY(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double mouseY, double mouseX, @NotNull SmoothDouble mouseYSmoother, @NotNull SmoothDouble mouseXSmoother, double sensitivity, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)mouseYSmoother, (String)"mouseYSmoother");
        Intrinsics.checkNotNullParameter((Object)mouseXSmoother, (String)"mouseXSmoother");
        if (!(vehicle instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        double cappedDeltaTime = Math.min(deltaTime, 0.2);
        SidedRidingState.set$default(state.getCurrMouseXForce(), RangesKt.coerceIn((double)(((Number)state.getCurrMouseXForce().get()).doubleValue() + 0.0015 * mouseX), (double)-1.0, (double)1.0), false, 2, null);
        SidedRidingState.set$default(state.getCurrMouseYForce(), RangesKt.coerceIn((double)(((Number)state.getCurrMouseYForce().get()).doubleValue() + 0.0015 * mouseY), (double)-1.0, (double)1.0), false, 2, null);
        double handlingDebuff = ((Number)state.getStamina().get()).floatValue() == 0.0f ? 0.5 : 1.0;
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getHandlingExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalJet().getHandlingExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double handling = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) * handlingDebuff;
        double pitchRot = (handling *= cappedDeltaTime) * ((Number)state.getCurrMouseYForce().get()).doubleValue();
        double rollRot = handling * ((Number)state.getCurrMouseXForce().get()).doubleValue();
        Vec3 mouseRotation = new Vec3(0.0, pitchRot, rollRot);
        if (Math.abs(mouseX) == 0.0) {
            SidedRidingState.set$default(state.getCurrMouseXForce(), MoLangMath.lerp(((Number)state.getCurrMouseXForce().get()).doubleValue(), 0.0, 0.02), false, 2, null);
        }
        if (mouseY == 0.0) {
            SidedRidingState.set$default(state.getCurrMouseYForce(), MoLangMath.lerp(((Number)state.getCurrMouseYForce().get()).doubleValue(), 0.0, 0.02), false, 2, null);
        }
        return mouseRotation;
    }

    @Override
    public boolean canJump(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return false;
    }

    @Override
    public float setRideBar(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return ((Number)state.getStamina().get()).floatValue() / 1.0f;
    }

    @Override
    @NotNull
    public Vec3 jumpForce(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, int jumpStrength) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public double gravity(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, double regularGravity) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 0.0;
    }

    @Override
    public float rideFovMultiplier(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getMaxDownwardForceSeconds();
        if (expression == null) {
            Expression expression2 = this.getGlobalJet().getMaxDownwardForceSeconds();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        float penaltyDeccel = (float)MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) * 20.0f;
        return ((Number)state.getNoStamTickCnt().get()).intValue() != 0 ? 1.0f - 0.2f * RangesKt.coerceIn((float)(((Number)state.getNoStamTickCnt().get()).floatValue() / penaltyDeccel), (float)0.0f, (float)1.0f) : (state.getBoosting().get() != false ? 1.2f : 1.0f);
    }

    @Override
    public boolean useAngVelSmoothing(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return true;
    }

    @Override
    public double inertia(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 1.0;
    }

    @Override
    public boolean shouldRoll(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return true;
    }

    @Override
    public boolean turnOffOnGround(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean dismountOnShift(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotatePokemonHead(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotateRiderHead(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    @NotNull
    public RideSoundSettingsList getRideSounds(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return settings.getRideSounds();
    }

    @Override
    @NotNull
    public JetState createDefaultState(@NotNull JetSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new JetState();
    }

    @Override
    public boolean damageOnCollision(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle, @NotNull Vec3 impactVec) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)impactVec, (String)"impactVec");
        float impactSpeed = (float)impactVec.horizontalDistance() * 10.0f;
        DamageSource damageSource = vehicle.damageSources().flyIntoWall();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"flyIntoWall(...)");
        return vehicle.causeFallDamage(impactSpeed, 1.0f, damageSource);
    }

    @Override
    @NotNull
    public ObjectValue<RidingBehaviour<JetSettings, JetState>> asMoLangValue(@NotNull JetSettings settings, @NotNull JetState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        ObjectValue<RidingBehaviour<JetSettings, JetState>> value = RidingBehaviour.super.asMoLangValue((RidingBehaviourSettings)settings, (RidingBehaviourState)state, vehicle);
        value.functions.put("boosting", arg_0 -> JetBehaviour.asMoLangValue$lambda$0(state, arg_0));
        value.functions.put("can_speed_burst", arg_0 -> JetBehaviour.asMoLangValue$lambda$1(state, arg_0));
        return value;
    }

    private static final boolean poseProvider$lambda$0(JetSettings jetSettings, JetState state, PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)jetSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"<unused var>");
        return state.getRideVelocity().get().z > 0.1;
    }

    private static final Object asMoLangValue$lambda$0(JetState $state, MoParams it) {
        return new DoubleValue($state.getBoosting().get());
    }

    private static final Object asMoLangValue$lambda$1(JetState $state, MoParams it) {
        return new DoubleValue($state.getCanSpeedBurst().get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/JetBehaviour$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "KEY", "Lnet/minecraft/resources/ResourceLocation;", "getKEY", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

