/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourStateKt;
import com.cobblemon.mod.common.api.riding.behaviour.Side;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fR \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00118\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0014\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "", "<init>", "()V", "", "reset", "copy", "()Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "previous", "", "shouldSync", "(Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;)Z", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "encode", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "decode", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "Lnet/minecraft/world/phys/Vec3;", "rideVelocity", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "getRideVelocity", "()Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "", "stamina", "getStamina", "common"})
public class RidingBehaviourState {
    @NotNull
    private final SidedRidingState<Vec3> rideVelocity = RidingBehaviourStateKt.ridingState(Vec3.ZERO, Side.CLIENT);
    @NotNull
    private final SidedRidingState<Float> stamina = RidingBehaviourStateKt.ridingState(Float.valueOf(1.0f), Side.CLIENT);

    @NotNull
    public SidedRidingState<Vec3> getRideVelocity() {
        return this.rideVelocity;
    }

    @NotNull
    public SidedRidingState<Float> getStamina() {
        return this.stamina;
    }

    public void reset() {
        SidedRidingState<Vec3> sidedRidingState = this.getRideVelocity();
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        sidedRidingState.set(vec3, true);
        this.getStamina().set(Float.valueOf(1.0f), true);
    }

    @NotNull
    public RidingBehaviourState copy() {
        RidingBehaviourState copy = new RidingBehaviourState();
        copy.getRideVelocity().set(this.getRideVelocity().get(), true);
        copy.getStamina().set(this.getStamina().get(), true);
        return copy;
    }

    public boolean shouldSync(@NotNull RidingBehaviourState previous) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        if (!Intrinsics.areEqual((Object)previous.getRideVelocity().get(), (Object)this.getRideVelocity().get())) {
            return true;
        }
        return !(((Number)previous.getStamina().get()).floatValue() == ((Number)this.getStamina().get()).floatValue());
    }

    public void encode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeVec3(this.getRideVelocity().get());
        buffer.writeFloat(((Number)this.getStamina().get()).floatValue());
    }

    public void decode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        SidedRidingState<Vec3> sidedRidingState = this.getRideVelocity();
        Vec3 vec3 = buffer.readVec3();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"readVec3(...)");
        sidedRidingState.set(vec3, true);
        this.getStamina().set(Float.valueOf(buffer.readFloat()), true);
    }
}

