/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokemon.feature;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.pokemon.aspect.AspectProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatures;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.api.properties.CustomPokemonPropertyType;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.net.messages.client.data.GlobalSpeciesFeatureSyncPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.adapters.IdentifierAdapter;
import com.cobblemon.mod.common.util.adapters.SpeciesFeatureProviderAdapter;
import com.cobblemon.mod.common.util.adapters.Vec3dAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\r\u001a\u00020\u00072\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0012J!\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0014\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u001d\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J+\u0010\u001c\u001a\u00020\u00072\u001c\u0010\u001b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u001a0\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ+\u0010!\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J#\u0010!\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0007\u00a2\u0006\u0004\b!\u0010#J/\u0010!\u001a\u00020\u0007\"\b\b\u0000\u0010$*\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0007\u00a2\u0006\u0004\b!\u0010'J#\u0010)\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u000b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u001a\u00102\u001a\u0002018\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R \u00108\u001a\b\u0012\u0004\u0012\u000207068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R$\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R$\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010>R\u001a\u0010A\u001a\u00020@8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bA\u0010B\u001a\u0004\bC\u0010DR$\u0010F\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020E8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\u000f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\u00a8\u0006N"}, d2={"Lcom/cobblemon/mod/common/api/pokemon/feature/GlobalSpeciesFeatures;", "Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeatureProvider;", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "", "Lnet/minecraft/resources/ResourceLocation;", "data", "reload", "(Ljava/util/Map;)V", "", "name", "getCodeFeature", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeatureProvider;", "getResourceFeature", "Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeature;", "getFeature", "", "getFeatures", "()Ljava/util/List;", "", "", "entries", "loadOnClient", "(Ljava/util/Collection;)V", "provider", "", "isCoded", "register", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeatureProvider;Z)V", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeatureProvider;)V", "T", "Lkotlin/Function0;", "providerLambda", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "identifier", "registerFromAssets", "(Lnet/minecraft/resources/ResourceLocation;Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeatureProvider;)V", "unregister", "(Ljava/lang/String;)V", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Lcom/cobblemon/mod/common/api/pokemon/feature/SpeciesFeatures;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "", "codeFeatures", "Ljava/util/Map;", "resourceFeatures", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "resourcePath", "Ljava/lang/String;", "getResourcePath", "()Ljava/lang/String;", "common"})
@SourceDebugExtension(value={"SMAP\nGlobalSpeciesFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalSpeciesFeatures.kt\ncom/cobblemon/mod/common/api/pokemon/feature/GlobalSpeciesFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1869#2,2:116\n1617#2,9:118\n1869#2:127\n1870#2:129\n1626#2:130\n1563#2:131\n1634#2,3:132\n1#3:128\n1#3:135\n*S KotlinDebug\n*F\n+ 1 GlobalSpeciesFeatures.kt\ncom/cobblemon/mod/common/api/pokemon/feature/GlobalSpeciesFeatures\n*L\n61#1:116,2\n73#1:118,9\n73#1:127\n73#1:129\n73#1:130\n76#1:131\n76#1:132,3\n73#1:128\n*E\n"})
public final class GlobalSpeciesFeatures
implements JsonDataRegistry<SpeciesFeatureProvider<?>> {
    @NotNull
    public static final GlobalSpeciesFeatures INSTANCE = new GlobalSpeciesFeatures();
    @NotNull
    private static final ResourceLocation id = MiscUtilsKt.cobblemonResource("global_species_features");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final SimpleObservable<SpeciesFeatures> observable = new SimpleObservable();
    @NotNull
    private static final Map<String, SpeciesFeatureProvider<?>> codeFeatures = new LinkedHashMap();
    @NotNull
    private static final Map<String, SpeciesFeatureProvider<?>> resourceFeatures = new LinkedHashMap();
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final TypeToken<SpeciesFeatureProvider<?>> typeToken;
    @NotNull
    private static final String resourcePath;

    private GlobalSpeciesFeatures() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    @NotNull
    public PackType getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<SpeciesFeatures> getObservable() {
        return observable;
    }

    @Override
    @NotNull
    public Gson getGson() {
        return gson;
    }

    @Override
    @NotNull
    public TypeToken<SpeciesFeatureProvider<?>> getTypeToken() {
        return typeToken;
    }

    @Override
    @NotNull
    public String getResourcePath() {
        return resourcePath;
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CobblemonNetwork.INSTANCE.sendPacket(player, new GlobalSpeciesFeatureSyncPacket(MapsKt.plus(codeFeatures, resourceFeatures)));
    }

    @Override
    public void reload(@NotNull Map<ResourceLocation, ? extends SpeciesFeatureProvider<?>> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)resourceFeatures.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            GlobalSpeciesFeatures.unregister(p0);
        }
        data.forEach((arg_0, arg_1) -> GlobalSpeciesFeatures.reload$lambda$0((Function2)new Function2<ResourceLocation, SpeciesFeatureProvider<?>, Unit>(this){

            public final void invoke(ResourceLocation p0, SpeciesFeatureProvider<?> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                GlobalSpeciesFeatures.access$registerFromAssets((GlobalSpeciesFeatures)this.receiver, p0, p1);
            }
        }, arg_0, arg_1));
    }

    @JvmStatic
    @Nullable
    public static final SpeciesFeatureProvider<?> getCodeFeature(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return codeFeatures.get(name);
    }

    @JvmStatic
    @Nullable
    public static final SpeciesFeatureProvider<?> getResourceFeature(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return resourceFeatures.get(name);
    }

    @JvmStatic
    @Nullable
    public static final SpeciesFeatureProvider<? extends SpeciesFeature> getFeature(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        SpeciesFeatureProvider<?> speciesFeatureProvider = GlobalSpeciesFeatures.getCodeFeature(name);
        if (speciesFeatureProvider == null) {
            speciesFeatureProvider = GlobalSpeciesFeatures.getResourceFeature(name);
        }
        return speciesFeatureProvider;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<SpeciesFeatureProvider<? extends SpeciesFeature>> getFeatures() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = SetsKt.plus(resourceFeatures.keySet(), (Iterable)codeFeatures.keySet());
        Function1 transform$iv = (Function1)new Function1<String, SpeciesFeatureProvider<? extends SpeciesFeature>>((Object)INSTANCE){

            public final SpeciesFeatureProvider<? extends SpeciesFeature> invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GlobalSpeciesFeatures.getFeature(p0);
            }
        };
        boolean $i$f$mapNotNull = false;
        void var3_3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            if (transform$iv.invoke(element$iv$iv) == null) continue;
            boolean bl2 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadOnClient(@NotNull Collection<? extends Map.Entry<String, ? extends SpeciesFeatureProvider<?>>> entries) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Iterable iterable = entries;
        Map<String, SpeciesFeatureProvider<?>> map = codeFeatures;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_12 = it;
            collection.add(new Pair(var11_12.getKey(), var11_12.getValue()));
        }
        MapsKt.putAll(map, (Iterable)((List)destination$iv$iv));
    }

    private final void register(String name, SpeciesFeatureProvider<?> provider, boolean isCoded) {
        Map<String, SpeciesFeatureProvider<?>> mapping;
        Map<String, SpeciesFeatureProvider<?>> map = mapping = isCoded ? codeFeatures : resourceFeatures;
        if (provider instanceof AspectProvider) {
            AspectProvider.Companion.register((AspectProvider)((Object)provider));
        }
        if (provider instanceof CustomPokemonPropertyType) {
            CustomPokemonProperty.Companion.register((CustomPokemonPropertyType)((Object)provider));
        }
        mapping.put(name, provider);
    }

    @JvmStatic
    public static final void register(@NotNull String name, @NotNull SpeciesFeatureProvider<?> provider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        INSTANCE.register(name, provider, true);
    }

    @JvmStatic
    public static final <T extends SpeciesFeature> void register(@NotNull String name, @NotNull Function0<? extends T> providerLambda) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(providerLambda, (String)"providerLambda");
        GlobalSpeciesFeatures.register(name, new SpeciesFeatureProvider<T>(providerLambda){
            final /* synthetic */ Function0<T> $providerLambda;
            {
                this.$providerLambda = $providerLambda;
            }

            public T invoke(Pokemon pokemon) {
                Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
                return (T)((SpeciesFeature)this.$providerLambda.invoke());
            }

            public T invoke(CompoundTag nbt) {
                Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
                Object object = this.$providerLambda.invoke();
                SpeciesFeature $this$invoke_u24lambda_u240 = (SpeciesFeature)object;
                boolean bl = false;
                $this$invoke_u24lambda_u240.loadFromNBT(nbt);
                return (T)((SpeciesFeature)object);
            }

            public T invoke(JsonObject json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Object object = this.$providerLambda.invoke();
                SpeciesFeature $this$invoke_u24lambda_u241 = (SpeciesFeature)object;
                boolean bl = false;
                $this$invoke_u24lambda_u241.loadFromJSON(json);
                return (T)((SpeciesFeature)object);
            }
        });
    }

    private final void registerFromAssets(ResourceLocation identifier2, SpeciesFeatureProvider<?> provider) {
        String string = identifier2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.register(string, provider, false);
    }

    @JvmStatic
    public static final void unregister(@NotNull String name) {
        SpeciesFeatureProvider<?> speciesFeatureProvider;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean coded = false;
        coded = true;
        SpeciesFeatureProvider<?> speciesFeatureProvider2 = GlobalSpeciesFeatures.getResourceFeature(name);
        if (speciesFeatureProvider2 != null) {
            SpeciesFeatureProvider<?> speciesFeatureProvider3;
            SpeciesFeatureProvider<?> it = speciesFeatureProvider3 = speciesFeatureProvider2;
            boolean bl = false;
            coded = false;
            speciesFeatureProvider = speciesFeatureProvider3;
        } else {
            speciesFeatureProvider = GlobalSpeciesFeatures.getCodeFeature(name);
            if (speciesFeatureProvider == null) {
                return;
            }
        }
        SpeciesFeatureProvider<?> value = speciesFeatureProvider;
        if (value instanceof AspectProvider) {
            AspectProvider.Companion.unregister((AspectProvider)((Object)value));
        }
        if (value instanceof CustomPokemonPropertyType) {
            CustomPokemonProperty.Companion.unregister((CustomPokemonPropertyType)((Object)value));
        }
        Map<String, SpeciesFeatureProvider<?>> mapping = coded ? codeFeatures : resourceFeatures;
        mapping.remove(name);
    }

    private static final void reload$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$registerFromAssets(GlobalSpeciesFeatures $this, ResourceLocation identifier2, SpeciesFeatureProvider provider) {
        $this.registerFromAssets(identifier2, provider);
    }

    static {
        Gson gson2 = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)SpeciesFeatureProvider.class), (Object)SpeciesFeatureProviderAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Vec3.class), (Object)Vec3dAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ResourceLocation.class), (Object)IdentifierAdapter.INSTANCE).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"create(...)");
        gson = gson2;
        TypeToken typeToken = TypeToken.get(SpeciesFeatureProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"get(...)");
        GlobalSpeciesFeatures.typeToken = typeToken;
        resourcePath = "global_species_features";
    }
}

