/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokeball.catching.calculators;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokeball.catching.calculators.CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.CobblemonCaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.DebugCaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen1CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen2CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen3And4CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen5CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen6CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen7CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen8CaptureCalculator;
import com.cobblemon.mod.common.pokeball.catching.calculators.Gen9CaptureCalculator;
import java.util.LinkedHashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\r\u0010\u0003R0\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u000fj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0004`\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculators;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;", "calculator", "", "register", "(Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;)V", "", "id", "fromId", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/CaptureCalculator;", "registerDefaults$common", "registerDefaults", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "calculators", "Ljava/util/LinkedHashMap;", "common"})
public final class CaptureCalculators {
    @NotNull
    public static final CaptureCalculators INSTANCE = new CaptureCalculators();
    @NotNull
    private static final LinkedHashMap<String, CaptureCalculator> calculators = new LinkedHashMap();

    private CaptureCalculators() {
    }

    public final void register(@NotNull CaptureCalculator calculator) {
        Intrinsics.checkNotNullParameter((Object)calculator, (String)"calculator");
        String string = calculator.id().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String id = string;
        CaptureCalculator existing = calculators.put(id, calculator);
        if (existing != null) {
            Cobblemon.LOGGER.debug("The capture calculator {} with ID {} was replaced by {}", (Object)Reflection.getOrCreateKotlinClass(existing.getClass()).getQualifiedName(), (Object)id, (Object)Reflection.getOrCreateKotlinClass(calculator.getClass()).getQualifiedName());
        }
    }

    @Nullable
    public final CaptureCalculator fromId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = id.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return calculators.get(string);
    }

    public final void registerDefaults$common() {
        this.register(Gen1CaptureCalculator.INSTANCE);
        this.register(new Gen2CaptureCalculator(false));
        this.register(new Gen2CaptureCalculator(true));
        this.register(Gen3And4CaptureCalculator.INSTANCE);
        this.register(Gen5CaptureCalculator.INSTANCE);
        this.register(Gen6CaptureCalculator.INSTANCE);
        this.register(Gen7CaptureCalculator.INSTANCE);
        this.register(Gen8CaptureCalculator.INSTANCE);
        this.register(Gen9CaptureCalculator.INSTANCE);
        this.register(CobblemonCaptureCalculator.INSTANCE);
        this.register(DebugCaptureCalculator.INSTANCE);
    }
}

