/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.item;

import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.ItemStackExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J%\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH&\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J-\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0019\u0010\bJ-\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010!\u001a\u0004\u0018\u00010\u001e8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\"\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "applyToBattlePokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)V", "", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "canUseOnBattlePokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)Z", "interactWithSpecificBattle", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;)Lnet/minecraft/world/InteractionResultHolder;", "interactGeneral", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "actor", "interactGeneralBattle", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "()Lcom/cobblemon/mod/common/item/battle/BagItem;", "bagItem", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonSelectingItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonSelectingItem.kt\ncom/cobblemon/mod/common/api/item/PokemonSelectingItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n774#2:162\n865#2,2:163\n2423#2,14:165\n1#3:179\n*S KotlinDebug\n*F\n+ 1 PokemonSelectingItem.kt\ncom/cobblemon/mod/common/api/item/PokemonSelectingItem\n*L\n45#1:162\n45#1:163,2\n46#1:165,14\n*E\n"})
public interface PokemonSelectingItem {
    /*
     * WARNING - void declaration
     */
    @NotNull
    default public InteractionResultHolder<ItemStack> use(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        Object e$iv;
        Object v2;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        double range = player.entityInteractionRange();
        List list = player.level().getEntities((Entity)player, AABB.ofSize((Vec3)player.position(), (double)range, (double)range, (double)range));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var9_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            Entity entity = (Entity)player;
            Intrinsics.checkNotNull((Object)it);
            if (!PlayerExtensionsKt.isLookingAt$default(entity, it, 0.0f, 0.1f, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                Entity it = (Entity)minElem$iv;
                boolean bl = false;
                float minValue$iv = it.distanceTo((Entity)player);
                do {
                    e$iv = iterator$iv.next();
                    Entity it2 = (Entity)e$iv;
                    $i$a$-minByOrNull-PokemonSelectingItem$use$entity$2 = false;
                    float v$iv = it2.distanceTo((Entity)player);
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        Object var6_27 = v2;
        PokemonEntity entity = var6_27 instanceof PokemonEntity ? (PokemonEntity)var6_27 : null;
        Pair<PokemonBattle, BattleActor> pair = PlayerExtensionsKt.getBattleState(player);
        if (pair != null) {
            Object v6;
            BattleActor actor;
            block20: {
                iterator$iv = pair;
                boolean bl = false;
                actor = (BattleActor)iterator$iv.component2();
                if (this.getBagItem() == null) {
                    InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                    return interactionResultHolder;
                }
                e$iv = actor.getPokemonList();
                Iterator iterator = e$iv.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    BattlePokemon it = (BattlePokemon)t;
                    boolean bl2 = false;
                    PokemonEntity pokemonEntity = entity;
                    if (!Intrinsics.areEqual((Object)it.getEffectedPokemon(), (Object)(pokemonEntity != null ? pokemonEntity.getPokemon() : null))) continue;
                    v6 = t;
                    break block20;
                }
                v6 = null;
            }
            BattlePokemon battlePokemon = v6;
            if (!actor.canFitForcedAction()) {
                MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("bagitem.cannot", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
                player.sendSystemMessage((Component)TextKt.red(mutableComponent));
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            if (entity == null) {
                return this.interactGeneralBattle(player, stack, actor);
            }
            if (battlePokemon != null) {
                return this.interactWithSpecificBattle(player, stack, battlePokemon);
            }
        } else {
            PokemonSelectingItem $this$use_u24lambda_u243 = this;
            boolean bl = false;
            if (!player.isShiftKeyDown()) {
                InteractionResultHolder<ItemStack> interactionResultHolder;
                if (entity != null) {
                    Pokemon pokemon = entity.getPokemon();
                    if (Intrinsics.areEqual((Object)entity.getOwnerUUID(), (Object)player.getUUID())) {
                        InteractionResultHolder<ItemStack> typedInteractionResult = $this$use_u24lambda_u243.applyToPokemon(player, stack, pokemon);
                        if (typedInteractionResult != null) {
                            ResourceLocation resourceLocation = pokemon.getSpecies().getResourceIdentifier();
                            ResourceLocation resourceLocation2 = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"getKey(...)");
                            CobblemonCriteria.POKEMON_INTERACT.trigger(player, new PokemonInteractContext(resourceLocation, resourceLocation2));
                            interactionResultHolder = typedInteractionResult;
                        } else {
                            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.pass((Object)stack);
                            Intrinsics.checkNotNull((Object)interactionResultHolder2);
                            interactionResultHolder = interactionResultHolder2;
                        }
                    } else {
                        InteractionResultHolder<ItemStack> interactionResultHolder3 = InteractionResultHolder.fail((Object)stack);
                        Intrinsics.checkNotNull((Object)interactionResultHolder3);
                        interactionResultHolder = interactionResultHolder3;
                    }
                } else {
                    interactionResultHolder = $this$use_u24lambda_u243.interactGeneral(player, stack);
                }
                return interactionResultHolder;
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    @Nullable
    public BagItem getBagItem();

    @Nullable
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer var1, @NotNull ItemStack var2, @NotNull Pokemon var3);

    default public void applyToBattlePokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
        PokemonBattle battle = battlePokemon.getActor().getBattle();
        BagItem bagItem2 = this.getBagItem();
        if (!battlePokemon.getActor().canFitForcedAction()) {
            MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("bagitem.cannot", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
            player.sendSystemMessage((Component)TextKt.red(mutableComponent));
        } else {
            BagItem bagItem3 = bagItem2;
            Intrinsics.checkNotNull((Object)bagItem3);
            if (!bagItem3.canUse(stack, battle, battlePokemon)) {
                MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("bagitem.invalid", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
                player.sendSystemMessage((Component)TextKt.red(mutableComponent));
            } else {
                battlePokemon.getActor().forceChoose(new BagItemActionResponse(bagItem2, battlePokemon, null, 4, null));
                ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
                ResourceLocation stackName = resourceLocation;
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                    battlePokemon.getActor().getItemsUsed().add(bagItem2);
                }
                CobblemonCriteria.POKEMON_INTERACT.trigger(player, new PokemonInteractContext(battlePokemon.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
            }
        }
    }

    default public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (stack.is(CobblemonItemTags.POKE_FOOD)) {
            return !pokemon.isFull();
        }
        return true;
    }

    default public boolean canUseOnBattlePokemon(@NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
        BagItem bagItem2 = this.getBagItem();
        Intrinsics.checkNotNull((Object)bagItem2);
        return bagItem2.canUse(stack, battlePokemon.getActor().getBattle(), battlePokemon);
    }

    @NotNull
    default public InteractionResultHolder<ItemStack> interactWithSpecificBattle(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
        InteractionResultHolder interactionResultHolder;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
        if (this.canUseOnBattlePokemon(stack, battlePokemon)) {
            this.applyToBattlePokemon(player, stack, battlePokemon);
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.success((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder2);
            interactionResultHolder = interactionResultHolder2;
        } else {
            MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("bagitem.invalid", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
            player.sendSystemMessage((Component)TextKt.red(mutableComponent));
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder3);
            interactionResultHolder = interactionResultHolder3;
        }
        return interactionResultHolder;
    }

    @NotNull
    default public InteractionResultHolder<ItemStack> interactGeneral(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        List party = CollectionsKt.toList((Iterable)PlayerExtensionsKt.party(player));
        if (party.isEmpty()) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        PartySelectCallbacks.createFromPokemon$default(PartySelectCallbacks.INSTANCE, player, null, party, arg_0 -> PokemonSelectingItem.interactGeneral$lambda$0(this, stack, arg_0), null, arg_0 -> PokemonSelectingItem.interactGeneral$lambda$1(stack, player, this, arg_0), 18, null);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    @NotNull
    default public InteractionResultHolder<ItemStack> interactGeneralBattle(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattleActor actor) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        PartySelectCallbacks.createBattleSelect$default(PartySelectCallbacks.INSTANCE, player, null, actor.getPokemonList(), arg_0 -> PokemonSelectingItem.interactGeneralBattle$lambda$0(this, stack, actor, arg_0), null, arg_0 -> PokemonSelectingItem.interactGeneralBattle$lambda$1(this, player, stack, actor, arg_0), 18, null);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    private static boolean interactGeneral$lambda$0(PokemonSelectingItem this$0, ItemStack $stack, Pokemon pk) {
        Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
        return this$0.canUseOnPokemon($stack, pk);
    }

    private static Unit interactGeneral$lambda$1(ItemStack $stack, ServerPlayer $player, PokemonSelectingItem this$0, Pokemon pk) {
        Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
        if (ItemStackExtensionsKt.isHeld($stack, $player)) {
            this$0.applyToPokemon($player, $stack, pk);
            ResourceLocation resourceLocation = pk.getSpecies().getResourceIdentifier();
            ResourceLocation resourceLocation2 = BuiltInRegistries.ITEM.getKey((Object)$stack.getItem());
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"getKey(...)");
            CobblemonCriteria.POKEMON_INTERACT.trigger($player, new PokemonInteractContext(resourceLocation, resourceLocation2));
        }
        return Unit.INSTANCE;
    }

    private static boolean interactGeneralBattle$lambda$0(PokemonSelectingItem this$0, ItemStack $stack, BattleActor $actor, BattlePokemon pk) {
        Object var12_12;
        Object v0;
        PokemonSelectingItem pokemonSelectingItem;
        ItemStack itemStack;
        block1: {
            Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
            Iterable iterable = $actor.getPokemonList();
            itemStack = $stack;
            pokemonSelectingItem = this$0;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                BattlePokemon it = (BattlePokemon)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffectedPokemon(), (Object)pk.getEffectedPokemon())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object v1 = var12_12 = v0;
        Intrinsics.checkNotNull(v1);
        return pokemonSelectingItem.canUseOnBattlePokemon(itemStack, v1);
    }

    private static Unit interactGeneralBattle$lambda$1(PokemonSelectingItem this$0, ServerPlayer $player, ItemStack $stack, BattleActor $actor, BattlePokemon pk) {
        Object var14_14;
        Object v0;
        PokemonSelectingItem pokemonSelectingItem;
        ServerPlayer serverPlayer;
        ItemStack itemStack;
        block1: {
            Intrinsics.checkNotNullParameter((Object)pk, (String)"pk");
            Iterable iterable = $actor.getPokemonList();
            itemStack = $stack;
            serverPlayer = $player;
            pokemonSelectingItem = this$0;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                BattlePokemon it = (BattlePokemon)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffectedPokemon(), (Object)pk.getEffectedPokemon())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object v1 = var14_14 = v0;
        Intrinsics.checkNotNull(v1);
        pokemonSelectingItem.applyToBattlePokemon(serverPlayer, itemStack, v1);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static InteractionResultHolder<ItemStack> use(@NotNull PokemonSelectingItem $this, @NotNull ServerPlayer player, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return $this.use(player, stack);
        }

        @Deprecated
        public static void applyToBattlePokemon(@NotNull PokemonSelectingItem $this, @NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            $this.applyToBattlePokemon(player, stack, battlePokemon);
        }

        @Deprecated
        public static boolean canUseOnPokemon(@NotNull PokemonSelectingItem $this, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return $this.canUseOnPokemon(stack, pokemon);
        }

        @Deprecated
        public static boolean canUseOnBattlePokemon(@NotNull PokemonSelectingItem $this, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            return $this.canUseOnBattlePokemon(stack, battlePokemon);
        }

        @Deprecated
        @NotNull
        public static InteractionResultHolder<ItemStack> interactWithSpecificBattle(@NotNull PokemonSelectingItem $this, @NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattlePokemon battlePokemon) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            return $this.interactWithSpecificBattle(player, stack, battlePokemon);
        }

        @Deprecated
        @NotNull
        public static InteractionResultHolder<ItemStack> interactGeneral(@NotNull PokemonSelectingItem $this, @NotNull ServerPlayer player, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return $this.interactGeneral(player, stack);
        }

        @Deprecated
        @NotNull
        public static InteractionResultHolder<ItemStack> interactGeneralBattle(@NotNull PokemonSelectingItem $this, @NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BattleActor actor) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
            return $this.interactGeneralBattle(player, stack, actor);
        }
    }
}

