/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.interaction;

import com.cobblemon.mod.common.api.interaction.InteractionEffect;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.sound.UnvalidatedPlaySoundS2CPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\u0018\u0000 &2\u00020\u0001:\u0001&BA\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\f\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\"\u001a\u0004\b%\u0010$\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/api/interaction/PlaySoundEffect;", "Lcom/cobblemon/mod/common/api/interaction/InteractionEffect;", "Lnet/minecraft/resources/ResourceLocation;", "sound", "Lnet/minecraft/sounds/SoundSource;", "soundSource", "", "playAround", "", "distance", "", "volume", "pitch", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/sounds/SoundSource;ZDFF)V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemon", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "applyEffect", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/minecraft/resources/ResourceLocation;", "getSound", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/sounds/SoundSource;", "getSoundSource", "()Lnet/minecraft/sounds/SoundSource;", "Z", "getPlayAround", "()Z", "D", "getDistance", "()D", "F", "getVolume", "()F", "getPitch", "Companion", "common"})
public final class PlaySoundEffect
implements InteractionEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation sound;
    @Nullable
    private final SoundSource soundSource;
    private final boolean playAround;
    private final double distance;
    private final float volume;
    private final float pitch;
    @NotNull
    private static final String ID = "play_sound";

    public PlaySoundEffect(@NotNull ResourceLocation sound, @Nullable SoundSource soundSource, boolean playAround, double distance, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.sound = sound;
        this.soundSource = soundSource;
        this.playAround = playAround;
        this.distance = distance;
        this.volume = volume;
        this.pitch = pitch;
    }

    public /* synthetic */ PlaySoundEffect(ResourceLocation resourceLocation, SoundSource soundSource, boolean bl, double d, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            d = 64.0;
        }
        if ((n & 0x10) != 0) {
            f = 1.0f;
        }
        if ((n & 0x20) != 0) {
            f2 = 1.0f;
        }
        this(resourceLocation, soundSource, bl, d, f, f2);
    }

    @NotNull
    public final ResourceLocation getSound() {
        return this.sound;
    }

    @Nullable
    public final SoundSource getSoundSource() {
        return this.soundSource;
    }

    public final boolean getPlayAround() {
        return this.playAround;
    }

    public final double getDistance() {
        return this.distance;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final float getPitch() {
        return this.pitch;
    }

    @Override
    public void applyEffect(@NotNull PokemonEntity pokemon, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        SoundSource soundSource = this.soundSource;
        if (soundSource == null) {
            soundSource = SoundSource.NEUTRAL;
        }
        UnvalidatedPlaySoundS2CPacket packet = new UnvalidatedPlaySoundS2CPacket(this.sound, soundSource, pokemon.getX(), pokemon.getY(), pokemon.getZ(), this.volume, this.pitch);
        if (this.playAround) {
            NetworkPacket networkPacket = packet;
            double d = pokemon.getX();
            double d2 = pokemon.getY();
            double d3 = pokemon.getZ();
            ResourceKey resourceKey = pokemon.level().dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, this.distance, resourceKey, null, 32, null);
        } else {
            packet.sendToPlayer(player);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/interaction/PlaySoundEffect$Companion;", "", "<init>", "()V", "", "ID", "Ljava/lang/String;", "getID", "()Ljava/lang/String;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

