/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.fossil;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.fossil.Fossil;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.net.messages.client.data.FossilRegistrySyncPacket;
import com.cobblemon.mod.common.pokemon.evolution.adapters.LegacyItemConditionWrapperAdapter;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.adapters.IdentifierAdapter;
import com.cobblemon.mod.common.util.adapters.ItemLikeConditionAdapter;
import com.cobblemon.mod.common.util.adapters.PokemonPropertiesAdapterKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\t\u001a\u00020\b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00100\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010$\u001a\u00020#8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R \u0010)\u001a\b\u0012\u0004\u0012\u00020\u00000(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\"\u0010/\u001a\n .*\u0004\u0018\u00010-0-8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R \u00104\u001a\b\u0012\u0004\u0012\u00020\u0002038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u001a\u00109\u001a\u0002088\u0016X\u0096D\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R0\u0010?\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020=j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002`>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lcom/cobblemon/mod/common/api/fossil/Fossils;", "Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "Lcom/cobblemon/mod/common/api/fossil/Fossil;", "<init>", "()V", "", "Lnet/minecraft/resources/ResourceLocation;", "data", "", "reload", "(Ljava/util/Map;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "", "Lkotlin/jvm/internal/EnhancedNullability;", "all", "()Ljava/util/List;", "identifier", "getByIdentifier", "(Lnet/minecraft/resources/ResourceLocation;)Lcom/cobblemon/mod/common/api/fossil/Fossil;", "Lnet/minecraft/world/item/ItemStack;", "fossilStacks", "getFossilByItemStacks", "(Ljava/util/List;)Lcom/cobblemon/mod/common/api/fossil/Fossil;", "getSubFossilByItemStacks", "itemStack", "", "isFossilIngredient", "(Lnet/minecraft/world/item/ItemStack;)Z", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "", "resourcePath", "Ljava/lang/String;", "getResourcePath", "()Ljava/lang/String;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "fossils", "Ljava/util/HashMap;", "common"})
@SourceDebugExtension(value={"SMAP\nFossils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fossils.kt\ncom/cobblemon/mod/common/api/fossil/Fossils\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n216#2,2:113\n295#3,2:115\n295#3,2:117\n1761#3,3:119\n*S KotlinDebug\n*F\n+ 1 Fossils.kt\ncom/cobblemon/mod/common/api/fossil/Fossils\n*L\n53#1:113,2\n90#1:115,2\n100#1:117,2\n109#1:119,3\n*E\n"})
public final class Fossils
implements JsonDataRegistry<Fossil> {
    @NotNull
    public static final Fossils INSTANCE = new Fossils();
    @NotNull
    private static final ResourceLocation id = MiscUtilsKt.cobblemonResource("fossils");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final SimpleObservable<Fossils> observable = new SimpleObservable();
    private static final Gson gson;
    @NotNull
    private static final TypeToken<Fossil> typeToken;
    @NotNull
    private static final String resourcePath;
    @NotNull
    private static final HashMap<ResourceLocation, Fossil> fossils;

    private Fossils() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    @NotNull
    public PackType getType() {
        return type;
    }

    @NotNull
    public SimpleObservable<Fossils> getObservable() {
        return observable;
    }

    @Override
    public Gson getGson() {
        return gson;
    }

    @Override
    @NotNull
    public TypeToken<Fossil> getTypeToken() {
        return typeToken;
    }

    @Override
    @NotNull
    public String getResourcePath() {
        return resourcePath;
    }

    @Override
    public void reload(@NotNull Map<ResourceLocation, Fossil> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        fossils.clear();
        Map<ResourceLocation, Fossil> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, Fossil>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, Fossil> element$iv;
            Map.Entry<ResourceLocation, Fossil> entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation identifier2 = entry.getKey();
            Fossil fossil = entry.getValue();
            try {
                fossil.setIdentifier$common(identifier2);
                ((Map)fossils).put(identifier2, fossil);
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Skipped loading the {} fossil", (Object)identifier2, (Object)e);
            }
        }
        Cobblemon.LOGGER.info("Loaded {} fossils", (Object)fossils.size());
        Fossils[] fossilsArray = new Fossils[]{this};
        this.getObservable().emit((Fossils[])fossilsArray);
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        new FossilRegistrySyncPacket(Fossils.all()).sendToPlayer(player);
    }

    @JvmStatic
    @NotNull
    public static final List<Fossil> all() {
        Collection<Fossil> collection = fossils.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @JvmStatic
    @Nullable
    public static final Fossil getByIdentifier(@NotNull ResourceLocation identifier2) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        return fossils.get(identifier2);
    }

    @JvmStatic
    @Nullable
    public static final Fossil getFossilByItemStacks(@NotNull List<ItemStack> fossilStacks) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(fossilStacks, (String)"fossilStacks");
            Iterable $this$firstOrNull$iv = Fossils.all();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Fossil it = (Fossil)element$iv;
                boolean bl = false;
                if (!it.matchesIngredients(fossilStacks)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    @Nullable
    public static final Fossil getSubFossilByItemStacks(@NotNull List<ItemStack> fossilStacks) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(fossilStacks, (String)"fossilStacks");
            Iterable $this$firstOrNull$iv = Fossils.all();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Fossil it = (Fossil)element$iv;
                boolean bl = false;
                if (!it.matchesIngredientsSubSet(fossilStacks)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final boolean isFossilIngredient(@NotNull ItemStack itemStack) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Iterable $this$any$iv = Fossils.all();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Fossil it = (Fossil)element$iv;
                    boolean bl2 = false;
                    if (!it.isIngredient(itemStack)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Type[] typeArray = new Type[]{Item.class};
        gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter((Type)((Object)ResourceLocation.class), (Object)IdentifierAdapter.INSTANCE).registerTypeAdapter((Type)((Object)PokemonProperties.class), (Object)PokemonPropertiesAdapterKt.getPokemonPropertiesShortAdapter()).registerTypeAdapter(TypeToken.getParameterized((Type)((Type)((Object)RegistryLikeCondition.class)), (Type[])typeArray).getType(), (Object)ItemLikeConditionAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ItemPredicate.class), (Object)LegacyItemConditionWrapperAdapter.INSTANCE).create();
        TypeToken typeToken = TypeToken.get(Fossil.class);
        Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"get(...)");
        Fossils.typeToken = typeToken;
        resourcePath = "fossils";
        fossils = new HashMap();
    }
}

