/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.cooking;

import com.cobblemon.mod.common.api.cooking.Flavour;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0004\u001a'\u0010\u0006\u001a\u0004\u0018\u00010\u00052\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a'\u0010\n\u001a\u0004\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u0007\u001a'\u0010\u000e\u001a\u0004\u0018\u00010\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\" \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\" \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"", "Lnet/minecraft/world/item/ItemStack;", "seasonings", "", "forBubbles", "", "getColourMixFromSeasonings", "(Ljava/util/List;Z)Ljava/lang/Integer;", "Lcom/cobblemon/mod/common/api/cooking/Flavour;", "dominantFlavours", "getColourMixFromFlavours", "", "Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;", "dominantBoosts", "getColourMixFromRideStatBoosts", "(Ljava/lang/Iterable;Z)Ljava/lang/Integer;", "colors", "getColourMixFromColors", "(Ljava/util/List;)Ljava/lang/Integer;", "", "colourMap", "Ljava/util/Map;", "bubbleColourMap", "common"})
@SourceDebugExtension(value={"SMAP\nFlavourColourHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlavourColourHelper.kt\ncom/cobblemon/mod/common/api/cooking/FlavourColourHelperKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n536#2:93\n521#2,6:94\n126#3:100\n153#3,3:101\n1617#4,9:104\n1869#4:113\n1870#4:115\n1626#4:116\n1563#4:117\n1634#4,3:118\n1563#4:121\n1634#4,3:122\n1#5:114\n*S KotlinDebug\n*F\n+ 1 FlavourColourHelper.kt\ncom/cobblemon/mod/common/api/cooking/FlavourColourHelperKt\n*L\n45#1:93\n45#1:94,6\n45#1:100\n45#1:101,3\n53#1:104,9\n53#1:113\n53#1:115\n53#1:116\n54#1:117\n54#1:118,3\n60#1:121\n60#1:122,3\n53#1:114\n*E\n"})
public final class FlavourColourHelperKt {
    @NotNull
    private static final Map<Flavour, Integer> colourMap;
    @NotNull
    private static final Map<Flavour, Integer> bubbleColourMap;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer getColourMixFromSeasonings(@NotNull List<ItemStack> seasonings, boolean forBubbles) {
        void $this$map$iv;
        boolean bl;
        Map.Entry it;
        Iterator<Map.Entry<Flavour, Integer>> iterator;
        Intrinsics.checkNotNullParameter(seasonings, (String)"seasonings");
        Map flavourValues = new LinkedHashMap();
        for (ItemStack seasoning : seasonings) {
            Map<Flavour, Integer> flavours;
            if (Seasonings.INSTANCE.getFlavoursFromItemStack(seasoning) == null) continue;
            for (Map.Entry<Flavour, Integer> object2 : flavours.entrySet()) {
                Flavour flavour = object2.getKey();
                int value = ((Number)object2.getValue()).intValue();
                iterator = flavourValues;
                Integer n = (Integer)flavourValues.get((Object)flavour);
                Integer n2 = (n != null ? n : 0) + value;
                iterator.put(flavour, n2);
            }
        }
        if (flavourValues.isEmpty()) {
            return null;
        }
        Integer maxFlavorValue = (Integer)CollectionsKt.maxOrNull((Iterable)flavourValues.values());
        Map $this$filter$iv = flavourValues;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            bl = false;
            Integer n = maxFlavorValue;
            if (!(n != null && ((Number)it.getValue()).intValue() == n.intValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : var7_10.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            bl = false;
            object.add((Flavour)((Object)it.getKey()));
        }
        List dominantFlavours = (List)destination$iv$iv;
        return FlavourColourHelperKt.getColourMixFromFlavours(dominantFlavours, forBubbles);
    }

    public static /* synthetic */ Integer getColourMixFromSeasonings$default(List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FlavourColourHelperKt.getColourMixFromSeasonings(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer getColourMixFromFlavours(@NotNull List<? extends Flavour> dominantFlavours, boolean forBubbles) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(dominantFlavours, (String)"dominantFlavours");
        Iterable $this$mapNotNull$iv = dominantFlavours;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Flavour it = (Flavour)((Object)element$iv$iv);
            boolean bl2 = false;
            if ((forBubbles ? bubbleColourMap.get((Object)it) : colourMap.get((Object)it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FastColor.ARGB32.opaque((int)it));
        }
        List colors = (List)destination$iv$iv;
        return FlavourColourHelperKt.getColourMixFromColors(colors);
    }

    public static /* synthetic */ Integer getColourMixFromFlavours$default(List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FlavourColourHelperKt.getColourMixFromFlavours(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer getColourMixFromRideStatBoosts(@NotNull Iterable<? extends RidingStat> dominantBoosts, boolean forBubbles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dominantBoosts, (String)"dominantBoosts");
        Iterable<? extends RidingStat> $this$map$iv = dominantBoosts;
        boolean $i$f$map = false;
        Iterable<? extends RidingStat> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RidingStat ridingStat = (RidingStat)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFlavour());
        }
        return FlavourColourHelperKt.getColourMixFromFlavours((List)destination$iv$iv, forBubbles);
    }

    public static /* synthetic */ Integer getColourMixFromRideStatBoosts$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FlavourColourHelperKt.getColourMixFromRideStatBoosts(iterable, bl);
    }

    @Nullable
    public static final Integer getColourMixFromColors(@NotNull List<Integer> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        if (colors.isEmpty()) {
            return null;
        }
        if (colors.size() == 1) {
            return colors.get(0);
        }
        float firstWeight = 0.7f;
        float otherWeightTotal = 1.0f - firstWeight;
        float otherWeight = otherWeightTotal / (float)(colors.size() - 1);
        float alphaSum = 0.0f;
        float redSum = 0.0f;
        float greenSum = 0.0f;
        float blueSum = 0.0f;
        int n = ((Collection)colors).size();
        for (int i = 0; i < n; ++i) {
            float weight = i == 0 ? firstWeight : otherWeight;
            int color = ((Number)colors.get(i)).intValue();
            alphaSum += (float)FastColor.ARGB32.alpha((int)color) * weight;
            redSum += (float)FastColor.ARGB32.red((int)color) * weight;
            greenSum += (float)FastColor.ARGB32.green((int)color) * weight;
            blueSum += (float)FastColor.ARGB32.blue((int)color) * weight;
        }
        return FastColor.ARGB32.color((int)((int)alphaSum), (int)((int)redSum), (int)((int)greenSum), (int)((int)blueSum));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)Flavour.SPICY), (Object)16692093), TuplesKt.to((Object)((Object)Flavour.DRY), (Object)9103868), TuplesKt.to((Object)((Object)Flavour.SWEET), (Object)16760557), TuplesKt.to((Object)((Object)Flavour.BITTER), (Object)10415503), TuplesKt.to((Object)((Object)Flavour.SOUR), (Object)16577418)};
        colourMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)Flavour.SPICY), (Object)16767405), TuplesKt.to((Object)((Object)Flavour.DRY), (Object)12384510), TuplesKt.to((Object)((Object)Flavour.SWEET), (Object)16704505), TuplesKt.to((Object)((Object)Flavour.BITTER), (Object)13170620), TuplesKt.to((Object)((Object)Flavour.SOUR), (Object)16644792)};
        bubbleColourMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

