/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.ai.config.task;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.WrapperLivingEntityTask;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.util.Either;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR2\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R2\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R2\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/WalkAwayFromAvoidTargetTaskConfig;", "Lcom/cobblemon/mod/common/api/ai/config/task/SingleTaskConfig;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;", "behaviourConfigurationContext", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "getVariables", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Ljava/util/List;", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "createTask", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "Lcom/mojang/datafixers/util/Either;", "Lcom/bedrockk/molang/Expression;", "Lcom/cobblemon/mod/common/api/ai/ExpressionOrEntityVariable;", "condition", "Lcom/mojang/datafixers/util/Either;", "getCondition", "()Lcom/mojang/datafixers/util/Either;", "setCondition", "(Lcom/mojang/datafixers/util/Either;)V", "speedMultiplier", "getSpeedMultiplier", "setSpeedMultiplier", "desiredDistance", "getDesiredDistance", "setDesiredDistance", "common"})
public final class WalkAwayFromAvoidTargetTaskConfig
implements SingleTaskConfig {
    @NotNull
    private Either<Expression, MoLangConfigVariable> condition;
    @NotNull
    private Either<Expression, MoLangConfigVariable> speedMultiplier;
    @NotNull
    private Either<Expression, MoLangConfigVariable> desiredDistance;

    public WalkAwayFromAvoidTargetTaskConfig() {
        Either either = Either.left((Object)MoLangExtensionsKt.asExpression("true"));
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"left(...)");
        this.condition = either;
        this.speedMultiplier = this.numberVariable("fear", "flee_speed_multiplier", 0.7).asExpressible();
        this.desiredDistance = this.numberVariable("fear", "flee_desired_distance", 9).asExpressible();
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getCondition() {
        return this.condition;
    }

    public final void setCondition(@NotNull Either<Expression, MoLangConfigVariable> either) {
        Intrinsics.checkNotNullParameter(either, (String)"<set-?>");
        this.condition = either;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public final void setSpeedMultiplier(@NotNull Either<Expression, MoLangConfigVariable> either) {
        Intrinsics.checkNotNullParameter(either, (String)"<set-?>");
        this.speedMultiplier = either;
    }

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getDesiredDistance() {
        return this.desiredDistance;
    }

    public final void setDesiredDistance(@NotNull Either<Expression, MoLangConfigVariable> either) {
        Intrinsics.checkNotNullParameter(either, (String)"<set-?>");
        this.desiredDistance = either;
    }

    @Override
    @NotNull
    public List<MoLangConfigVariable> getVariables(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        Object[] objectArray = new Either[]{this.condition, this.speedMultiplier, this.desiredDistance};
        return ExpressionOrEntityVariableKt.asVariables(CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @Nullable
    public BehaviorControl<? super LivingEntity> createTask(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        if (!this.resolveBoolean(this.condition, behaviourConfigurationContext.getRuntime()) || !(entity instanceof PathfinderMob)) {
            return null;
        }
        MemoryModuleType[] memoryModuleTypeArray = new MemoryModuleType[2];
        Intrinsics.checkNotNullExpressionValue((Object)MemoryModuleType.HURT_BY_ENTITY, (String)"HURT_BY_ENTITY");
        Intrinsics.checkNotNullExpressionValue((Object)MemoryModuleType.WALK_TARGET, (String)"WALK_TARGET");
        behaviourConfigurationContext.addMemories(memoryModuleTypeArray);
        memoryModuleTypeArray = new SensorType[1];
        Intrinsics.checkNotNullExpressionValue((Object)SensorType.HURT_BY, (String)"HURT_BY");
        behaviourConfigurationContext.addSensors((SensorType<?>[])memoryModuleTypeArray);
        float speedMultiplier = this.resolveFloat(this.speedMultiplier, behaviourConfigurationContext.getRuntime());
        int desiredDistance = this.resolveInt(this.desiredDistance, behaviourConfigurationContext.getRuntime());
        OneShot oneShot = SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (float)speedMultiplier, (int)desiredDistance, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)oneShot, (String)"entity(...)");
        return new WrapperLivingEntityTask<PathfinderMob>((BehaviorControl)oneShot, PathfinderMob.class);
    }
}

