/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.ai.config.task;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonActivities;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.block.SaccharineLeafBlock;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR'\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/PlaceHoneyInSaccLeavesTaskConfig;", "Lcom/cobblemon/mod/common/api/ai/config/task/SingleTaskConfig;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;", "behaviourConfigurationContext", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "getVariables", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Ljava/util/List;", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "createTask", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "Lcom/mojang/datafixers/util/Either;", "Lcom/bedrockk/molang/Expression;", "Lcom/cobblemon/mod/common/api/ai/ExpressionOrEntityVariable;", "condition", "Lcom/mojang/datafixers/util/Either;", "getCondition", "()Lcom/mojang/datafixers/util/Either;", "Companion", "common"})
public final class PlaceHoneyInSaccLeavesTaskConfig
implements SingleTaskConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Either<Expression, MoLangConfigVariable> condition = this.booleanVariable("pollinate", "can_pollinate", true).asExpressible();
    @NotNull
    public static final String POLLINATE = "pollinate";
    public static final int MIN_DURATION = 300;
    public static final int MAX_DURATION = 400;
    public static final int REQUIRED_SUCCESSFUL_POLLINATION_TICKS = 250;

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getCondition() {
        return this.condition;
    }

    @Override
    @NotNull
    public List<MoLangConfigVariable> getVariables(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        return ExpressionOrEntityVariableKt.asVariables(CollectionsKt.listOf(this.condition));
    }

    @Override
    @Nullable
    public BehaviorControl<? super LivingEntity> createTask(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        if (!(entity instanceof PokemonEntity)) {
            return null;
        }
        if (!this.checkCondition(behaviourConfigurationContext.getRuntime(), this.condition)) {
            return null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to(CobblemonMemories.NEARBY_SACC_LEAVES, (Object)MemoryStatus.VALUE_PRESENT), TuplesKt.to((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), TuplesKt.to(CobblemonMemories.HAS_NECTAR, (Object)MemoryStatus.VALUE_PRESENT)};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        return (BehaviorControl)new Behavior<LivingEntity>(entity, map){
            private int successfulPollinationTicks;
            private int lastSoundPlayedTick;
            private Vec3 hoverPos;
            final /* synthetic */ LivingEntity $entity;
            {
                this.$entity = $entity;
                super($super_call_param$1, 300, 400);
            }

            public final int getSuccessfulPollinationTicks() {
                return this.successfulPollinationTicks;
            }

            public final void setSuccessfulPollinationTicks(int n) {
                this.successfulPollinationTicks = n;
            }

            public final int getLastSoundPlayedTick() {
                return this.lastSoundPlayedTick;
            }

            public final void setLastSoundPlayedTick(int n) {
                this.lastSoundPlayedTick = n;
            }

            public final Vec3 getHoverPos() {
                return this.hoverPos;
            }

            public final void setHoverPos(Vec3 vec3) {
                this.hoverPos = vec3;
            }

            protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity owner) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                if (level.isNight() || level.isRaining() || !BrainExtensionsKt.getMemorySafely(((PokemonEntity)this.$entity).getBrain(), CobblemonMemories.HAS_NECTAR).orElse(false).booleanValue()) {
                    return false;
                }
                Optional<BlockPos> optionalBlockPos = BrainExtensionsKt.getMemorySafely(((PokemonEntity)this.$entity).getBrain(), CobblemonMemories.NEARBY_SACC_LEAVES);
                if (!optionalBlockPos.isPresent() || !Intrinsics.areEqual((Object)level.getBlockState(optionalBlockPos.get()).getBlock(), (Object)((Object)CobblemonBlocks.SACCHARINE_LEAVES))) {
                    return false;
                }
                return Vec3.atCenterOf((Vec3i)((Vec3i)optionalBlockPos.get())).distanceTo(this.$entity.position()) <= 0.6;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected boolean canStillUse(ServerLevel level, LivingEntity entity, long gameTime) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (!this.checkExtraStartConditions(level, entity)) return false;
                Set set = entity.getBrain().getActiveActivities();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getActiveActivities(...)");
                if (CollectionsKt.indexOf((Iterable)set, (Object)CobblemonActivities.POKEMON_POLLINATION) == -1) return false;
                return true;
            }

            protected void start(ServerLevel level, LivingEntity entity, long gameTime) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                super.start(level, entity, gameTime);
                this.hoverPos = null;
            }

            /*
             * Unable to fully structure code
             */
            protected void tick(ServerLevel level, LivingEntity owner, long gameTime) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                ++this.successfulPollinationTicks;
                if (((PokemonEntity)this.$entity).getRandom().nextFloat() < 0.05f && this.successfulPollinationTicks > this.lastSoundPlayedTick + 60) {
                    this.lastSoundPlayedTick = this.successfulPollinationTicks;
                    this.$entity.playSound(SoundEvents.BEEHIVE_DRIP, 1.0f, 1.0f);
                }
                leavesPos = BrainExtensionsKt.getMemorySafely(((PokemonEntity)this.$entity).getBrain(), CobblemonMemories.NEARBY_SACC_LEAVES).orElse(null);
                if (this.hoverPos == null) ** GOTO lbl-1000
                v0 = this.$entity.position();
                v1 = this.hoverPos;
                Intrinsics.checkNotNull((Object)v1);
                if (v0.distanceTo(v1) <= 0.1) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                bl = v2;
                v3 = bl3 = ((PokemonEntity)this.$entity).getRandom().nextInt(40) == 0;
                if (bl && bl3) {
                    if (this.hoverPos == null) {
                        this.hoverPos = leavesPos.getBottomCenter().add(0.0, 0.4, 0.0);
                    }
                    if (leavesPos != null) {
                        this.hoverPos = leavesPos.getBottomCenter().add(new Vec3((((PokemonEntity)this.$entity).getRandom().nextDouble() * 2.0 - 1.0) * 0.2, 0.3 + (((PokemonEntity)this.$entity).getRandom().nextDouble() * 2.0 - 1.0) * 0.14285714285714285, (((PokemonEntity)this.$entity).getRandom().nextDouble() * 2.0 - 1.0) * 0.2));
                        v4 = ((PokemonEntity)this.$entity).getMoveControl();
                        v5 = this.hoverPos;
                        Intrinsics.checkNotNull((Object)v5);
                        v6 = v5.x();
                        v7 = this.hoverPos;
                        Intrinsics.checkNotNull((Object)v7);
                        v8 = v7.y();
                        v9 = this.hoverPos;
                        Intrinsics.checkNotNull((Object)v9);
                        v4.setWantedPosition(v6, v8, v9.z(), 0.35);
                        ((PokemonEntity)this.$entity).getLookControl().setLookAt(leavesPos.getBottomCenter().add(0.0, 0.5, 0.0));
                    }
                } else if (!bl) {
                    v10 = ((PokemonEntity)this.$entity).getMoveControl();
                    v11 = this.hoverPos;
                    Intrinsics.checkNotNull((Object)v11);
                    v12 = v11.x();
                    v13 = this.hoverPos;
                    Intrinsics.checkNotNull((Object)v13);
                    v14 = v13.y();
                    v15 = this.hoverPos;
                    Intrinsics.checkNotNull((Object)v15);
                    v10.setWantedPosition(v12, v14, v15.z(), 0.35);
                }
            }

            protected void stop(ServerLevel level, LivingEntity entity, long gameTime) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (this.successfulPollinationTicks > 250) {
                    BlockPos blockPos;
                    Brain brain = entity.getBrain();
                    Intrinsics.checkNotNullExpressionValue((Object)brain, (String)"getBrain(...)");
                    BlockPos blockPos2 = blockPos = (BlockPos)BrainExtensionsKt.getMemorySafely(brain, CobblemonMemories.NEARBY_SACC_LEAVES).orElse(null);
                    if (blockPos2 != null) {
                        Integer saccAge;
                        BlockPos it = blockPos2;
                        boolean bl = false;
                        BlockState blockState = level.getBlockState(blockPos);
                        if (Intrinsics.areEqual((Object)blockState.getBlock(), (Object)((Object)CobblemonBlocks.SACCHARINE_LEAVES)) && (saccAge = (Integer)blockState.getValue((Property)SaccharineLeafBlock.Companion.getAGE())) < 2) {
                            entity.getBrain().eraseMemory(CobblemonMemories.HAS_NECTAR);
                            BlockState newBlockState = (BlockState)blockState.setValue((Property)SaccharineLeafBlock.Companion.getAGE(), (Comparable)Integer.valueOf(saccAge + 1));
                            level.setBlock(blockPos, newBlockState, 3);
                        }
                    }
                }
                this.successfulPollinationTicks = 0;
                entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/PlaceHoneyInSaccLeavesTaskConfig$Companion;", "", "<init>", "()V", "", "POLLINATE", "Ljava/lang/String;", "", "MIN_DURATION", "I", "MAX_DURATION", "REQUIRED_SUCCESSFUL_POLLINATION_TICKS", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

