/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.ai.config.task;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.CobblemonSensors;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.tasks.PlaceHoneyInHiveTask;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR'\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fj\u0002`\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/PathToBeeHiveTaskConfig;", "Lcom/cobblemon/mod/common/api/ai/config/task/SingleTaskConfig;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;", "behaviourConfigurationContext", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "getVariables", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Ljava/util/List;", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "createTask", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "Lcom/mojang/datafixers/util/Either;", "Lcom/bedrockk/molang/Expression;", "Lcom/cobblemon/mod/common/api/ai/ExpressionOrEntityVariable;", "condition", "Lcom/mojang/datafixers/util/Either;", "getCondition", "()Lcom/mojang/datafixers/util/Either;", "Companion", "common"})
public final class PathToBeeHiveTaskConfig
implements SingleTaskConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Either<Expression, MoLangConfigVariable> condition = this.booleanVariable("honey", "can_add_honey", true).asExpressible();
    @NotNull
    public static final String HONEY = "honey";
    public static final int STAY_OUT_OF_HIVE_COOLDOWN = 400;

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getCondition() {
        return this.condition;
    }

    @Override
    @NotNull
    public List<MoLangConfigVariable> getVariables(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        return ExpressionOrEntityVariableKt.asVariables(CollectionsKt.listOf(this.condition));
    }

    @Override
    @Nullable
    public BehaviorControl<? super LivingEntity> createTask(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        if (!(entity instanceof PokemonEntity)) {
            return null;
        }
        if (!this.checkCondition(behaviourConfigurationContext.getRuntime(), this.condition)) {
            return null;
        }
        Object object = new SensorType[]{CobblemonSensors.NEARBY_BEE_HIVE};
        behaviourConfigurationContext.addSensors((SensorType<?>)object);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), TuplesKt.to((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), TuplesKt.to(CobblemonMemories.HAS_NECTAR, (Object)MemoryStatus.REGISTERED), TuplesKt.to(CobblemonMemories.HIVE_LOCATION, (Object)MemoryStatus.VALUE_PRESENT), TuplesKt.to(CobblemonMemories.HIVE_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT), TuplesKt.to(CobblemonMemories.HIVE_BLACKLIST, (Object)MemoryStatus.REGISTERED)};
        object = MapsKt.mapOf((Pair[])pairArray);
        return (BehaviorControl)new Behavior<LivingEntity>(object){
            private final int maxTicks;
            private int traveledTicks;
            {
                this.maxTicks = 400;
            }

            public final int getMaxTicks() {
                return this.maxTicks;
            }

            public final int getTraveledTicks() {
                return this.traveledTicks;
            }

            public final void setTraveledTicks(int n) {
                this.traveledTicks = n;
            }

            protected boolean checkExtraStartConditions(ServerLevel level, LivingEntity owner) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                return owner instanceof PathfinderMob && ((PathfinderMob)owner).isAlive() && owner instanceof PokemonEntity && PlaceHoneyInHiveTask.INSTANCE.wantsToEnterHive((PokemonEntity)owner) && ((PokemonEntity)owner).getBrain().checkMemory(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected boolean canStillUse(ServerLevel level, LivingEntity entity, long gameTime) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (this.maxTicks >= this.traveledTicks) {
                    return false;
                }
                Optional pos = entity.getBrain().getMemory(CobblemonMemories.HIVE_LOCATION);
                if (pos.isEmpty()) return false;
                Entity entity2 = (Entity)entity;
                T t = pos.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                if (!(EntityExtensionsKt.distanceTo(entity2, (BlockPos)t) > 1.0)) return false;
                return true;
            }

            /*
             * WARNING - void declaration
             */
            protected void start(ServerLevel level, LivingEntity entity, long gameTime) {
                void $this$sortedBy$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                super.start(level, entity, gameTime);
                Brain brain = entity.getBrain();
                Intrinsics.checkNotNullExpressionValue((Object)brain, (String)"getBrain(...)");
                BlockPos hiveLocation = BrainExtensionsKt.getMemorySafely(brain, CobblemonMemories.HIVE_LOCATION).orElse(null);
                Level world = entity.level();
                Object object = new BlockPos[]{hiveLocation.north(), hiveLocation.south(), hiveLocation.east(), hiveLocation.west()};
                object = CollectionsKt.listOf((Object[])object);
                boolean $i$f$sortedBy = false;
                List sidesByClosest = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(entity){
                    final /* synthetic */ LivingEntity $entity$inlined;
                    {
                        this.$entity$inlined = livingEntity;
                    }

                    public final int compare(T a, T b) {
                        BlockPos it = (BlockPos)a;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.distSqr((Vec3i)this.$entity$inlined.blockPosition()));
                        it = (BlockPos)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.distSqr((Vec3i)this.$entity$inlined.blockPosition())));
                    }
                });
                BlockPos openSide = BlockPos.ZERO;
                for (BlockPos side : sidesByClosest) {
                    if (!world.getBlockState(side).isAir()) continue;
                    openSide = side;
                    break;
                }
                if (Intrinsics.areEqual((Object)openSide, (Object)BlockPos.ZERO)) {
                    if (world.getBlockState(hiveLocation.above()).isAir()) {
                        openSide = hiveLocation.above();
                    } else if (world.getBlockState(hiveLocation.below()).isAir()) {
                        openSide = hiveLocation.below();
                    } else {
                        return;
                    }
                }
                Vec3 targetVec = Vec3.atCenterOf((Vec3i)((Vec3i)openSide));
                BlockPos blockPos = openSide;
                Intrinsics.checkNotNull((Object)blockPos);
                if (this.pathfindDirectlyTowards(blockPos, entity)) {
                    entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetVec, 0.35f, 0));
                    entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(targetVec.add(0.0, (double)entity.getEyeHeight(), 0.0)));
                    this.traveledTicks = 0;
                } else {
                    this.dropAndBlackListHive(entity);
                }
            }

            protected void tick(ServerLevel level, LivingEntity owner, long gameTime) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                int n = this.traveledTicks;
                this.traveledTicks = n + 1;
            }

            protected void stop(ServerLevel level, LivingEntity entity, long gameTime) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (this.maxTicks < this.traveledTicks) {
                    this.dropAndBlackListHive(entity);
                    entity.getBrain().setMemoryWithExpiry(CobblemonMemories.HIVE_COOLDOWN, (Object)true, 100L);
                }
            }

            public final void dropAndBlackListHive(LivingEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Brain brain = entity.getBrain();
                Intrinsics.checkNotNullExpressionValue((Object)brain, (String)"getBrain(...)");
                BlockPos hivePos = BrainExtensionsKt.getMemorySafely(brain, CobblemonMemories.HIVE_LOCATION).orElse(null);
                if (hivePos == null) {
                    return;
                }
                Brain brain2 = entity.getBrain();
                Intrinsics.checkNotNullExpressionValue((Object)brain2, (String)"getBrain(...)");
                List<BlockPos> list = BrainExtensionsKt.getMemorySafely(brain2, CobblemonMemories.HIVE_BLACKLIST).orElse(CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"orElse(...)");
                List blackList = CollectionsKt.toMutableList((Collection)list);
                blackList.add(hivePos);
                if (((Collection)blackList).size() > 3) {
                    blackList.removeFirst();
                }
                entity.getBrain().eraseMemory(CobblemonMemories.HIVE_LOCATION);
                entity.getBrain().setMemory(CobblemonMemories.HIVE_BLACKLIST, (Object)blackList);
            }

            private final boolean pathfindDirectlyTowards(BlockPos pos, LivingEntity entity) {
                if (!(entity instanceof PathfinderMob)) {
                    return false;
                }
                PathNavigation nav = ((PathfinderMob)entity).getNavigation();
                Path path = nav.createPath(pos, 0);
                return path != null && path.canReach();
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/PathToBeeHiveTaskConfig$Companion;", "", "<init>", "()V", "", "HONEY", "Ljava/lang/String;", "", "STAY_OUT_OF_HIVE_COOLDOWN", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

