/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.ai.config.task;

import com.bedrockk.molang.Expression;
import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R'\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0\u0016j\u0002`\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/api/ai/config/task/FindAirTaskConfig;", "Lcom/cobblemon/mod/common/api/ai/config/task/SingleTaskConfig;", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;", "behaviourConfigurationContext", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "getVariables", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Ljava/util/List;", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "createTask", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/api/ai/BehaviourConfigurationContext;)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "Lnet/minecraft/world/level/LevelReader;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "", "isAirPos", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lcom/mojang/datafixers/util/Either;", "Lcom/bedrockk/molang/Expression;", "Lcom/cobblemon/mod/common/api/ai/ExpressionOrEntityVariable;", "walkSpeed", "Lcom/mojang/datafixers/util/Either;", "getWalkSpeed", "()Lcom/mojang/datafixers/util/Either;", "common"})
public final class FindAirTaskConfig
implements SingleTaskConfig {
    @NotNull
    private final Either<Expression, MoLangConfigVariable> walkSpeed = this.numberVariable("movement", "walk_speed", 0.35).asExpressible();

    @NotNull
    public final Either<Expression, MoLangConfigVariable> getWalkSpeed() {
        return this.walkSpeed;
    }

    @Override
    @NotNull
    public List<MoLangConfigVariable> getVariables(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        return ExpressionOrEntityVariableKt.asVariables(CollectionsKt.listOf(this.walkSpeed));
    }

    @Override
    @Nullable
    public BehaviorControl<? super LivingEntity> createTask(@NotNull LivingEntity entity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)behaviourConfigurationContext, (String)"behaviourConfigurationContext");
        if (!(entity instanceof PathfinderMob)) {
            return null;
        }
        MemoryModuleType[] memoryModuleTypeArray = new MemoryModuleType[2];
        Intrinsics.checkNotNullExpressionValue((Object)MemoryModuleType.WALK_TARGET, (String)"WALK_TARGET");
        memoryModuleTypeArray[1] = CobblemonMemories.PATH_COOLDOWN;
        behaviourConfigurationContext.addMemories(memoryModuleTypeArray);
        return (BehaviorControl)BehaviorBuilder.create(arg_0 -> FindAirTaskConfig.createTask$lambda$0(this, arg_0));
    }

    private final boolean isAirPos(LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        BlockState aboveState = world.getBlockState(pos.above());
        boolean notFluid = world.getFluidState(pos.above()).isEmpty() || blockState.is(Blocks.BUBBLE_COLUMN);
        boolean canPathfindThroughAbove = aboveState.isPathfindable(PathComputationType.LAND);
        boolean solidBelow = !blockState.isPathfindable(PathComputationType.LAND);
        return notFluid && canPathfindThroughAbove && solidBelow;
    }

    private static final App createTask$lambda$0(FindAirTaskConfig this$0, BehaviorBuilder.Instance it) {
        return it.group((App)it.absent(MemoryModuleType.WALK_TARGET), (App)it.absent(CobblemonMemories.PATH_COOLDOWN)).apply((Applicative)it, (arg_0, arg_1) -> FindAirTaskConfig.createTask$lambda$0$0(this$0, arg_0, arg_1));
    }

    private static final Trigger createTask$lambda$0$0(FindAirTaskConfig this$0, MemoryAccessor walkTarget, MemoryAccessor pathCooldown) {
        return (arg_0, arg_1, arg_2) -> FindAirTaskConfig.createTask$lambda$0$0$0(pathCooldown, walkTarget, this$0, arg_0, arg_1, arg_2);
    }

    private static final boolean createTask$lambda$0$0$0(MemoryAccessor $pathCooldown, MemoryAccessor $walkTarget, FindAirTaskConfig this$0, ServerLevel world, LivingEntity entity, long time) {
        Intrinsics.checkNotNull((Object)entity);
        if (!EntityExtensionsKt.getIsSubmerged((Entity)entity) || entity.isInLava()) {
            return false;
        }
        Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(entity.getX() - 4.0)), (int)(entity.getBlockY() - 1), (int)Mth.floor((double)(entity.getZ() - 4.0)), (int)Mth.floor((double)(entity.getX() + 4.0)), (int)Mth.floor((double)(entity.getY() + 8.0)), (int)Mth.floor((double)(entity.getZ() + 4.0)));
        $pathCooldown.setWithExpiry((Object)true, 20L);
        Entity entity2 = (Entity)entity;
        Intrinsics.checkNotNull((Object)iterable);
        BlockPos blockPos = EntityExtensionsKt.closestPosition(entity2, iterable, (Function1<? super BlockPos, Boolean>)((Function1)arg_0 -> FindAirTaskConfig.createTask$lambda$0$0$0$0(this$0, entity, arg_0)));
        if (blockPos == null) {
            return false;
        }
        BlockPos blockPos2 = blockPos;
        $walkTarget.set((Object)new WalkTarget(blockPos2.above(), 0.35f, 0));
        return true;
    }

    private static final boolean createTask$lambda$0$0$0$0(FindAirTaskConfig this$0, LivingEntity $entity, BlockPos it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Level level = $entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return this$0.isAirPos((LevelReader)level, it);
    }
}

