/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.block_entity;

import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class TickingBlockEntityType<T extends BlockEntity>
extends BlockEntityType<T> {
    protected final TickSide side;

    public TickingBlockEntityType(BlockEntityType.BlockEntitySupplier<? extends T> pFactory, Set<Block> pValidBlocks, TickSide side) {
        super(pFactory, pValidBlocks, null);
        this.side = side;
    }

    @Nullable
    public BlockEntityTicker<T> getTicker(boolean client) {
        if (client && this.side.ticksOnClient()) {
            return (level, pos, state, entity) -> ((TickingBlockEntity)entity).clientTick(level, pos, state);
        }
        if (!client && this.side.ticksOnServer()) {
            return (level, pos, state, entity) -> ((TickingBlockEntity)entity).serverTick(level, pos, state);
        }
        return null;
    }

    public static enum TickSide {
        CLIENT,
        SERVER,
        CLIENT_AND_SERVER;


        public boolean ticksOnClient() {
            return this == CLIENT || this == CLIENT_AND_SERVER;
        }

        public boolean ticksOnServer() {
            return this == SERVER || this == CLIENT_AND_SERVER;
        }
    }
}

