/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;

final class HotspotVMOptions {
    public static final boolean IS_HOTSPOT_VM;
    private static final String MANAGEMENT_FACTORY_CLASS = "java.lang.management.ManagementFactory";
    private static final String HOTSPOT_BEAN_CLASS = "com.sun.management.HotSpotDiagnosticMXBean";
    private static final Function<String, Optional<String>> ACCESSOR;

    private HotspotVMOptions() {
    }

    public static Optional<String> get(String name) {
        return ACCESSOR.apply(Objects.requireNonNull(name, "name"));
    }

    static {
        boolean isHotspot = false;
        Function<String, Optional> accessor = name -> Optional.empty();
        try {
            Class<?> beanClazz = Class.forName(HOTSPOT_BEAN_CLASS);
            Object hotSpotBean = Class.forName(MANAGEMENT_FACTORY_CLASS).getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
            if (hotSpotBean != null) {
                Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                Method getValueMethod = getVMOptionMethod.getReturnType().getMethod("getValue", new Class[0]);
                isHotspot = true;
                accessor = name -> {
                    try {
                        Object vmOption = getVMOptionMethod.invoke(hotSpotBean, name);
                        return Optional.of(getValueMethod.invoke(vmOption, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException e) {
                        return Optional.empty();
                    }
                };
            }
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            isHotspot = false;
            Logger log = Logger.getLogger(HotspotVMOptions.class.getName());
            Module module = HotspotVMOptions.class.getModule();
            ModuleLayer layer = module.getLayer();
            if (layer != null) {
                if (!layer.findModule("jdk.management").map(module::canRead).orElse(false).booleanValue()) {
                    log.warning("Lucene cannot access JVM internals to optimize algorithms or calculate object sizes, unless the 'jdk.management' Java module is readable [please add 'jdk.management' to modular application either by command line or its module descriptor].");
                }
            }
            log.warning("Lucene cannot optimize algorithms or calculate object sizes for JVMs that are not based on Hotspot or a compatible implementation.");
        }
        IS_HOTSPOT_VM = isHotspot;
        ACCESSOR = accessor;
    }
}

