/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElderGuardianBehavior
extends JarBehavior<ElderGuardian> {
    @Override
    public void tick(MobJarTile tile) {
        if (!this.isPowered(tile)) {
            return;
        }
        if (tile.getLevel().getGameTime() % 1200L == 0L) {
            this.applyMiningFatigue(tile);
        }
    }

    @Override
    public void onRedstonePower(MobJarTile tile) {
        this.applyMiningFatigue(tile);
    }

    public void applyMiningFatigue(MobJarTile tile) {
        Level level = tile.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MobEffectInstance effect = new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 6000, 2);
            List list = MobEffectUtil.addEffectToPlayersAround((ServerLevel)serverLevel, this.entityFromJar(tile), (Vec3)Vec3.atCenterOf((Vec3i)tile.getBlockPos()), (double)50.0, (MobEffectInstance)effect, (int)1200);
            list.forEach(player -> player.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.GUARDIAN_ELDER_EFFECT, 1.0f)));
        }
    }
}

