/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSlotMap;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.ScryerCrystal;
import com.hollingsworth.arsnouveau.common.items.ScryerScroll;
import com.hollingsworth.arsnouveau.common.items.data.ScryPosData;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScryCasterData
extends AbstractCaster<ScryCasterData> {
    public static final MapCodec<ScryCasterData> CODEC = ScryCasterData.createCodec(ScryCasterData::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, ScryCasterData> STREAM_CODEC = ScryCasterData.createStream(ScryCasterData::new);

    @Override
    public MapCodec<ScryCasterData> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ScryCasterData> streamCodec() {
        return STREAM_CODEC;
    }

    public ScryCasterData() {
    }

    public ScryCasterData(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots) {
        super(slot, flavorText, isHidden, hiddenText, maxSlots);
    }

    public ScryCasterData(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        super(slot, flavorText, isHidden, hiddenText, maxSlots, spells);
    }

    @Override
    public InteractionResultHolder<ItemStack> castSpell(Level worldIn, LivingEntity entity, InteractionHand handIn, @Nullable Component invalidMessage, @NotNull Spell spell) {
        BlockPos scryPos;
        LivingCaster livingCaster;
        ANFakePlayer player;
        ItemStack stack = entity.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            return InteractionResultHolder.pass((Object)entity.getItemInHand(handIn));
        }
        if (!(spell = this.modifySpellBeforeCasting((ServerLevel)worldIn, (Entity)entity, handIn, spell)).isValid() && invalidMessage != null) {
            PortUtil.sendMessageNoSpam((Entity)entity, invalidMessage);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (entity instanceof Player) {
            Player thisPlayer = (Player)entity;
            v0 = thisPlayer;
        } else {
            v0 = player = ANFakePlayer.getPlayer((ServerLevel)worldIn);
        }
        if (entity instanceof Player) {
            Player pCaster = (Player)entity;
            livingCaster = new PlayerCaster(pCaster);
        } else {
            livingCaster = new LivingCaster(entity);
        }
        LivingCaster wrappedCaster = livingCaster;
        SpellResolver resolver = this.getSpellResolver(new SpellContext(worldIn, spell, entity, wrappedCaster, stack), worldIn, (LivingEntity)player, handIn);
        ITurretBehavior behavior = BasicSpellTurret.TURRET_BEHAVIOR_MAP.get(spell.getCastMethod());
        if (behavior == null) {
            PortUtil.sendMessage((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.scry_caster.invalid_behavior"));
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        ScryPosData data = (ScryPosData)stack.get(DataComponentRegistry.SCRY_DATA);
        boolean playerHoldingScroll = entity.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ScryerScroll;
        GlobalPos globalPos = playerHoldingScroll ? (GlobalPos)((ScryPosData)player.getItemInHand(InteractionHand.OFF_HAND).getOrDefault(DataComponentRegistry.SCRY_DATA, (Object)new ScryPosData(Optional.empty()))).pos().orElse(null) : (GlobalPos)data.pos().orElse(null);
        BlockPos blockPos = scryPos = globalPos == null ? null : globalPos.pos();
        if (scryPos == null) {
            PortUtil.sendMessage((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.scry_caster.no_pos"));
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        if (!worldIn.isLoaded(scryPos)) {
            PortUtil.sendMessage((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.camera.not_loaded"));
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        BlockState castingAtState = worldIn.getBlockState(scryPos);
        if (!(castingAtState.getBlock() instanceof ScryerCrystal)) {
            PortUtil.sendMessage((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.scry_caster.not_crystal"));
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        if (!resolver.canCast((LivingEntity)player)) {
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
        }
        Direction direction = (Direction)castingAtState.getValue((Property)ScryerCrystal.FACING);
        Position position = spell.getCastMethod() instanceof MethodTouch ? BasicSpellTurret.getDispensePosition(scryPos, direction) : ScryerCrystal.getDispensePosition(scryPos, direction);
        behavior.onCast(resolver, (ServerLevel)worldIn, scryPos, (Player)player, position, direction);
        resolver.expendMana();
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
    }

    @Override
    public DataComponentType<ScryCasterData> getComponentType() {
        return (DataComponentType)DataComponentRegistry.SCRY_CASTER.get();
    }

    @Override
    protected ScryCasterData build(int slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        return new ScryCasterData((Integer)slot, flavorText, isHidden, hiddenText, maxSlots, spells);
    }
}

