/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.ScryPosData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import org.jetbrains.annotations.NotNull;

public class ScryerScroll
extends ModItem {
    public ScryerScroll() {
        super(ScryerScroll.defaultProps().component(DataComponentRegistry.SCRY_DATA, (Object)new ScryPosData(Optional.empty())));
        this.withTooltip((Component)Component.translatable((String)"tooltip.ars_nouveau.scryer_scroll"));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        if (pContext.getLevel().isClientSide) {
            return super.useOn(pContext);
        }
        if (pContext.getLevel().getBlockEntity(pContext.getClickedPos()) instanceof ICameraMountable) {
            ScryPosData data = new ScryPosData(new GlobalPos(pContext.getLevel().dimension(), pContext.getClickedPos()));
            pContext.getItemInHand().set(DataComponentRegistry.SCRY_DATA, (Object)data);
            PortUtil.sendMessage((Entity)pContext.getPlayer(), (Component)Component.translatable((String)"ars_nouveau.scryer_scroll.bound", (Object[])new Object[]{pContext.getClickedPos().getX() + ", " + pContext.getClickedPos().getY() + ", " + pContext.getClickedPos().getZ()}));
        }
        return super.useOn(pContext);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        ScryPosData data = (ScryPosData)stack.get(DataComponentRegistry.SCRY_DATA);
        GlobalPos globalPos = data.pos().orElse(null);
        if (globalPos != null) {
            BlockPos pos = globalPos.pos();
            tooltip2.add((Component)Component.translatable((String)"ars_nouveau.scryer_scroll.bound", (Object[])new Object[]{pos.getX() + ", " + pos.getY() + ", " + pos.getZ()}));
        } else {
            tooltip2.add((Component)Component.translatable((String)"ars_nouveau.scryer_scroll.craft"));
        }
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }
}

