/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovementHandler
extends MoveControl {
    final AttributeInstance speedAtr;

    public MovementHandler(Mob mob) {
        super(mob);
        this.speedAtr = this.mob.getAttribute(Attributes.MOVEMENT_SPEED);
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.STRAFE) {
            float speedAtt = (float)this.speedAtr.getValue();
            float speed = (float)this.speedModifier * speedAtt;
            float forward = this.strafeForwards;
            float strafe = this.strafeRight;
            float totalMovement = Mth.sqrt((float)(forward * forward + strafe * strafe));
            if (totalMovement < 1.0f) {
                totalMovement = 1.0f;
            }
            totalMovement = speed / totalMovement;
            float sinRotation = Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            float cosRotation = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            float rot1 = (forward *= totalMovement) * cosRotation - (strafe *= totalMovement) * sinRotation;
            float rot2 = strafe * cosRotation + forward * sinRotation;
            PathNavigation pathnavigator = this.mob.getNavigation();
            NodeEvaluator nodeprocessor = pathnavigator.getNodeEvaluator();
            if (nodeprocessor.getPathType(this.mob, new BlockPos(Mth.floor((double)(this.mob.getX() + (double)rot1)), Mth.floor((double)this.mob.getY()), Mth.floor((double)(this.mob.getZ() + (double)rot2)))) != PathType.WALKABLE) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
                speed = speedAtt;
            }
            this.mob.setSpeed(speed);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = MoveControl.Operation.WAIT;
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            double xDif = this.wantedX - this.mob.getX();
            double zDif = this.wantedZ - this.mob.getZ();
            double yDif = this.wantedY - this.mob.getY();
            double dist = xDif * xDif + yDif * yDif + zDif * zDif;
            if (dist < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
                return;
            }
            float range = (float)(Mth.atan2((double)zDif, (double)xDif) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), range, 90.0f));
            this.mob.setSpeed((float)(this.speedModifier * this.speedAtr.getValue()));
            BlockPos blockpos = BlockPos.containing((Position)this.mob.position());
            BlockState blockstate = this.mob.level.getBlockState(blockpos);
            Block block = blockstate.getBlock();
            VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)this.mob.level, blockpos);
            if (yDif > (double)this.mob.maxUpStep() && xDif * xDif + zDif * zDif < (double)Math.max(1.0f, this.mob.getBbWidth()) || !voxelshape.isEmpty() && this.mob.getY() < voxelshape.max(Direction.Axis.Y) + (double)blockpos.getY() && !blockstate.is(BlockTags.DOORS) && !blockstate.is(BlockTags.FENCES) && !blockstate.is(BlockTags.FENCE_GATES) && !block.isLadder(blockstate, (LevelReader)this.mob.level, blockpos, (LivingEntity)this.mob)) {
                this.mob.getJumpControl().jump();
                this.operation = MoveControl.Operation.JUMPING;
            }
        } else if (this.operation == MoveControl.Operation.JUMPING) {
            this.mob.setSpeed((float)(this.speedModifier * this.speedAtr.getValue()));
            BlockPos blockpos = BlockPos.containing((Position)this.mob.position());
            BlockState blockstate = this.mob.level.getBlockState(blockpos);
            if (this.mob.onGround() || blockstate.liquid()) {
                this.operation = MoveControl.Operation.WAIT;
            }
        } else {
            this.mob.setZza(0.0f);
        }
    }

    public void setWantedPosition(double x, double y, double z, double speedIn) {
        super.setWantedPosition(x, y, z, speedIn);
        this.operation = MoveControl.Operation.MOVE_TO;
    }
}

