/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ModelProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.ProjectileTimeline;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.client.renderer.entity.StyledProjectileModel;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class StyledSpellRender
extends GeoEntityRenderer<EntityProjectileSpell> {
    ModelProperty modelProp;

    public StyledSpellRender(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new StyledProjectileModel());
    }

    public void render(EntityProjectileSpell entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        ProjectileTimeline timeline = (ProjectileTimeline)entity.resolver().spell.particleTimeline().get((IParticleTimelineType)ParticleTimelineRegistry.PROJECTILE_TIMELINE.get());
        ModelProperty modelProperty = (ModelProperty)timeline.trailEffect.motion().propertyMap.get((IPropertyType)ParticlePropertyRegistry.MODEL_PROPERTY.get());
        if (modelProperty == null || modelProperty.selectedResource == ModelProperty.NONE) {
            return;
        }
        this.modelProp = modelProperty;
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void actuallyRender(PoseStack poseStack, EntityProjectileSpell animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot())));
        if (this.modelProp.selectedResource.supportsColor()) {
            colour = this.modelProp.subPropMap.getParticleColor().getColor();
        }
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        poseStack.popPose();
    }

    @Nullable
    public RenderType getRenderType(EntityProjectileSpell animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutout((ResourceLocation)texture);
    }

    public GeoModel<EntityProjectileSpell> getGeoModel() {
        return super.getGeoModel();
    }
}

