/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.client.jei.JEIArsNouveauPlugin;
import com.hollingsworth.arsnouveau.client.jei.MultiInputCategory;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class GlyphRecipeCategory
extends MultiInputCategory<GlyphRecipe> {
    public IDrawable background;
    public IDrawable icon;

    public GlyphRecipeCategory(IGuiHelper helper) {
        super(helper, glyphRecipe -> new MultiInputCategory.MultiProvider(glyphRecipe.output, glyphRecipe.inputs, null));
        this.background = helper.createBlankDrawable(114, 108);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(BlockRegistry.SCRIBES_BLOCK));
    }

    public RecipeType<RecipeHolder<GlyphRecipe>> getRecipeType() {
        return JEIArsNouveauPlugin.GLYPH_RECIPE_TYPE.get();
    }

    public Component getTitle() {
        return Component.translatable((String)"block.ars_nouveau.scribes_table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(RecipeHolder<GlyphRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GlyphRecipe recipe = (GlyphRecipe)recipeHolder.value();
        Font renderer = Minecraft.getInstance().font;
        guiGraphics.drawString(renderer, (Component)Component.translatable((String)"ars_nouveau.exp", (Object[])new Object[]{ScribesTile.getLevelsFromExp(recipe.exp)}), 0, 100, 10, false);
    }
}

