/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.recipe.IRecipeWrapper;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.recipe.ShapedHelper;
import com.hollingsworth.arsnouveau.api.recipe.SingleRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import org.jetbrains.annotations.Nullable;

public class MultiRecipeWrapper
implements IRecipeWrapper {
    public Set<SingleRecipe> recipes = new HashSet<SingleRecipe>();
    public static Map<Item, MultiRecipeWrapper> RECIPE_CACHE = new HashMap<Item, MultiRecipeWrapper>();

    public static MultiRecipeWrapper fromStack(ItemStack stack, Level level) {
        MultiRecipeWrapper wrapper = new MultiRecipeWrapper();
        if (stack.getItem() == Items.POTION) {
            for (BrewingRecipe r : ArsNouveauAPI.getInstance().getAllPotionRecipes(level)) {
                if (!ItemStack.matches((ItemStack)stack, (ItemStack)r.getOutput())) continue;
                ArrayList<Ingredient> list = new ArrayList<Ingredient>();
                list.add(PotionIngredient.getIngredient(r.getInput().getItems()[0]));
                list.add(r.getIngredient());
                wrapper.addRecipe(list, r.getOutput(), null);
            }
        } else {
            if (RECIPE_CACHE.containsKey(stack.getItem())) {
                return RECIPE_CACHE.get(stack.getItem());
            }
            for (RecipeHolder rh : level.getServer().getRecipeManager().getRecipes()) {
                Recipe r = rh.value();
                if (r.getResultItem((HolderLookup.Provider)level.registryAccess()) == null || r.getResultItem((HolderLookup.Provider)level.registryAccess()).getItem() != stack.getItem()) continue;
                if (r instanceof ShapedRecipe) {
                    ShapedHelper helper = new ShapedHelper((ShapedRecipe)r);
                    for (List<Ingredient> iList : helper.getPossibleRecipes()) {
                        wrapper.addRecipe(iList, r.getResultItem((HolderLookup.Provider)level.registryAccess()), r);
                    }
                }
                if (!(r instanceof ShapelessRecipe)) continue;
                wrapper.addRecipe((List<Ingredient>)r.getIngredients(), r.getResultItem((HolderLookup.Provider)level.registryAccess()), r);
            }
            RECIPE_CACHE.put(stack.getItem(), wrapper);
        }
        return wrapper;
    }

    @Override
    @Nullable
    public IRecipeWrapper.InstructionsForRecipe canCraft(Map<Item, Integer> inventory, Level world, BlockPos pos) {
        for (SingleRecipe recipe : this.recipes) {
            List<ItemStack> itemsNeeded = this.getItemsNeeded(inventory, world, pos, recipe);
            if (itemsNeeded == null) continue;
            return new IRecipeWrapper.InstructionsForRecipe(recipe, itemsNeeded);
        }
        return null;
    }

    @Nullable
    public List<ItemStack> getItemsNeeded(Map<Item, Integer> inventory, Level world, BlockPos pos, SingleRecipe recipe) {
        HashMap<Item, Integer> map = new HashMap<Item, Integer>(inventory);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Ingredient i : recipe.recipeIngredients) {
            boolean foundStack = false;
            for (ItemStack stack : i.getItems()) {
                if (stack.getItem() == Items.POTION) {
                    PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                    if (potionContents == null) continue;
                    if (potionContents.is(Potions.WATER) || WixieCauldronTile.findNeededPotion(potionContents, 300, world, pos) != null) {
                        foundStack = true;
                        break;
                    }
                }
                if (!inventory.containsKey(stack.getItem()) || (Integer)map.get(stack.getItem()) <= 0) continue;
                map.put(stack.getItem(), (Integer)map.get(stack.getItem()) - 1);
                foundStack = true;
                items.add(stack.copy());
                break;
            }
            if (foundStack) continue;
            return null;
        }
        return items;
    }

    public boolean addRecipe(List<Ingredient> recipe, ItemStack outputStack, Recipe iRecipe) {
        return this.recipes.add(new SingleRecipe(recipe, outputStack, iRecipe));
    }

    public boolean isEmpty() {
        return this.recipes.isEmpty();
    }
}

