/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SpeedProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticleMotionRegistry;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class LightBlobMotion
extends ParticleMotion {
    public static MapCodec<LightBlobMotion> CODEC = LightBlobMotion.buildPropCodec(LightBlobMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, LightBlobMotion> STREAM = LightBlobMotion.buildStreamCodec(LightBlobMotion::new);

    public LightBlobMotion() {
        this(new PropMap());
    }

    public LightBlobMotion(PropMap propertyMap) {
        super(propertyMap);
    }

    @Override
    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ParticleMotionRegistry.LIGHT_BLOB.get();
    }

    @Override
    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        ParticleDensityProperty density = this.getDensity(particleOptions, 20, 0.1f);
        for (int i = 0; i < this.getNumParticles(density.density()); ++i) {
            Vec3 speed = this.randomSpeed(particleOptions, 0.0, 0.0, 0.0, 0.01);
            Vec3 adjustedVec = this.getMotionScaled(new Vec3(x, y, z), density.radius(), density.spawnType().orElse(ParticleMotion.SpawnType.SPHERE));
            Vector3f worldSpaceSpeed = this.toEmitterSpace(0.0f, 0.0f, 0.0f, (float)speed.x, (float)speed.y, (float)speed.z);
            level.addAlwaysVisibleParticle((ParticleOptions)particleOptions, true, adjustedVec.x, adjustedVec.y, adjustedVec.z, (double)worldSpaceSpeed.x, (double)worldSpaceSpeed.y, (double)worldSpaceSpeed.z);
        }
    }

    @Override
    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing(new ParticleTypeProperty()), propMap.createIfMissing(new ParticleDensityProperty(20, 0.1, ParticleMotion.SpawnType.SPHERE).minDensity(1).maxDensity(200).densityStepSize(1)), propMap.createIfMissing(new SpeedProperty(0.0, 0.01, 0.0, 0.0)));
    }
}

