/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item.inv;

import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ExtractedStack
extends SlotReference {
    public ItemStack stack;

    protected ExtractedStack(ItemStack stack, IItemHandler handler, int slot) {
        super(handler, slot);
        this.stack = stack;
    }

    public static ExtractedStack from(IItemHandler handler, int slot, int amount) {
        return new ExtractedStack(handler.extractItem(slot, amount, false), handler, slot);
    }

    public static ExtractedStack from(SlotReference slotReference, int amount) {
        return ExtractedStack.from(slotReference.getHandler(), slotReference.getSlot(), amount);
    }

    public static ExtractedStack empty() {
        return new ExtractedStack(ItemStack.EMPTY, null, -1);
    }

    public void replaceAndReturnOrDrop(ItemStack stack, Level level, BlockPos pos) {
        this.stack = stack;
        this.stack = this.returnStack();
        if (!this.stack.isEmpty()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, this.stack.copy()));
            this.stack.setCount(0);
        }
    }

    public ItemStack returnStack() {
        if (this.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = this.handler.insertItem(this.slot, this.stack, false);
        remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.handler, (ItemStack)remainder, (boolean)false);
        return remainder;
    }

    public void returnOrDrop(Level level, BlockPos pos) {
        if (this.isEmpty()) {
            return;
        }
        ItemStack remainder = this.returnStack();
        if (!remainder.isEmpty()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, remainder.copy()));
            this.stack = ItemStack.EMPTY;
        }
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || this.stack.isEmpty();
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

