/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.ftbquestslangsplitter.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.translation.TranslationTable;
import dev.uncandango.ftbquestslangsplitter.FTBQuestsLangSplitter;
import dev.uncandango.ftbquestslangsplitter.command.LocaleArgument;
import dev.uncandango.ftbquestslangsplitter.mixin.accessor.TranslationManagerAccessor;
import dev.uncandango.ftbquestslangsplitter.mixin.accessor.TranslationTableAccessor;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class LangSplitterCommands {
    private static Lazy<Map<String, String>> langsplitter$idToChapter;
    private static final Supplier<Map<String, String>> langsplitter$idToChapterSupplier;

    public static void registerCommonCommands(CommandBuildContext ctx, CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"langsplitter").requires(LangSplitterCommands::isSSP)).then(Commands.literal((String)"split").then(((RequiredArgumentBuilder)Commands.argument((String)"replace_unmerged", (ArgumentType)BoolArgumentType.bool()).executes(cmd -> LangSplitterCommands.splitLangFiles((CommandContext<CommandSourceStack>)cmd, null, BoolArgumentType.getBool((CommandContext)cmd, (String)"replace_unmerged")))).then(Commands.argument((String)"locale", (ArgumentType)LocaleArgument.locale()).executes(cmd -> LangSplitterCommands.splitLangFiles((CommandContext<CommandSourceStack>)cmd, LocaleArgument.getLocale((CommandContext<CommandSourceStack>)cmd, "locale"), BoolArgumentType.getBool((CommandContext)cmd, (String)"replace_unmerged"))))))).then(Commands.literal((String)"fill_missing_translation").then(Commands.argument((String)"replace_unmerged", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"locale", (ArgumentType)LocaleArgument.locale()).executes(cmd -> LangSplitterCommands.fillMissingTranslation((CommandContext<CommandSourceStack>)cmd, LocaleArgument.getLocale((CommandContext<CommandSourceStack>)cmd, "locale"), BoolArgumentType.getBool((CommandContext)cmd, (String)"replace_unmerged"))))))).then(Commands.literal((String)"purge_merged").executes(LangSplitterCommands::purgeMerged)));
    }

    private static int purgeMerged(CommandContext<CommandSourceStack> cmd) {
        Path langFolder = ServerQuestFile.INSTANCE.getFolder().resolve("lang");
        try (Stream<Path> s = Files.walk(langFolder, new FileVisitOption[0]);){
            s.filter(p -> p.getFileName().toString().endsWith(".snbt_merged")).forEach(p -> {
                try {
                    Files.delete(p);
                    FTBQuestsLangSplitter.LOGGER.debug("Deleted file {}", (Object)langFolder.relativize((Path)p));
                }
                catch (IOException e) {
                    FTBQuestsLangSplitter.LOGGER.error("Error while deleting merged file {}: {}", (Object)langFolder.relativize((Path)p), (Object)e.getMessage());
                }
            });
        }
        catch (IOException e) {
            FTBQuestsLangSplitter.LOGGER.error("Error while scanning folder {} for merged files", (Object)FMLPaths.CONFIGDIR.get().relativize(langFolder));
            ((CommandSourceStack)cmd.getSource()).sendFailure((Component)Component.literal((String)("Can't scan lang folder " + String.valueOf(FMLPaths.CONFIGDIR.get().relativize(langFolder)) + " for merged files")));
        }
        ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"ftbquestslangsplitter.commands.purged_merged_files"), true);
        return 1;
    }

    private static int fillMissingTranslation(CommandContext<CommandSourceStack> cmd, String locale, boolean replacesExisting) {
        if (locale.equals("en_us")) {
            ((CommandSourceStack)cmd.getSource()).sendFailure((Component)Component.literal((String)"Lang en_us is supposed to be the main language..."));
            return 0;
        }
        Map<String, TranslationTable> map = ((TranslationManagerAccessor)ServerQuestFile.INSTANCE.getTranslationManager()).langsplitter$getMap();
        Map<String, Either<String, List<String>>> englishTableMap = ((TranslationTableAccessor)map.computeIfAbsent("en_us", lang -> new TranslationTable())).langsplitter$getMap();
        TranslationTableAccessor targetTable = (TranslationTableAccessor)map.computeIfAbsent(locale, lang -> new TranslationTable());
        Map<String, Either<String, List<String>>> targetTableMap = targetTable.langsplitter$getMap();
        AtomicInteger count = new AtomicInteger();
        englishTableMap.forEach((id, value) -> {
            if (!targetTableMap.containsKey(id)) {
                count.incrementAndGet();
                targetTableMap.put((String)id, (Either<String, List<String>>)value);
                FTBQuestsLangSplitter.LOGGER.debug("Added missing entry with id {}", id);
            }
        });
        if (count.get() > 0) {
            targetTable.langsplitter$setSaveNeeded(true);
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"ftbquestslangsplitter.commands.added_missing_lang_entries", (Object[])new Object[]{count.get(), locale}).withStyle(ChatFormatting.GREEN), true);
            return LangSplitterCommands.splitLangFiles(cmd, locale, replacesExisting);
        }
        ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"ftbquestslangsplitter.commands.no_missing_entries", (Object[])new Object[]{locale}).withStyle(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int splitLangFiles(CommandContext<CommandSourceStack> cmd, @Nullable String langCode, boolean replacesExisting) {
        langsplitter$idToChapter = Lazy.of(langsplitter$idToChapterSupplier);
        Map<String, TranslationTable> map = ((TranslationManagerAccessor)ServerQuestFile.INSTANCE.getTranslationManager()).langsplitter$getMap();
        Path langFolder = ServerQuestFile.INSTANCE.getFolder().resolve("lang");
        if (langCode != null && !map.containsKey(langCode)) {
            return LangSplitterCommands.fillMissingTranslation(cmd, langCode, replacesExisting);
        }
        map.forEach((locale, table) -> {
            if (langCode == null || langCode.equals(locale)) {
                boolean prevSort = SNBT.setShouldSortKeysOnWrite((boolean)true);
                HashMap<Path, CompoundTag> splittedFiles = new HashMap<Path, CompoundTag>();
                ((TranslationTableAccessor)table).langsplitter$getMap().forEach((id, value) -> {
                    String code;
                    String key;
                    String[] parts = id.split("\\.");
                    if (parts.length < 2) {
                        FTBQuestsLangSplitter.LOGGER.error("Id {} could not be split into type and code, skipping...", id);
                        return;
                    }
                    String type = parts[0];
                    QuestObjectType enumType = (QuestObjectType)QuestObjectType.NAME_MAP.get(type);
                    Path file = LangSplitterCommands.resolveFile(langFolder, locale, enumType, key = type + "." + (code = parts[1]));
                    if (file == null) {
                        return;
                    }
                    CompoundTag tag = splittedFiles.computeIfAbsent(file, newLangFile -> new CompoundTag());
                    value.ifLeft(l -> tag.putString(id, l)).ifRight(r -> {
                        ListTag list = new ListTag();
                        r.forEach(desc -> list.add((Object)StringTag.valueOf((String)desc)));
                        tag.put(id, (Tag)list);
                    });
                });
                splittedFiles.forEach((path, tag) -> {
                    if (!replacesExisting && Files.exists(path, new LinkOption[0])) {
                        ((CommandSourceStack)cmd.getSource()).sendSystemMessage((Component)Component.translatable((String)"ftbquestslangsplitter.commands.file_already_exists", (Object[])new Object[]{langFolder.relativize((Path)path).toString()}).withStyle(ChatFormatting.YELLOW));
                    } else {
                        SNBT.write((Path)path, (CompoundTag)tag);
                    }
                });
                SNBT.setShouldSortKeysOnWrite((boolean)prevSort);
            }
        });
        langsplitter$idToChapter = null;
        if (langCode == null) {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"ftbquestslangsplitter.commands.all_lang_file_split").withStyle(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"ftbquestslangsplitter.commands.lang_file_split", (Object[])new Object[]{langCode}).withStyle(ChatFormatting.GREEN), true);
        }
        return 1;
    }

    @Nullable
    private static Path resolveFile(Path baseFolder, String locale, QuestObjectType questType, String questKey) {
        return switch (questType) {
            case QuestObjectType.QUEST, QuestObjectType.TASK, QuestObjectType.QUEST_LINK -> {
                Path newFolder = baseFolder.resolve(locale).resolve("chapters");
                if (!LangSplitterCommands.createFolder(newFolder)) {
                    yield null;
                }
                String chapterFilename = (String)((Map)langsplitter$idToChapter.get()).get(questKey);
                if (chapterFilename == null) {
                    yield null;
                }
                yield newFolder.resolve(chapterFilename + ".snbt");
            }
            default -> {
                Path newFolder = baseFolder.resolve(locale);
                if (!LangSplitterCommands.createFolder(newFolder)) {
                    yield null;
                }
                yield newFolder.resolve(questType.getId() + ".snbt");
            }
        };
    }

    private static boolean createFolder(Path folder) {
        if (!Files.exists(folder, new LinkOption[0])) {
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                FTBQuestsLangSplitter.LOGGER.error("can't create lang folder {}: {}", (Object)folder, (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    private static boolean isSSP(CommandSourceStack s) {
        return s.getServer() != null && s.getServer().isSingleplayer();
    }

    static {
        langsplitter$idToChapterSupplier = () -> {
            HashMap<CallSite, String> result = new HashMap<CallSite, String>();
            for (QuestObjectBase object : ServerQuestFile.INSTANCE.getAllObjects()) {
                switch (object.getObjectType()) {
                    case QUEST: 
                    case TASK: 
                    case QUEST_LINK: {
                        Chapter chapter = object.getQuestChapter();
                        if (chapter == null) break;
                        String fileName = object.getQuestChapter().getFilename();
                        result.put((CallSite)((Object)(object.getObjectType().getId() + "." + object.getCodeString())), fileName);
                    }
                }
            }
            return result;
        };
    }
}

