/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.corelib.tag;

import de.maxhenkel.easyvillagers.corelib.tag.BlockTag;
import de.maxhenkel.easyvillagers.corelib.tag.FluidTag;
import de.maxhenkel.easyvillagers.corelib.tag.ItemTag;
import de.maxhenkel.easyvillagers.corelib.tag.SingleElementTag;
import de.maxhenkel.easyvillagers.corelib.tag.Tag;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class TagUtils {
    public static Tag<Block> AIR_BLOCK_TAG = new SingleElementTag<Block>(BuiltInRegistries.BLOCK.getKey((Object)Blocks.AIR), Blocks.AIR);
    public static Tag<Item> AIR_ITEM_TAG = new SingleElementTag<Item>(BuiltInRegistries.ITEM.getKey((Object)Items.AIR), Items.AIR);
    public static Tag<Fluid> AIR_FLUID_TAG = new SingleElementTag<Fluid>(BuiltInRegistries.FLUID.getKey((Object)Fluids.EMPTY), Fluids.EMPTY);

    @Nullable
    public static Tag<Block> getBlock(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = ResourceLocation.tryParse((String)name.substring(1));
            if (id == null) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_BLOCK_TAG;
            }
            Optional tag = BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)id));
            if (tag.isEmpty()) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_BLOCK_TAG;
            }
            return new BlockTag((HolderSet.Named<Block>)((HolderSet.Named)tag.get()));
        }
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)name);
        if (resourceLocation == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        if (!BuiltInRegistries.BLOCK.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        return new SingleElementTag<Block>(resourceLocation, (Block)BuiltInRegistries.BLOCK.get(resourceLocation));
    }

    public static Tag<Block> getBlock(String name) {
        return TagUtils.getBlock(name, false);
    }

    public static Tag<Block> getBlockTag(ResourceLocation name, boolean nullIfNotExists) {
        Optional tag = BuiltInRegistries.BLOCK.getTag(BlockTags.create((ResourceLocation)name));
        if (tag.isEmpty()) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_BLOCK_TAG;
        }
        return new BlockTag((HolderSet.Named<Block>)((HolderSet.Named)tag.get()));
    }

    public static Tag<Block> getBlockTag(ResourceLocation name) {
        return TagUtils.getBlockTag(name, false);
    }

    @Nullable
    public static Tag<Item> getItem(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = ResourceLocation.tryParse((String)name.substring(1));
            if (id == null) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_ITEM_TAG;
            }
            Optional tag = BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id));
            if (tag.isEmpty()) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_ITEM_TAG;
            }
            return new ItemTag((HolderSet.Named<Item>)((HolderSet.Named)tag.get()));
        }
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)name);
        if (resourceLocation == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        if (!BuiltInRegistries.ITEM.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        return new SingleElementTag<Item>(resourceLocation, (Item)BuiltInRegistries.ITEM.get(resourceLocation));
    }

    public static Tag<Item> getItem(String name) {
        return TagUtils.getItem(name, false);
    }

    public static Tag<Item> getItemTag(ResourceLocation name, boolean nullIfNotExists) {
        Optional tag = BuiltInRegistries.ITEM.getTag(ItemTags.create((ResourceLocation)name));
        if (tag.isEmpty()) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_ITEM_TAG;
        }
        return new ItemTag((HolderSet.Named<Item>)((HolderSet.Named)tag.get()));
    }

    public static Tag<Item> getItemTag(ResourceLocation name) {
        return TagUtils.getItemTag(name, false);
    }

    @Nullable
    public static Tag<Fluid> getFluid(String name, boolean nullIfNotExists) {
        if (name.startsWith("#")) {
            ResourceLocation id = ResourceLocation.tryParse((String)name.substring(1));
            if (id == null) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_FLUID_TAG;
            }
            Optional tag = BuiltInRegistries.FLUID.getTag(TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id));
            if (tag.isEmpty()) {
                if (nullIfNotExists) {
                    return null;
                }
                return AIR_FLUID_TAG;
            }
            return new FluidTag((HolderSet.Named<Fluid>)((HolderSet.Named)tag.get()));
        }
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)name);
        if (resourceLocation == null) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        if (!BuiltInRegistries.FLUID.containsKey(resourceLocation)) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        return new SingleElementTag<Fluid>(resourceLocation, (Fluid)BuiltInRegistries.FLUID.get(resourceLocation));
    }

    public static Tag<Fluid> getFluid(String name) {
        return TagUtils.getFluid(name, false);
    }

    public static Tag<Fluid> getFluidTag(ResourceLocation name, boolean nullIfNotExists) {
        Optional tag = BuiltInRegistries.FLUID.getTag(FluidTags.create((ResourceLocation)name));
        if (tag.isEmpty()) {
            if (nullIfNotExists) {
                return null;
            }
            return AIR_FLUID_TAG;
        }
        return new FluidTag((HolderSet.Named<Fluid>)((HolderSet.Named)tag.get()));
    }

    public static Tag<Fluid> getFluidTag(ResourceLocation name) {
        return TagUtils.getFluidTag(name, false);
    }
}

