/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.container.slots;

import ironfurnaces.items.ItemHeater;
import ironfurnaces.items.augments.ItemAugmentBlasting;
import ironfurnaces.items.augments.ItemAugmentSmoking;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class SlotIronFurnaceInputGenerator
extends Slot {
    BlockIronFurnaceTileBase te;

    public SlotIronFurnaceInputGenerator(BlockIronFurnaceTileBase te, int index, int x, int y) {
        super((Container)te, index, x, y);
        this.te = te;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayPlace(ItemStack stack) {
        if (!this.te.getItem(3).isEmpty()) {
            if (this.te.getItem(3).getItem() instanceof ItemAugmentBlasting) {
                return this.te.hasGeneratorBlastingRecipe(stack);
            }
            if (this.te.getItem(3).getItem() instanceof ItemAugmentSmoking) {
                if (stack.hasCraftingRemainingItem()) {
                    if (!this.te.getItem(6).isEmpty()) return false;
                    if (BlockIronFurnaceTileBase.getSmokingBurn(stack) <= 0) return false;
                    return true;
                }
                if (BlockIronFurnaceTileBase.getSmokingBurn(stack) <= 0) return false;
                return true;
            }
        }
        if (!(stack.getItem() instanceof ItemHeater)) return BlockIronFurnaceTileBase.isItemFuel(stack, RecipeType.SMELTING);
        return false;
    }

    public ItemStack safeInsert(ItemStack stack, int increment) {
        if (stack.hasCraftingRemainingItem() && stack.getCount() > 1 && this.getItem().isEmpty()) {
            super.safeInsert(stack.copyWithCount(1), increment);
            return stack.copyWithCount(stack.getCount() - 1);
        }
        return super.safeInsert(stack, increment);
    }

    public boolean isActive() {
        return this.te.isGenerator() && this.te.getAugmentGUI() == 0;
    }
}

