/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks.furnaces;

import ironfurnaces.gui.furnaces.BlockIronFurnaceScreenBase;
import ironfurnaces.init.Registration;
import ironfurnaces.util.StringHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockItemHeater
extends BlockItem {
    public BlockItemHeater(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        if (stack.get(Registration.ENERGY) != null) {
            tooltip.add((Component)Component.literal((String)StringHelper.displayEnergy((Integer)stack.get(Registration.ENERGY), 1000000).get(0)).withStyle(ChatFormatting.GOLD));
        }
        if (BlockIronFurnaceScreenBase.isShiftKeyDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.ironfurnaces.heater_block").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            tooltip.add((Component)Component.translatable((String)"tooltip.ironfurnaces.heater_block1").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
        } else {
            tooltip.add(StringHelper.getShiftInfoText());
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return stack.get(Registration.ENERGY) != null;
    }

    public int getBarWidth(ItemStack stack) {
        if (stack.get(Registration.ENERGY) != null) {
            int energy = (Integer)stack.get(Registration.ENERGY);
            return (int)(13.0 * ((double)energy / 1000000.0));
        }
        return 0;
    }

    public int getBarColor(ItemStack p_150901_) {
        return -8387072;
    }
}

