/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.misc;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PotBlock
extends Block {
    public static final VoxelShape THIN_SHAPE = Stream.of(Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0)).reduce(Shapes::or).get();
    public static final VoxelShape MEDIUM_SHAPE = Stream.of(Block.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.box((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0)).reduce(Shapes::or).get();
    public static final VoxelShape WIDE_SHAPE = Stream.of(Block.box((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), Block.box((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0)).reduce(Shapes::or).get();
    public static final VoxelShape THICK_SHAPE = Stream.of(Block.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.box((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)).reduce(Shapes::or).get();
    private final PotSize size;

    public PotBlock(PotSize size, BlockBehaviour.Properties properties) {
        super(properties);
        this.size = size;
    }

    public PotSize size() {
        return this.size;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (this.size.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> THIN_SHAPE;
            case 1 -> MEDIUM_SHAPE;
            case 2 -> WIDE_SHAPE;
            case 3 -> THICK_SHAPE;
        };
    }

    public static enum PotSize {
        THIN,
        MEDIUM,
        WIDE,
        THICK;

    }
}

