/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.misc;

import com.mojang.serialization.MapCodec;
import earth.terrarium.handcrafted.common.blocks.base.Hammerable;
import earth.terrarium.handcrafted.common.blocks.base.SimpleBlock;
import earth.terrarium.handcrafted.common.registry.ModSoundEvents;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KitchenHoodPipeBlock
extends SimpleBlock
implements Hammerable {
    public static final MapCodec<KitchenHoodPipeBlock> CODEC = KitchenHoodPipeBlock.simpleCodec(KitchenHoodPipeBlock::new);
    public static final BooleanProperty CORNER = BooleanProperty.create((String)"corner");
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.box((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0)).reduce(Shapes::or).get();
    public static final VoxelShape NORTH_SHAPE = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)16.0), Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)13.0)).reduce(Shapes::or).get();
    public static final VoxelShape EAST_SHAPE = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.box((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0), Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)3.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0)).reduce(Shapes::or).get();
    public static final VoxelShape SOUTH_SHAPE = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0), Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)12.0, (double)4.0)).reduce(Shapes::or).get();
    public static final VoxelShape WEST_SHAPE = Stream.of(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.box((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)12.0, (double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0)).reduce(Shapes::or).get();

    public KitchenHoodPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CORNER, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.getValue((Property)CORNER)).booleanValue()) {
            return SHAPE;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (direction) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CORNER, WATERLOGGED});
    }

    @Override
    public void onHammer(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CORNER, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)CORNER) == false))).setValue((Property)FACING, (Comparable)(side.getAxis().isHorizontal() ? side : (Direction)state.getValue((Property)FACING))), 3);
        level.playSound(null, pos, (SoundEvent)ModSoundEvents.HAMMER_STONE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

