/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.entity.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.integrateddynamics.RegistryEntries;

public class EntityItemTargetted
extends ItemEntity {
    private static final EntityDataAccessor<Float> TARGET_X = SynchedEntityData.defineId(EntityItemTargetted.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> TARGET_Y = SynchedEntityData.defineId(EntityItemTargetted.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> TARGET_Z = SynchedEntityData.defineId(EntityItemTargetted.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private LivingEntity targetEntity = null;

    public EntityItemTargetted(EntityType<? extends EntityItemTargetted> entityType, Level world) {
        super(entityType, world);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemTargetted(Level p_32001_, double p_32002_, double p_32003_, double p_32004_, ItemStack p_32005_) {
        this(p_32001_, p_32002_, p_32003_, p_32004_, p_32005_, p_32001_.random.nextDouble() * 0.2 - 0.1, 0.2, p_32001_.random.nextDouble() * 0.2 - 0.1);
    }

    public EntityItemTargetted(Level p_149663_, double p_149664_, double p_149665_, double p_149666_, ItemStack p_149667_, double p_149668_, double p_149669_, double p_149670_) {
        this((EntityType<? extends EntityItemTargetted>)((EntityType)RegistryEntries.ENTITYTYPE_ITEM_TARGETTED.get()), p_149663_);
        this.setPos(p_149664_, p_149665_, p_149666_);
        this.setDeltaMovement(p_149668_, p_149669_, p_149670_);
        this.setItem(p_149667_);
        this.lifespan = p_149667_.getItem() == null ? 6000 : p_149667_.getEntityLifespan(p_149663_);
    }

    public EntityItemTargetted(Level world, double x, double y, double z) {
        this(world, x, y, z, ItemStack.EMPTY);
        this.lifespan = Integer.MAX_VALUE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_X, (Object)Float.valueOf((float)this.getY()));
        builder.define(TARGET_Y, (Object)Float.valueOf((float)this.getY()));
        builder.define(TARGET_Z, (Object)Float.valueOf((float)this.getY()));
    }

    public void setTarget(float x, float y, float z) {
        this.getEntityData().set(TARGET_X, (Object)Float.valueOf(x));
        this.getEntityData().set(TARGET_Y, (Object)Float.valueOf(y));
        this.getEntityData().set(TARGET_Z, (Object)Float.valueOf(z));
    }

    public boolean isNoGravity() {
        return true;
    }

    public void setTarget(LivingEntity targetEntity) {
        this.targetEntity = targetEntity;
        this.setTarget((float)targetEntity.getX(), (float)targetEntity.getY(), (float)targetEntity.getZ());
    }

    public float getTargetX() {
        return ((Float)this.getEntityData().get(TARGET_X)).floatValue();
    }

    public float getTargetY() {
        return ((Float)this.getEntityData().get(TARGET_Y)).floatValue();
    }

    public float getTargetZ() {
        return ((Float)this.getEntityData().get(TARGET_Z)).floatValue();
    }

    public void tick() {
        super.tick();
        if (this.targetEntity != null) {
            this.setTarget((float)this.targetEntity.getX(), (float)this.targetEntity.getY(), (float)this.targetEntity.getZ());
        }
        double dx = this.getX() - (double)this.getTargetX();
        double dy = this.getY() - (double)(this.getTargetY() + 1.0f);
        double dz = this.getZ() - (double)this.getTargetZ();
        double strength = -0.1;
        double d = Mth.sqrt((float)((float)(dx * dx + dy * dy + dz * dz)));
        if (d > 1.0) {
            double m = 1.0 / (2.0 * Math.max(1.0, d)) * strength;
            this.setDeltaMovement(dx *= m, dy *= m, dz *= m);
            if (this.horizontalCollision) {
                this.setDeltaMovement(this.getDeltaMovement().x, 0.3, this.getDeltaMovement().z);
            }
        }
        if (!this.getCommandSenderWorld().isClientSide() && this.random.nextInt(5) == 0) {
            this.showEntityMoved();
        }
    }

    protected void showEntityMoved() {
        RandomSource rand = this.level().random;
        float scale = 0.1f;
        float red = rand.nextFloat() * 0.2f + 0.8f;
        float green = rand.nextFloat() * 0.2f + 0.8f;
        float blue = rand.nextFloat() * 0.1f + 0.1f;
        float ageMultiplier = (float)(rand.nextDouble() * 25.0 + 50.0);
        ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), this.getX(), this.getY() + 0.5, this.getZ(), 1, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, 0.0);
        if (rand.nextInt(5) == 0) {
            double dx = this.getX() - (double)(this.getTargetX() + 0.5f);
            double dy = this.getY() - (double)(this.getTargetY() + 1.0f);
            double dz = this.getZ() - (double)(this.getTargetZ() + 0.5f);
            double factor = rand.nextDouble();
            double x = this.getX() - dx * factor;
            double y = this.getY() - dy * factor;
            double z = this.getZ() - dz * factor;
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), x, y, z, 1, -0.02 * dx, -0.02 * dy, -0.02 * dz, 0.0);
        }
    }
}

