/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.IFullNetworkListener;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawNetworkData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawObserverData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;
import org.cyclops.integrateddynamics.network.packet.NetworkDiagnosticsNetworkPacket;

public class NetworkDiagnostics {
    private static final NetworkDiagnostics _INSTANCE = new NetworkDiagnostics();
    private final List<UUID> players = Lists.newArrayList();

    private NetworkDiagnostics() {
    }

    public static NetworkDiagnostics getInstance() {
        return _INSTANCE;
    }

    protected ServerPlayer getPlayer(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(uuid);
    }

    public synchronized void registerPlayer(ServerPlayer player) {
        if (!this.players.contains(player.getUUID())) {
            this.players.add(player.getUUID());
            for (INetwork network : NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getNetworks()) {
                this.sendNetworkUpdateToPlayer(player, network);
            }
        }
    }

    public synchronized void unRegisterPlayer(ServerPlayer player) {
        this.players.remove(player.getUUID());
    }

    public void sendNetworkUpdateToPlayer(ServerPlayer player, INetwork network) {
        ArrayList rawParts = Lists.newArrayList();
        for (INetworkElement iNetworkElement : network.getElements()) {
            if (!network.isValid(iNetworkElement) || !(iNetworkElement instanceof IPartNetworkElement)) continue;
            IPartNetworkElement partNetworkElement = (IPartNetworkElement)iNetworkElement;
            PartPos pos = partNetworkElement.getTarget().getCenter();
            long lastSecondDurationNs = network.getLastSecondDuration(iNetworkElement);
            rawParts.add(new RawPartData((ResourceKey<Level>)pos.getPos().getLevelKey(), pos.getPos().getBlockPos(), pos.getSide(), partNetworkElement.getPart().getTranslationKey(), lastSecondDurationNs));
        }
        ArrayList rawObservers = Lists.newArrayList();
        for (IFullNetworkListener fullNetworkListener : network.getFullNetworkListeners()) {
            if (!(fullNetworkListener instanceof IPositionedAddonsNetworkIngredients)) continue;
            IPositionedAddonsNetworkIngredients networkIngredients = (IPositionedAddonsNetworkIngredients)((Object)fullNetworkListener);
            Map<PartPos, Long> durations = networkIngredients.getLastSecondDurationIndex();
            for (Map.Entry<PartPos, Long> durationEntry : durations.entrySet()) {
                PartPos pos = durationEntry.getKey();
                rawObservers.add(new RawObserverData((ResourceKey<Level>)pos.getPos().getLevelKey(), pos.getPos().getBlockPos(), pos.getSide(), networkIngredients.getComponent().getName().toString(), durationEntry.getValue()));
            }
        }
        RawNetworkData rawNetworkData = new RawNetworkData(network.isKilled(), network.hashCode(), network.getCablesCount(), rawParts, rawObservers);
        IntegratedDynamics._instance.getPacketHandler().sendToPlayer((PacketBase)new NetworkDiagnosticsNetworkPacket(rawNetworkData.toNbt()), player);
    }

    public synchronized void sendNetworkUpdate(INetwork network) {
        Iterator<UUID> it = this.players.iterator();
        while (it.hasNext()) {
            UUID uuid = it.next();
            ServerPlayer player = this.getPlayer(uuid);
            if (player != null) {
                this.sendNetworkUpdateToPlayer(player, network);
                continue;
            }
            it.remove();
        }
    }

    public synchronized boolean isBeingDiagnozed() {
        return !this.players.isEmpty();
    }
}

