/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;

public class ValueTypeListProxyFactoryTypeRegistry
implements IValueTypeListProxyFactoryTypeRegistry {
    private static ValueTypeListProxyFactoryTypeRegistry INSTANCE = new ValueTypeListProxyFactoryTypeRegistry();
    private final Map<String, IValueTypeListProxyFactoryTypeRegistry.IProxyFactory> factories = Maps.newHashMap();

    private ValueTypeListProxyFactoryTypeRegistry() {
    }

    public static ValueTypeListProxyFactoryTypeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>, F extends IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P>> F register(F proxyFactory) {
        if (this.factories.containsKey(proxyFactory.getName())) {
            throw new RuntimeException(String.format("A list proxy factory by name '%s' already exists.", proxyFactory.getName()));
        }
        this.factories.put(proxyFactory.getName().toString(), proxyFactory);
        return proxyFactory;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> getFactory(ResourceLocation name) {
        return this.factories.get(name.toString());
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> Tag serialize(ValueDeseralizationContext valueDeseralizationContext, P proxy) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> factory = this.getFactory(proxy.getName());
        if (factory == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("No serialization factory exists for the list proxy type name '%s'.", proxy.getName()));
        }
        Tag serialized = factory.serialize(valueDeseralizationContext, proxy);
        CompoundTag tag = new CompoundTag();
        tag.putString("proxyName", proxy.getName().toString());
        tag.put("serialized", serialized);
        return tag;
    }

    @Override
    public <T extends IValueType<V>, V extends IValue, P extends IValueTypeListProxy<T, V>> P deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        if (!(value instanceof CompoundTag)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized list proxy value '%s' as it is not a CompoundTag.", value));
        }
        CompoundTag tag = (CompoundTag)value;
        if (!tag.contains("proxyName", 8)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized list proxy value '%s' as it is missing a proxyName.", value));
        }
        if (!tag.contains("serialized")) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized list proxy value '%s' as it is missing a serialized value.", value));
        }
        String name = tag.getString("proxyName");
        Tag actualValue = tag.get("serialized");
        IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<T, V, P> factory = this.getFactory(ResourceLocation.parse((String)name));
        if (factory == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("No deserialization factory exists for the list proxy type name '%s'.", name));
        }
        return factory.deserialize(valueDeseralizationContext, actualValue);
    }
}

