/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;

public abstract class ValueTypeListProxyBase<T extends IValueType<V>, V extends IValue>
implements IValueTypeListProxy<T, V> {
    private final ResourceLocation name;
    private final T valueType;

    public ValueTypeListProxyBase(ResourceLocation name, T valueType) {
        this.name = name;
        this.valueType = valueType;
    }

    @Override
    public T getValueType() {
        return this.valueType;
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public MutableComponent toCompactString() {
        MutableComponent sb = Component.literal((String)"");
        boolean first = true;
        sb.append("[");
        Iterator<V> iterator = this.iterator();
        if (iterator.hasNext()) {
            IValue value = (IValue)iterator.next();
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append((Component)value.getType().toCompactString(value));
            if (sb.getString().length() <= 10) {
                // empty if block
            }
            sb.append("...");
        }
        sb.append("]");
        return sb;
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueTypeList.ListFactoryIterator(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ValueTypeListProxyBase)) {
            return false;
        }
        ValueTypeListProxyBase other = (ValueTypeListProxyBase)obj;
        if (!ValueHelpers.correspondsTo(this.getValueType(), other.getValueType())) {
            return false;
        }
        if (this.isInfinite() || other.isInfinite()) {
            return false;
        }
        try {
            if (this.getLength() != other.getLength()) {
                return false;
            }
        }
        catch (EvaluationException e) {
            return false;
        }
        Object[] o = Iterables.toArray((Iterable)this, Object.class);
        Object[] o2 = Iterables.toArray((Iterable)other, Object.class);
        return Arrays.equals(o, o2);
    }

    public int hashCode() {
        if (this.isInfinite()) {
            return System.identityHashCode(this);
        }
        int result = 1;
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + this.getValueType().hashCode();
        for (V obj : this) {
            result = 37 * result + (obj != null ? obj.hashCode() : 0);
        }
        return result;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }
}

