/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.NoteBlockEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public final class NoteBlockEventReceiver {
    private static NoteBlockEventReceiver INSTANCE;
    private Multimap<NoteBlockInstrument, NoteBlockEvent.Play> previousEvents = HashMultimap.create();
    private Multimap<NoteBlockInstrument, NoteBlockEvent.Play> currentEvents = HashMultimap.create();

    private NoteBlockEventReceiver() {
    }

    public static NoteBlockEventReceiver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NoteBlockEventReceiver();
        }
        return INSTANCE;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onNoteEvent(NoteBlockEvent.Play event) {
        if (!event.isCanceled()) {
            this.currentEvents.put((Object)event.getInstrument(), (Object)event);
        }
    }

    @SubscribeEvent
    public void onTick(ServerTickEvent.Pre event) {
        Multimap<NoteBlockInstrument, NoteBlockEvent.Play> tmp = this.previousEvents;
        this.previousEvents.clear();
        this.previousEvents = this.currentEvents;
        this.currentEvents = tmp;
    }

    public Multimap<NoteBlockInstrument, NoteBlockEvent.Play> getEvents() {
        return this.previousEvents;
    }
}

