/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.render.valuetype.IngredientsValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;

public class RecipeValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final IValueTypeWorldRenderer INGREDIENTS_RENDERER = ValueTypeWorldRenderers.REGISTRY.getRenderer(ValueTypes.OBJECT_INGREDIENTS);

    @Override
    public void renderValue(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IValue value, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        Optional recipeOptional = ((ValueObjectTypeRecipe.ValueRecipe)value).getRawValue();
        if (recipeOptional.isPresent()) {
            IRecipeDefinition recipe = (IRecipeDefinition)recipeOptional.get();
            matrixStack.pushPose();
            matrixStack.scale(0.5f, 0.5f, 1.0f);
            matrixStack.pushPose();
            matrixStack.scale(0.3f, 0.3f, 1.0f);
            context.getFont().drawInBatch(L10NHelpers.localize((String)"gui.integrateddynamics.input_short", (Object[])new Object[0]), 8.0f, 15.0f, Helpers.RGBToInt((int)255, (int)255, (int)255), false, matrixStack.last().pose(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            context.getFont().drawInBatch(L10NHelpers.localize((String)"gui.integrateddynamics.output_short", (Object[])new Object[0]), 46.0f, 15.0f, Helpers.RGBToInt((int)255, (int)255, (int)255), false, matrixStack.last().pose(), renderTypeBuffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            matrixStack.popPose();
            matrixStack.translate(0.0f, 8.333333f, 0.0f);
            this.renderInput(context, partContainer, direction, partType, recipe, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
            matrixStack.translate(12.5f, 0.0f, 0.0f);
            INGREDIENTS_RENDERER.renderValue(context, partContainer, direction, partType, ValueObjectTypeIngredients.ValueIngredients.of(recipe.getOutput()), partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
            matrixStack.popPose();
        }
    }

    protected void renderInput(BlockEntityRendererProvider.Context context, IPartContainer partContainer, Direction direction, IPartType partType, IRecipeDefinition recipe, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay, float alpha) {
        int ingredientCount = recipe.getInputComponents().stream().mapToInt(c -> recipe.getInputs(c).size()).sum();
        ArrayList values = Lists.newArrayListWithExpectedSize((int)ingredientCount);
        int tick = (int)Minecraft.getInstance().level.getGameTime() / 30;
        for (IngredientComponent component : recipe.getInputComponents()) {
            IIngredientMatcher matcher = component.getMatcher();
            IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
            Stream<List<IPrototypedIngredient>> inputs = this.enhanceRecipeInputs(component, recipe);
            inputs.forEach(element -> values.add(componentHandler.toValue(((IPrototypedIngredient)IngredientsValueTypeWorldRenderer.prepareElementForTick(element, tick, () -> new PrototypedIngredient(component, matcher.getEmptyInstance(), matcher.getAnyMatchCondition()))).getPrototype())));
        }
        IngredientsValueTypeWorldRenderer.renderGrid(context, partContainer, direction, partType, values, partialTicks, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay, alpha);
    }

    protected <T, M> Stream<List<IPrototypedIngredient>> enhanceRecipeInputs(IngredientComponent<T, M> ingredientComponent, IRecipeDefinition recipe) {
        Stream inputs = recipe.getInputs(ingredientComponent).stream();
        if (ingredientComponent == IngredientComponent.ITEMSTACK) {
            IIngredientMatcher matcher = ingredientComponent.getMatcher();
            return inputs.map(input -> input.getAlternatives().stream().map(prototypedIngredient -> Collections.singletonList(prototypedIngredient)).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        return inputs.map(p -> Lists.newArrayList((Iterable)p.getAlternatives()));
    }
}

