/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MatrixHelpers;
import org.cyclops.integrateddynamics.block.shapes.CollisionContextBlockSupport;

public class PartRenderPosition {
    public static final PartRenderPosition NONE = new PartRenderPosition(-1.0f, -1.0f, -1.0f, -1.0f);
    private final float depthFactor;
    private final float widthFactor;
    private final float heightFactor;
    private final float widthFactorSide;
    private final float heightFactorSide;
    private final EnumFacingMap<VoxelShape> sidedCableCollisionBoxes;
    private final EnumFacingMap<VoxelShape> collisionBoxes;
    private final EnumFacingMap<VoxelShape> collisionBoxesBlockSupport;

    public PartRenderPosition(float selectionDepthFactor, float depthFactor, float widthFactor, float heightFactor) {
        this(selectionDepthFactor, depthFactor, widthFactor, heightFactor, widthFactor, heightFactor);
    }

    public PartRenderPosition(float selectionDepthFactor, float depthFactor, float widthFactor, float heightFactor, float widthFactorSide, float heightFactorSide) {
        this.depthFactor = depthFactor;
        this.widthFactor = widthFactor;
        this.heightFactor = heightFactor;
        this.widthFactorSide = widthFactorSide;
        this.heightFactorSide = heightFactorSide;
        float[][] sidedCableCollisionBoxesRaw = new float[][]{{0.375f, selectionDepthFactor, 0.375f, 0.625f, 0.375f, 0.625f}, {0.375f, 0.625f, 0.375f, 0.625f, 1.0f - selectionDepthFactor, 0.625f}, {0.375f, 0.375f, selectionDepthFactor, 0.625f, 0.625f, 0.375f}, {0.375f, 0.625f, 0.625f, 0.625f, 0.375f, 1.0f - selectionDepthFactor}, {selectionDepthFactor, 0.375f, 0.375f, 0.375f, 0.625f, 0.625f}, {0.625f, 0.375f, 0.375f, 1.0f - selectionDepthFactor, 0.625f, 0.625f}};
        this.sidedCableCollisionBoxes = EnumFacingMap.newMap();
        for (Direction side : Direction.values()) {
            float[] b = sidedCableCollisionBoxesRaw[side.ordinal()];
            this.sidedCableCollisionBoxes.put((Enum)side, (Object)Shapes.create((AABB)new AABB((double)b[0], (double)b[1], (double)b[2], (double)b[3], (double)b[4], (double)b[5])));
        }
        float min = (1.0f - widthFactor) / 2.0f + 0.0025f;
        float max = (1.0f - widthFactor) / 2.0f + widthFactor - 0.0025f;
        float[][] collisionBoxesRaw = new float[][]{{min, max}, {0.005f, selectionDepthFactor}, {min, max}};
        float[][] collisionBoxesBlockSupportRaw = new float[][]{{0.0f, 1.0f}, {0.0f, selectionDepthFactor}, {0.0f, 1.0f}};
        this.collisionBoxes = EnumFacingMap.newMap();
        this.collisionBoxesBlockSupport = EnumFacingMap.newMap();
        for (Direction side : Direction.values()) {
            float[][] bounds = new float[collisionBoxesRaw.length][collisionBoxesRaw[0].length];
            for (int i = 0; i < bounds.length; ++i) {
                bounds[i] = Arrays.copyOf(collisionBoxesRaw[i], collisionBoxesRaw[i].length);
            }
            MatrixHelpers.transform((float[][])bounds, (Direction)side);
            this.collisionBoxes.put((Enum)side, (Object)Shapes.create((AABB)new AABB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1])));
            float[][] boundsBS = new float[collisionBoxesBlockSupportRaw.length][collisionBoxesBlockSupportRaw[0].length];
            for (int i = 0; i < boundsBS.length; ++i) {
                boundsBS[i] = Arrays.copyOf(collisionBoxesBlockSupportRaw[i], collisionBoxesBlockSupportRaw[i].length);
            }
            MatrixHelpers.transform((float[][])boundsBS, (Direction)side);
            this.collisionBoxesBlockSupport.put((Enum)side, (Object)Shapes.create((AABB)new AABB((double)boundsBS[0][0], (double)boundsBS[1][0], (double)boundsBS[2][0], (double)boundsBS[0][1], (double)boundsBS[1][1], (double)boundsBS[2][1])));
        }
    }

    public float getDepthFactor() {
        return this.depthFactor;
    }

    public float getWidthFactor() {
        return this.widthFactor;
    }

    public float getHeightFactor() {
        return this.heightFactor;
    }

    public VoxelShape getSidedCableBoundingBox(Direction side) {
        return (VoxelShape)this.sidedCableCollisionBoxes.get((Object)side);
    }

    public VoxelShape getBoundingBox(Direction side, CollisionContext context) {
        if (context instanceof CollisionContextBlockSupport) {
            return (VoxelShape)this.collisionBoxesBlockSupport.get((Object)side);
        }
        return (VoxelShape)this.collisionBoxes.get((Object)side);
    }

    @Deprecated
    public VoxelShape getBoundingBox(Direction side) {
        return this.getBoundingBox(side, CollisionContext.empty());
    }

    public float getWidthFactorSide() {
        return this.widthFactorSide;
    }

    public float getHeightFactorSide() {
        return this.heightFactorSide;
    }

    public String toString() {
        return "PartRenderPosition{depthFactor=" + this.depthFactor + ", widthFactor=" + this.widthFactor + ", heightFactor=" + this.heightFactor + ", widthFactorSide=" + this.widthFactorSide + ", heightFactorSide=" + this.heightFactorSide + "}";
    }

    public String toCompactString() {
        return "df=" + this.depthFactor + ",wf=" + this.widthFactor + ",hf=" + this.heightFactor + ",wfs=" + this.widthFactorSide + ",hfs=" + this.heightFactorSide;
    }
}

