/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.INetworkIngredientsChannel;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.IIngredientChannelInsertPreConsumer;

public interface IPositionedAddonsNetworkIngredients<T, M>
extends IPositionedAddonsNetwork,
IIngredientComponentStorageObservable<T, M> {
    @Override
    public IngredientComponent<T, M> getComponent();

    public long getRateLimit();

    public IIngredientComponentStorage<T, M> getPositionedStorage(PartPos var1);

    public void setPositionedStorageFilter(PartPos var1, @Nullable PositionedAddonsNetworkIngredientsFilter<T> var2);

    @Nullable
    public PositionedAddonsNetworkIngredientsFilter<T> getPositionedStorageFilter(PartPos var1);

    default public Iterator<T> getRawInstances(PartPos pos) {
        Iterator it = this.getPositionedStorage(pos).iterator();
        PositionedAddonsNetworkIngredientsFilter<T> filter = this.getPositionedStorageFilter(pos);
        if (filter != null) {
            it = Iterators.filter((Iterator)it, filter::testView);
        }
        return it;
    }

    @Nullable
    default public IIngredientComponentStorage<T, M> getPositionedStorageUnsafe(PartPos pos) {
        DimPos dimPos = pos.getPos();
        Level level = dimPos.getLevel(true);
        if (level == null) {
            return null;
        }
        return this.getComponent().getBlockStorage(level, pos.getPos().getBlockPos(), level.getBlockState(dimPos.getBlockPos()), (BlockEntity)BlockEntityHelpers.get((BlockGetter)level, (BlockPos)dimPos.getBlockPos(), BlockEntity.class).orElse(null), (Object)pos.getSide());
    }

    public INetworkIngredientsChannel<T, M> getChannel(int var1);

    public IIngredientComponentStorageSlotted<T, M> getChannelSlotted(int var1);

    @Nullable
    default public <S, C> S getChannelExternal(BlockCapability<S, C> capability, int channel) {
        IIngredientComponentStorageWrapperHandler wrapperHandler = this.getComponent().getStorageWrapperHandler(capability);
        return (S)(wrapperHandler != null ? wrapperHandler.wrapStorage(this.getChannel(channel)) : null);
    }

    public Map<PartPos, Long> getLastSecondDurationIndex();

    public void resetLastSecondDurationsIndex();

    public void registerInsertPreConsumer(IIngredientChannelInsertPreConsumer<T> var1);

    public void unregisterInsertPreConsumer(IIngredientChannelInsertPreConsumer<T> var1);

    public Collection<IIngredientChannelInsertPreConsumer<T>> getInsertPreConsumers();
}

